/*
   find_of: find the output format corresponding for the field whose
   name we are given.

   Kenneth Ingham

   Copyright (C) 1987 The University of New Mexico
*/

#include "defs.h"

find_of(name, of_head, of)
struct out_fmt_st *of_head, *of;
char *name;
{
	struct rel_out_st *rf;
	struct col_out_st *cf;

	of->type = of_head->type;
	switch(of_head->type) {
		case RELATIVE:
			for (rf=of_head->out_fmt.rel_fmt; rf; rf=rf->next)
				if (strcmp(name, rf->name) == 0) {
					of->out_fmt.rel_fmt = rf;
					return True;
				}
			break;
		case COLUMN:
			for (cf=of_head->out_fmt.col_fmt; cf; cf=cf->next)
				if (strcmp(name, cf->name) == 0) {
					of->out_fmt.col_fmt = cf;
					return True;
				}
			break;
		default:
			fprintf(stderr, "internal error; unknown type %d",
				of_head->type);
			fprintf(stderr, " in find_of\n");
			exit(1);
	}

	return False;
}
