/*
   build_pct: build a percent change format for the parser.

   Kenneth Ingham

   Copyright (C) 1988 The University of New Mexico
*/

#include "defs.h"
#include "y.tab.h"

struct change_fmt_st *
build_pct(string, number)
struct number *number;
char *string;
{
	struct change_fmt_st *p;

	p = allocate(struct change_fmt_st);
	p->fmt.type = PERCENT;
	p->name = string;
	if (number->type == INTEGER)
		p->fmt.fmt.percent = (float)number->value.integer / 100.0;
	else
		p->fmt.fmt.percent = number->value.real / 100.0;

	free((char *)number);

	return p;
}
