.TH SOCKD 8
.SH NAME
sockd \- Internet firewall secure socket server
.SH SYNOPSIS
sockd
.SH DESCRIPTION
\fIsockd \fR is an internet secure socket server, it was designed
to provide connectivity for our user base to the internet via
the firewall hosts that keep the Internet out.  It is designed to
only accept connection from ``valid'' hosts (host internal to our
domain).  The determination of wheater or not to allow a connected
to be made is determined by the config file (/etc/sockd.conf).
.PP
The config file is parts from begining to end, with the first
fully matching line returning the accessiblity.  
The config file format is as follows:
.nf

.in +0.25i
#
# Format:
#  {permit, deny} src-addr src-mask [dst-addr dst-mask] [op dst-port]
#
#  Deny all host to every host finger service
#
deny      0.0.0.0 255.255.255.255 0.0.0.0 255.255.255.255 eq finger

#  Deny just lloyd.mips.com finger services to sgi.com
#
deny      lloyd.mips.com 0.0.0.0 sgi.com 0.0.0.0 eq finger

#
#  Allow all host on the 130.62 network access to the world
#
permit    130.62.0.0 0.0.255.255
.in
.fi

'#' starts the begining of a comment, appearing anywhere on the line.
The leading field of either ``permit'' or ``deny'' state if the
remainder of the host part matches to allow/disallow the access.
Fields two and three when masked together with the source host number,
are equal then this field is considered to match 
(ie. addr & ~mask == sourceaddr & ~mask).  Fields four and five
are the destination host address and mask, which is the same as
the source host address and mask.  The final field is the
port number for the socket, it is lead with the keyword
``eq'' for equal, ``neq'' for not equal, ``lt' for less,
and ``gt' for greater than the destination port number 
(ie. true if port {eq,gt,neq,lt} destination port).  Both the
destination hostname and destination port fields are optional.
.SH DIAGNOSTICS
\fIsockd \fR uses the ``daemon'' log class for syslog.
Socket errors (ie. host unreachable) and config file syntax errors
will be logged at the ``err'' level.  
``info'' is used to show sucesseful connection established and the
user who made them.  And ``crit'' is used to display possible 
security violations, either if a host failed the config file or
a reverse connection was attempted.
.SH FILES
/etc/sockd.conf		Access list configuration
.SH AUTHOR
David Koblas, koblas@sgi.com
