/*
 * Copyright 1991, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 */

#ifndef lint
static	char	sccsid[] = "@(#)logoutd.c	3.3	13:22:33	3/9/92";
#endif

#include <sys/types.h>
#include <stdio.h>
#include <signal.h>
#include <utmp.h>
#include "config.h"

#ifdef SUN4
#include <fcntl.h>
#endif

main ()
{
	int	i;
	struct	utmp	utmp;
	int	fd;
#if defined(BSD) || defined(SUN) || defined(SUN4)
	char	tty_name[BUFSIZ];
	int	tty_fd;
#endif

	for (i = 0;close (i) == 0;i++)
		;

#ifdef	NDEBUG
#ifdef	USG
	setpgrp ();
#endif
#if defined(BSD) || defined(SUN) || defined(SUN4)
	setpgid (getpid ());
#endif
	signal (SIGHUP, SIG_IGN);

	if (fork () > 0)
		exit (0);
#endif
	while (1) {
#ifdef	NDEBUG
		sleep (60);
#endif
		if ((fd = open ("/etc/utmp", 0)) == -1)
			continue;

		while (read (fd, &utmp, sizeof utmp) == sizeof utmp) {
#ifdef	USG_UTMP
			if (utmp.ut_type != USER_PROCESS)
				continue;
			if (isttytime (utmp.ut_user, utmp.ut_line, time (0)))
				continue;
#endif
#ifdef BSD_UTMP
			if (utmp.ut_name[0] == '\0')
				continue;
			if (isttytime (utmp.ut_name, utmp.ut_line, time (0)))
				continue;
#endif
#ifdef	USG_UTMP
			kill (- utmp.ut_pid, SIGHUP);
			sleep (10);
			kill (- utmp.ut_pid, SIGKILL);
#endif
#if defined(BSD) || defined(SUN) || defined(SUN4)

			/*
			 * vhangup() the line to kill try and kill
			 * whatever is out there using it.
			 */

			strcat (strcpy (tty_name, "/dev/"), utmp.ut_line);
			if ((tty_fd = open (tty_name, O_RDONLY|O_NDELAY)) == -1)
				continue;

			vhangup (tty_fd);
			close (tty_fd);
#endif
		}
		close (fd);
	}
}
