/*
    PMICS -- PM interface for playing chess on internet chess server
    Copyright (C) 1994  Kevin Nomura

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Author can be reached at email: chow@netcom.com
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pmics.hh"
#define INCL_DOSFILEMGR
#define INCL_DOSDEVIOCTL
#define INCL_DOSDEVICES
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#define INCL_DOSEXCEPTIONS
#define INCL_WINMESSAGEMGR
#include <os2.h>
#include <ievtdata.hpp>
#include <iexcbase.hpp>
#include "session.hh"
#include "wcomm.hh"
#include <strstrea.h>

extern strstream commStream;

#define HF_STDIN 0
#define HF_STDOUT 1
#define PIPESIZE 16383

static VOID _System PipeListen(ULONG readPipe)
{
  char          buf[PIPESIZE+1];
  ULONG         cbRead;

  IFUNCTRACE_DEVELOP();
  ITRACE_DEVELOP(IString("listening to pipe ") + IString(readPipe));
  if (! IThread::current().isPMInitialized())
    IThread::current().initializePM();

  while(1)
    {
      DosRead(readPipe, (PVOID)buf, PIPESIZE, &cbRead);
      buf[cbRead] = 0;		// for debug print
      commStream.clear();
      commStream.write(buf, cbRead);
      ITRACE_DEVELOP(IString("cbRead ") + IString(cbRead) + IString(buf));

      hComm.postEvent(MSG_COM_IN);
    }
}


ADosSession::ADosSession()
{
  // DosExecPgm stuff
  CHAR          LoadError[CCHMAXPATH];
  RESULTCODES   ReturnCodes;
  ULONG         Pid;

  // pipe games stuff
  HFILE         hfOSave, hfONew = HF_STDOUT;
  HFILE         hfOR, hfOW;
  HFILE         hfISave, hfINew = HF_STDIN;
  HFILE         hfIR, hfIW;
  APIRET        rc;

  IFUNCTRACE_DEVELOP(); fflush(stdout);

  isActive = false;		// preset

  // redirect stdout
  DosDupHandle(HF_STDOUT, &hfOSave);  // save stdout
  DosCreatePipe(&hfOR, &hfOW, PIPESIZE);   // pipe for redirecting stdout
  DosDupHandle(hfOW, &hfONew);        // change stdout to the pipe

  // redirect stdin
  DosDupHandle(HF_STDIN, &hfISave);   // save stdin
  DosCreatePipe(&hfIR, &hfIW, PIPESIZE);   // pipe for redirecting stdin
  DosDupHandle(hfIR, &hfINew);        // switch stdin to the pipe

  // kick off a program with the gimmicked file handles
  rc = DosExecPgm(LoadError,            // object name buffer
                  sizeof(LoadError),    // length of object name buffer
                  EXEC_ASYNC,           // async/trace flags
                  (PSZ)"",              // argument string
                  (PSZ)0,               // environment string
                  &ReturnCodes,         // termination codes
                  (PSZ)"D:\\OS2\\CMD.EXE");	// child program

  childPID = ReturnCodes.codeTerminate;   // pull out PID of child
  DosClose(hfOW);   // voodoo stuff the manual says to do
  DosClose(hfIR);

  hfONew = HF_STDOUT;
  DosDupHandle(hfOSave, &hfONew);    // bring stdout back
  hfINew = HF_STDIN;
  DosDupHandle(hfISave, &hfINew);    // bring stdin back

  if (rc != 0) {
    throw IException(IString("DosExecPgm failed for D:\\OS2\\CMD.EXE, rc = ") + IString(rc) + ", LoadError = " + IString(LoadError));
  }

  // initiate a task to Listen to the pipe
  pthr = new IThread(&PipeListen, (unsigned long)hfOR);
  writePipe = hfIW;

//  write("dir\n");

  write("echo NOTE: your keystrokes will not echo until you hit ENTER!\n");
  
  isActive = true;
  return;   // show ok
}


ADosSession::~ADosSession()
{
  IFUNCTRACE_DEVELOP();
  ITRACE_DEVELOP(IString("kill pid ") + IString((int)childPID));
  if (pthr) delete pthr;
  DosKillProcess(DKP_PROCESS, childPID);
}


ADosSession::write(char *s)
{
  ULONG cbWritten, n;

  IFUNCTRACE_DEVELOP();
//  DosGetDateTime(&keyDt);
  for (n=0; s[n]; n++) {
    ITRACE_DEVELOP(IString("write char: ") + IString((int)s[n]));
    if (s[n] == '\012')
      {
        DosWrite(writePipe, (PVOID)"\015", 1, &cbWritten);
        DosWrite(writePipe, (PVOID)(s+n), 1, &cbWritten);
      }
    else if (s[n] == '\015')
      {
        DosWrite(writePipe, (PVOID)(s+n), 1, &cbWritten);
        DosWrite(writePipe, (PVOID)"\012", 1, &cbWritten);
      }
    else
      DosWrite(writePipe, (PVOID)(s+n), 1, &cbWritten);
  }
}
