#ifndef PMICS_INCLUDED
#define PMICS_INCLUDED

#define IC_TRACE_DEVELOP
#include <itrace.hpp>
#include <ihandle.hpp>

extern IWindowHandle    hComm;
extern IWindowHandle    hBoard;
extern IWindowHandle    hMain;

#define SCORE_FILE      "pmics.sco"   // game scores
#define TRUE            1
#define FALSE           0

/* access functions for MOVE and SQUARE */
#define FROMSQ(move)    (((move)>>8) & 0xff)
#define TOSQ(move)      ((move) & 0xff)
#define MOVE(fromsq,tosq) (((fromsq) << 8) | ((tosq) & 0xff))
#define RANK(sq)        (((sq) >> 3) & 0x7)
#define FILE(sq)        ((sq) & 0x7)
#define SQ(rank,file)   (((rank) << 3) | ((file) & 0x7))

#define NUM_PUSHBUTTONS 11

#define  WND_PMICS          5000
#define  WND_CANVAS         5070
#define  WND_CANVAS2        5071
#define  WND_BOARD          5075
#define  WND_COMM           5076
#define  WND_STAT           5077
#define  WND_BUTT           5078
#define  WND_MOVELIST       5082
#define  WND_WCLOCK         5083
#define  WND_BCLOCK         5084
#define  WND_WNAME          5085
#define  WND_BNAME          5086
#define  WND_GAME_NAME      5087
#define  WND_MOVE           5089
#define  WND_HELP           5100
#define  WND_SUBHELP        5101
#define  WND_BUTTON_BASE    5255     /* reserved: 11 ids */

#define  MI_OPT             WM_USER+103
#define  MI_PROMOTION       WM_USER+104
#define  MI_PROMOTION_Q     WM_USER+170
#define  MI_PROMOTION_R     WM_USER+171
#define  MI_PROMOTION_B     WM_USER+172
#define  MI_PROMOTION_N     WM_USER+173
#define  MI_AUTOFLAG        WM_USER+105
#define	 MI_QUIT 	    WM_USER+106
#define	 MI_FLIP	    WM_USER+107
#define  MI_OPT_2           WM_USER+109
#define	 MI_SMALL           WM_USER+110
#define  MI_MEDIUM          WM_USER+111
#define  MI_LARGE           WM_USER+112
#define	 MI_OPT_3           WM_USER+113
#define  MI_NEWBOARD	    WM_USER+116
#define  MI_MOVES_ITEM      WM_USER+122
#define  MI_BOARD_LOCK      WM_USER+122
#define  MI_BOARD_UPDATE    WM_USER+124
#define  MI_BOARD_REPLOT    WM_USER+125
#define  MI_FONT            WM_USER+128
#define  MI_TRACE           WM_USER+129
#define  MI_HELP            WM_USER+140
#define  MI_PRODUCTINFO     WM_USER+141
#define  MI_HELPINDEX       WM_USER+142
#define  MI_HELPINDEX2      WM_USER+143
#define  MI_SESSION         WM_USER+150
#define  MI_CR2LF           WM_USER+151
#define  MI_BS2DEL          WM_USER+152
#define  MI_LOCAL_ECHO      WM_USER+153
#define  MI_ICSCMD_FLAG     WM_USER+310
#define  MI_ICSCMD_RESIGN   WM_USER+311
#define  MI_ICSCMD_REFRESH  WM_USER+312
#define  MI_ICSCMD_DRAW     WM_USER+313

#define  MSG_COM_IN         WM_USER+400
#define  MSG_COM_FONT       WM_USER+430
#define  MSG_BOARD_UPDATE   WM_USER+401
#define  MSG_BOARD_REPLOT   WM_USER+402
#define  MSG_BOARD_FLIP     WM_USER+403
#define  MSG_BOARD_WHITE_AT_BOTTOM    WM_USER+404
#define  MSG_BOARD_WHITE_AT_TOP       WM_USER+405

#define  MSG_STAT_UPDATE   WM_USER+500
#define  MSG_STAT_WHITE_AT_BOTTOM  WM_USER+501
#define  MSG_STAT_WHITE_AT_TOP  WM_USER+502
#define  MSG_STAT_WHITE_AT_OTHER  WM_USER+503
#define  MSG_STAT_WHITE_ONMOVE  WM_USER+504
#define  MSG_STAT_BLACK_ONMOVE  WM_USER+505

#define  CLR_WHITE_PIECE    CLR_WHITE
#define  CLR_BLACK_PIECE    CLR_BLACK
#define  CLR_WHITE_SQUARE   CLR_GREEN
#define  CLR_BLACK_SQUARE   CLR_BROWN

#endif
