/*
    PMICS -- PM interface for playing chess on internet chess server
    Copyright (C) 1994  Kevin Nomura

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Author can be reached at email: chow@netcom.com
*/
#include <iapp.hpp>
#include <iaccel.hpp>
#include "pmics.hh"
#include "wpmics.hh"
#include "session.hh"
#include "engcom.hh"
#include <imsgbox.hpp>
#include <iexcbase.hpp>		// IException

#include <ithread.hpp>
#include <stdio.h>

IWindow     *mainWin;
PmicsWindow *mainWindow = NULL;
ASession    *aSession = NULL;
EngineComm  *aEngineComm = NULL;

int intOption(IString s);
IString stringOption(IString s);

int main(int argc, char **argv)
{
  IFUNCTRACE_DEVELOP();

  try {
    IApplication::current().setArgs(argc, argv);
    IThread::current().initializePM(100);
    ITRACE_DEVELOP("QueueSize now " + IString(IThread::current().queueSize()));
    mainWin = mainWindow = new PmicsWindow(WND_PMICS);

    // start communication session
    if (intOption("dos")) {
      aSession = new ADosSession();
    }
#ifdef TCP_SESSION
    else if (intOption("tcp")) {
      aSession = new ATcpSession();
    }
#endif
    else {
      aSession = new AComSession(); 
    }
    
    // open engine pipe
    aEngineComm = new EngineComm;

    IApplication::current().run();
  }
  /****************************************************
   * catchall for exceptions, both pmics and ICLUI
   ****************************************************/
  catch (IException &xcp) {
    IMessageBox boom(IWindow::desktopWindow());
    ITRACE_DEVELOP(IString("exception caught: ") + xcp.text());
    boom.setTitle("PMICS error");
    boom.show(xcp.text(),
	      IMessageBox::errorIcon |
	      IMessageBox::okButton |
	      IMessageBox::applicationModal |
	      IMessageBox::moveable         );
  }
  
  if (aSession) delete aSession;
  if (mainWindow) delete mainWindow;
}


/**************************************************************************
 * FUNCTION:    intOption
 *
 * DESCRIPTION: look for a command-line option of the form -xxx
 *              if -xxx is present then return 1;
 *              if -xxx=n is present where n is an integer, return n
 *              else return 0 (ambiguous with -xxx=0)
 *               
 **************************************************************************/
int intOption(IString s)
{
  IString arg;
  int result = 0;
  char c;

  for (int n=1; n<IApplication::current().argc(); n++) {
    c = IApplication::current().argv(n)[1];
    if (c != '-' && c != '/')
      break;			// switch must be introduced by - or /
    arg = IApplication::current().argv(n).subString(2);

    if (arg.subString(1, s.length()) == s) {
      if (arg.length() == s.length()) {
	result = 1;
	break;
      }
      if (arg[s.length()+1] == '=') {
	result = arg.subString(s.length()+2).asInt();
	break;
      }
    }
  }
  ITRACE_DEVELOP("intOption: " + s + " = <" + IString(result) + ">");
  return result;
}

/**************************************************************************
 * FUNCTION:    stringOption
 *
 * DESCRIPTION: look for a command-line option of the form -xxx
 *              if -xxx is present then return IString("y") (eqv to -xxx=y)
 *              if -xxx=s is present then return IString(s)
 *              else return IString("")
 *               
 **************************************************************************/
IString stringOption(IString xxx)
{
  IString arg;
  IString result;
  char c;

  for (int n=1; n<IApplication::current().argc(); n++) {
    c = IApplication::current().argv(n)[1];
    if (c != '-' && c != '/')
      break;			// switch must be introduced by - or /
    arg = IApplication::current().argv(n).subString(2);

    if (arg.subString(1, xxx.length()) == xxx) {
      if (arg.length() == xxx.length())	{ // no argument
	result = "y";
	break;
      }
      if (arg[xxx.length()+1] == '=') {	// has an argument
	if (arg[xxx.length()+2] != '"') {
	  result = arg.subString(xxx.length()+2);
	  break;
	}
	// string is quoted.  consume this and following argv's until
	// termination quote is reached.
	else {
	  result = arg.subString(xxx.length()+3);
	  for (n++; n<IApplication::current().argc(); n++) {
	    if (arg[arg.length()] == '"')
	      break;
	    arg = IApplication::current().argv(n);
	    result += arg;
	  }
	  result = result.stripTrailing('"');
	}
      }
    }
  }
  ITRACE_DEVELOP("stringOption: " + xxx + " = <" + result + ">");
  return result;
}

int getIntOption(IString s, int def)
{
  int opt;
  opt = intOption(s);
  return (opt) ? opt : def;
}

IString getStringOption(IString s, IString def)
{
  IString opt;
  opt = stringOption(s);
  return (opt != IString("")) ? opt : def;
}

