/*
 *    UPROOT.TTP
 *
 * A program to make TOS forget its directory tree for a drive.
 * Drive letter taken from command line  (Default: C).
 * Waits for keypress when done, unless a second argument is given.
 * Use periodically on RAM and HARD disks to avoid TOS bug.
 *
 *               >>> WARNING <<<
 *
 *    Using this program does _NOT_ break the 40-folder limit!
 *      It only avoids the crashes that occur after the same
 *             few folders are reopened many times.
 *
 *  By Moshe Braner,        870401.
 */

#include <osbind.h>

#define WORD    int    /* 16 bits: 'int' in Megamax */

typedef struct bpb {
    WORD    recsiz;
    WORD    clsiz;
    WORD    clsizb;
    WORD    rdlen;
    WORD    fsiz;
    WORD    fatrec;
    WORD    datrec;
    WORD    numcl;
    WORD    bflags;
} BPB;

/*
 * routine to send a one-shot media-definitely-changed
 * message to GEMDOS (via Rwabs).
 */
extern dmch();
extern drvnum();
asm
{
dmch:    MOVEA.W    #0x476,A0        /* Rwabs() vector    */
    LEA    oldvec(PC),A1
    MOVE.L    (A0),(A1)        /* save old        */
    LEA    tmpvec(PC),A1
    MOVE.L    A1,(A0)            /* poke new        */
    RTS
tmpvec:    MOVE.W    drvnum(PC),D0
    CMP.W    14(A7),D0        /* target drive?    */
    BEQ.S    now
    MOVE.L    oldvec(PC),A0        /* do normal        */
    JMP    (A0)
now:    MOVE.L    oldvec(PC),0x476    /* restore normal Rwabs    */
    MOVEQ    #-14,D0            /* "media has changed"    */
    RTS
oldvec:    DC.L    0
drvnum:    DC.W    0
}

/*
 * Print a long integer as a string.
 */
prtli(n)
    register long n;
{
    register char *p;
    char    a[20];

    p = &a[19];
    *p = 0;
    do {
        *(--p) = (n%10) + '0';
        n /= 10;
    } while (n);
    Cconws(p);
}

main(argc, argv)
    int    argc;
    char    *argv[];
{
    register int c;
    int    drv, bps, spc, verbose;
    long    bytes, dinfo[4];
    BPB    *bpb;

    /* get command line arguments */

    c = 'C';        /* default    */
    if (argc > 1) {
        c = argv[1][0];
        if (c>='a' && c<='p')
            c += 'A'-'a';
        if (c < 'A' || c > 'P')
            c = 'C';
    }
    drv = c-'A';        /* 0=A, 1=B, ... */

    if (argc > 2)
        verbose = 0;
    else
        verbose = 1;    /* default    */

    if (verbose)
        Cconws("\033E\r\n\n\tUPROOT\t\tv1.0\t\tby Moshe Braner\r\n\n");

    /* get disk parameters from bios parameter block */

    bpb = (BPB *) Getbpb(drv);
    bps = bpb->recsiz;        /* bytes per sector        */
    spc = bpb->clsiz;        /* sectors per cluster        */

    /*
     * Do our main thing:
     *     Force a media-HAS-changed message onto GEMDOS!
     */

    *((int *)&drvnum) = drv;
    Supexec(&dmch);        /* install media-HAS-changed code    */
    Dfree(dinfo,drv+1);    /* call it through GEMDOS        */

    if (! verbose)
        exit(0);

    Cconws("\tDrive has ");
    bytes = dinfo[0] * spc * bps;
    prtli(bytes);
    Cconws(" bytes free out of ");
    bytes = dinfo[1] * spc * bps;
    prtli(bytes);
    Cconws("\r\n\n\tHit any key ");
    Cnecin();
}
