/*
   INC_DATE.C
   by Domenico De Vitto (ddv@uk.ac.bton.unix)
   This increments the date at bootup so that make doesn't do odd things...
   (this is the only file)
   Compiled with Heat n Serve C 1.40 on 16/4/93
*/
#include <stdio.h>
#include <osbind.h>

/* test routine checks that the date is set to d/m/y ie 16/4/1993
void checkdate(d,m,y)
unsigned int d,m,y;
{
unsigned int d2,m2,y2,date;
  date=Tgetdate();
  d2=date & (1+2+4+8+16);
  m2=(date & (32+64+128+256)) >>5;
  y2=(date >> 9)+1980;
  printf("System date now: %u/%u/%u  should be %u/%u/%u  ",d2,m2,y2,d,m,y);
  if (d2!=d || m2!=m || y2!=y)
    { printf("\007\007\007Program failed."); getchar(); }
  putchar('\n');
}
*/

void main()
{
  FILE *fd;
  unsigned int a,date,d,m,y;
  setbuf(stdin,NULL);

  printf("- inc_date v1.10 by D De Vitto 16/4/93 -\n");
/* get date from system */
  date=Tgetdate();
  d=date & (1+2+4+8+16);
  m=(date & (32+64+128+256)) >>5;
  y=(date >> 9)+1980;
  printf(" Current BDOS date : %u/%u/%u\n",d,m,y);

/* get date from file */
/* NB for AUTO folder prgs the current directory is the root of the boot
   drive, so normally this file is read/created there.
*/
  fd=fopen("inc_date.inf","r");
  if (fd!=NULL)
    {
    fscanf(fd,"%u/%u/%u",&d,&m,&y);
    printf(" Using date info in \"inc_date.inf\" : %u/%u/%u\n",d,m,y);
    }
  fclose(fd);

/* increment the date */

  if (d<28) d++;
  else
    { d=1;
      if (m<12) m++;
      else
        { m=1;
          if (y<2050) y++;
          else y=1993;
        }
    }


/* set the date into the system */
  printf(" Setting date to : %u/%u/%u\n",d,m,y);
  date=((y-1980) << 9) + (m << 5) + d;
  Tsetdate(date);

/* check was right... */
/*  checkdate(d,m,y); */

/* save the date to file */
  printf(" Saving date to \"inc_date.inf\" ... ");
  fd=fopen("inc_date.inf","w");
  if (fd!=NULL)
    {
    fprintf(fd,"%u/%u/%u\n",d,m,y);
    printf("Done.\n");
    fclose(fd);
    }
  else
    {
    printf("\007\007unable to open file.\n");
    fclose(fd);
    }
}

