/*
 *  Binary-to-hex utility -- conquer BITNET mailers!!
 *
 *  Rewrite binary file as a text file containing hexadecimal
 *  digits
 *
 *  Michal Jaegermann, 19 March 1989
 */

#include <stdio.h>
/* LWIDTH bytes --- will put twice as many characters on output line */
#define LWIDTH 32

main(argc, argv)
int argc;
char **argv;
{
	int ch, count = 0;
	FILE *fin, *fout;
	
	if (argc != 3) {
		fprintf(stderr, "usage: %s <infile> <outfile>\n", argv[0]);
		exit(1);
	}
	
	if (NULL == (fin = fopen(argv[1],"rb"))){
		fprintf(stderr, "cannot find input file %s", argv[1]);
	}
	if (NULL == (fout = fopen(argv[2],"w"))){
		fprintf(stderr, "cannot open output file %s", argv[2]);
	}
	
	fprintf(fout, "BEGIN %s\n", argv[1]);
	while (EOF != (ch = getc(fin))) {
		fprintf(fout, "%02x", (unsigned) ch);
		if (LWIDTH == (++count)) {
			count = 0;
			fprintf(fout,"\n");
		}
	}
	fprintf(fout, "\nEND\n");
	/*
	 * we do not care if we have an extra new line - restore
	 * utility will gobble it in any case
	 */
	exit(0);
}

