/*
 *  Hex-to-binary utility -- conquer BITNET mailers!!
 *
 *  Restore binary file from a text file with hexadecimal digits
 *
 *  Michal Jaegermann, 19 March 1989
 */

#include <stdio.h>
#include <string.h>
#define  BSIZE 128

main(argc, argv)
int argc;
char **argv;
{
	int ch, count = 0;
	FILE *fin, *fout;
	char inbuf[BSIZE+2];
	char outname[14];
	
	if (argc != 2) {
		fprintf(stderr, "usage: %s <infile>\n", argv[0]);
		exit(1);
	}
	
	if (NULL == (fin = fopen(argv[1],"r"))){
		fprintf(stderr, "cannot find input file %s\n", argv[1]);
		exit(1);
	}
	/* search for BEGIN line */
	for(;;) {
		if (NULL == fgets(inbuf, BSIZE, fin)){
			fprintf(stderr, "No BEGIN line\n");
			fclose(fin);
			exit(1);
		}
		sscanf(inbuf, " %12s", outname);
		if (0 == strcmp("BEGIN", outname)) break;
		if ('\n' != inbuf[strlen(inbuf) - 1]) {
			while ('\n' != (ch = getc(fin))) {
				; /* eat a remainder of a line */
			}
		}
	}
	
	/* get an output file name */
	sscanf(inbuf, " %*5s %12s", outname);	
	
	if (NULL == (fout = fopen(outname,"wb"))){
		fprintf(stderr, "cannot open output file %s", outname);
		fclose(fin);
		exit(1);
	}
	
	/* do the actual job */	
	while (1 == fscanf(fin, " %02x", &ch)) {
		putc((char) ch, fout);
	}
	fclose(fout);

	/* just a check for completeness */
	fscanf(fin, " %3s", inbuf);
	if (0 != strcmp("ND", inbuf)) { /* a little bit of cheating */
		fprintf(stderr, "%s -- END line not found in %s\n",
				inbuf, argv[1]);
	}
	fclose(fin);
	exit(0);
}

