       GETTEXT                ST-UNIX User's Manual                GETTEXT



       COMMAND
            gettext - locally print, display or capture text files from a
                      UNIX host.

       FORMAT
            gettext [%][+]<filename>

       DESCRIPTION
            pGettextq can either print, display or capture a text file 
            that exists on a UNIX host.  It is important that certain 
            information be placed in the .cshrc and .login files of the host
            as follows:

            The .login file -

                   alias incat 'setenv FOOBAR x ; /bin/csh ; unsetenv FOOBAR'
                   alias outcat 'stty echo ; exit'

            The .cshrc file -

                   if ($?FOOBAR) then
                      set prompt = ''
                      stty -echo
                      echo 'ready'
                   endif

            Furthermore, any prompt settings in the .cshrc file should be
            specified before the above if expression.

            The operation of pgettextq at execution is as follows: the
            'incat' command is issued to the host.  The host sets up a csh
            with no prompt and no echo and sends back 'ready'.  pGettextq
            responds to the 'ready' signal by sending 'cat <filename>'.  The
            file is cat'ed and printed locally.  Upon completion of the text
            transmission a timer times out, the outcat command is issued to
            the host (restoring echo and prompt) and execution on the ST is
            terminated.

       OPTIONS
            % = the text is both printed and displayed

            + = the text is displayed only

            no % or + = the text is printed only but a 120 character
                file head is displayed (thus error messages are seen).

       NOTES
            To capture text simply redirect output, for example by

                  gettext +foo.bar > foo.bar
              
            Execution may be stopped at any time by pressing ^C or Return.


       Printed 7/4/88                                    Page 1
