#include<stdlib.h>
#include<stdio.h>
#include<tos.h>
#include<string.h>

typedef enum {FALSE, TRUE} boolean;

#define ST_LORES 0
#define ST_HIRES 2

boolean set_st_hires(void);
boolean get_cookie(char *cookie, long *value);

main()
{ 
  if (set_st_hires())
  	puts("Resolution changed to ST-high.");
  else
  	puts("Resolution not changed.");
	return 0;
}

boolean set_st_hires(void)
{ long _VDO;
   
  /* Change resolution to ST_HIRES */
  /* First check whether we started from ST_LORES */
  /* We may already be in a higer resolution */

   
  if (Getrez() > ST_LORES)
  	return FALSE;

	/* Get the _VDO (video) cookie, if it doesn't exist we have */
	/* some old TOS version, no resolution change */
	
	if (!get_cookie("_VDO", &_VDO) || _VDO < 0x200)
		return FALSE;
		
	/* values for _VDO are: */
	/* 0x000 for normal ST, 0x100 for STe and 0x200 for TT */
	/* return if we do not have TT video hardware */	
  	 
  /* change the resolution to ST_HIRES */	
	Setscreen((long *) -1,(long *) -1, 2);
	
  /* Set colors to normal monochrome*/
	EsetColor(254, 0);
	EsetColor(255, 4095);

	return TRUE;
}

/* function get_cookie*/
/* return true if cookie found, cookie value in value */
/* adapted from Rolf Kotzian, St Computer januar 91 */

boolean get_cookie(char *cookie, long *value)
{	long old_stack;
	long *cookiejar;
	
	/* get pointer to cookiejar*/
	if ((int) Super((long *) 1L)== -1) 		/*already in supervisor mode*/
		cookiejar=*((long **) 0x5a0L);
	else
	{	old_stack=Super(0L);
		cookiejar=*((long **) 0x5a0L);
  	Super((void *) old_stack);
	}
		
	if (!cookiejar)          /*No cookie jar*/
		return FALSE;
	
	do
	{	if (!strncmp((char *)cookiejar, cookie, 4))
		{	if (value)
			{ *value=cookiejar[1];
				return TRUE;
			}	
		}
		else
		cookiejar=&cookiejar[2];
	} while (cookiejar[0]);  /*NULL-cookie?*/
	return FALSE;
}	 
