/* xup.c	Xmodem upload program */

#include <bios.h>
#include <osbind.h>
#include <xbios.h>

#define Auxis() Bconstat(BC_AUX)
#define Auxos() Bcostat(BC_AUX)
#define Auxin() ((unsigned char) Bconin(BC_AUX))
#define Auxout(c) Bconout(BC_AUX,c)

#define SOH 0x01
#define EOT 0x04
#define ACK 0x06
#define NAK 0x15
#define CAN 0x18

#define NULL (char *)0
#define SIZE 128
#define PACKETMAX 65000
#define FALSE 0
#define TRUE 1

extern	char	*itoa();

unsigned char	get_char();
	char	packet[SIZE+1];

main(argc,argv)
	int	argc;
	char	*argv[];
{
	char	*name;
	int	fp,n,i;
unsigned int	ec,bytes,
		packets,xpackets;
unsigned char	chr,checksum;

	if (argc!=2)
		fatal("Usage: xup file");
	name=argv[1];
	ec=10;
	Cconws("\r\nxup v1.0 by Jason Blochowiak\r\n");
	if ((fp=open(name,1))==-1)
		fatal("Unable to open source file");

	flush();
	do
	{
		if (((chr=get_char(60))==-1) || ((chr!=NAK) && (ec--==0)))
			fatal("Initial timeout");
	} while (chr!=NAK);
	Cconws("\n\aReciever present, sending...\n");

	bytes=0;
	for (packets=1;;)
	{
		Cconws("\rS#");
		Cconws(itoa(packets));
		for (i=0;i<SIZE;i++)
			packet[i]=0;
		xpackets=packets & 0xFF;
		if ((n=read(fp,packet,SIZE))==0)
			break;
		if (n==-1)
			fatal("Unable to read source file");
		bytes+=n;
		put_char(SOH);
		put_char(xpackets);
		put_char(xpackets ^ 0xFF);
		checksum=0;
		for (i=0;i<SIZE;i++)
		{
			checksum+=packet[i];
			put_char(packet[i]);
		};
		put_char(checksum & 0xFF);
		if (get_char(10)!=ACK)
		{
			Cconws("\r\nNAKed packet.\r\n");
			if (ec--==0)
				fatal("Too many errors");
			bytes-=n;
			lseek(fp,(long) (packets-1)*128,0);
		}
		else
			packets++;
	};
	ec=10;
	do
	{
		put_char(EOT);
	} while ((get_char(10)!=ACK) && (ec-->0));
	if (close(fp)==-1)
		fatal("Unable to close file.");
	Cconws("xup: successful send.\n");
	Cconin();
	exit(0);
}


fatal(s)
	char	*s;
{
	send_char(EOT);
	Cconws("\r\nxup: ");
	Cconws(s);
	Cconws(".\r\n\a");
	exit(1);
}

read_packet(size,check)
unsigned int	size;
unsigned char	*check;
{
register int	i;
unsigned char	cs;

	i=0;
	while ( (i<size) && ((packet[i]=get_char(1))!=-1) )
		cs=0xFF & (cs+=packet[i++]);
	*check=cs ^ get_char(1);
	return(i);
}


in_status()
{
	if (Auxis())
		return(0);
	else
		return(1);
}

out_status()
{
	if (Auxos())
		return(0);
	else
		return(1);
}

unsigned char	get_char(wait)
	int	wait;
{
register int	i;

	for (i=0;i<wait*60;i++)
		if (in_status())
			Vsync();
		else
			return(Auxin()&0xff);
	return(-1);
}

put_char(c)
	char	c;
{
	while (out_status());
	Auxout(c);
}

send_char(chr)
unsigned char	chr;
{
	flush();
	Auxout(chr);
}

flush()
{
	while (get_char(1)!=-1);
}
