/* xdown.c	Xmodem download program */

#include <bios.h>
#include <osbind.h>
#include <xbios.h>

#define Auxis() Bconstat(BC_AUX)
#define Auxos() Bcostat(BC_AUX)
#define Auxin() ((unsigned char) Bconin(BC_AUX))
#define Auxout(c) Bconout(BC_AUX,c)

#define SOH 0x01
#define EOT 0x04
#define ACK 0x06
#define NAK 0x15
#define CAN 0x18

#define NULL (char *)0
#define SIZE 128
#define FALSE 0
#define TRUE 1

extern	char	*itoa();

unsigned char	get_char();
	char	packet[SIZE+1];

main(argc,argv)
	int	argc;
	char	*argv[];
{
	char	*name;
	int	fp,bw,ec,n;
unsigned int	packets,xpackets,oldxpackets;
unsigned char	chr,packet_num,packet_xnum,checksum;

	if (argc<2 || argc>3)
		fatal("Usage: xdown file [errors]");
	name=argv[1];
	ec=10;
	if (argc==3)
		if ((ec=atoi(argv[2]))<1)
			fatal("Illegal error count value");
	Cconws("\r\nxdown v1.0 by Jason Blochowiak\r\n");
	if ((fp=creat(name,1))==-1)
		fatal("Unable to create target file.");

	send_char(NAK);
	oldxpackets=0xFFFF;
	for (packets=1;;)
	{
		Cconws("\rR#");
		Cconws(itoa(packets));
		Cconws(" (");
		Cconws(itoa(ec));
		Cconws(" errs left)");
		xpackets=packets & 0xFF;
		if ((chr=get_char(10))==EOT)
		{
			send_char(ACK);
			break;
		};
		if (chr==CAN)
			fatal("Transmission aborted remotely");
		if
		(
			   chr!=SOH
			|| ((packet_num=get_char(1))==-1)
			|| ((packet_num!=xpackets)&&(packet_num!=oldxpackets))
			|| ((packet_xnum=get_char(1))==-1)
			|| ((packet_xnum ^ 0xFF)!=packet_num)
			|| ((n=read_packet(SIZE,&checksum))!=SIZE)
			|| (checksum!=0)
		)
		{
			if (chr!=SOH)
				prerror("Not SOH");
			else if ((packet_xnum ^ 0xFF)!=packet_num)
				prerror("Unmatching packet #s");
			else if (checksum!=0)
				prerror("Non-zero checksum value.");
			else if (n!=SIZE)
				prerror("Incomplete packet.");
			send_char(NAK);
			if (ec--==0)
				fatal("Too many errors");
		}
		else
		{
			send_char(ACK);
			if (xpackets==packet_num)
			{
				oldxpackets=xpackets;
				packets++;
			}
			else if (oldxpackets==packet_num)
				lseek(fp,(long) (packets-1)*128,0);

			if ((bw=write(fp,packet,SIZE))<SIZE)
				fatal("Unable to write to file.");
		}
	}
	if (close(fp)==-1)
		fatal("Unable to close file.");
	Cconws("xdown: successful recieve of");
	Cconws(itoa(packets));
	Cconws(" packets.\r\n");
	Cconin();
	exit(0);
}


fatal(s)
	char	*s;
{
	Cconws("\r\nxdown: ");
	Cconws(s);
	Cconws(".\a");
	Cconin();
	exit(1);
}

prerror(s)
	char	*s;
{
	Cconws("\r\n");
	Cconws(s);
	Cconws("\a\r\n");
}

read_packet(size,check)
unsigned int	size;
unsigned char	*check;
{
register int	i;
unsigned char	cs;

	i=0;
	while ( (i<size) && ((packet[i]=get_char(1))!=-1) )
		cs=0xFF & (cs+=packet[i++]);
	*check=cs ^ get_char(1);
	return(i);
}


in_status()
{
	if (Auxis())
		return(0);
	else
		return(1);
}

unsigned char	get_char(wait)
	int	wait;
{
register int	i;

	for (i=0;i<wait*60;i++)
		if (in_status())
			Vsync();
		else
			return(Auxin()&0xff);
	return(-1);
}

send_char(chr)
unsigned char	chr;
{
	flush();
	Auxout(chr);
}

flush()
{
	while (get_char(1)!=-1);
}
