/* Output is only to the printer.  We need to test for printer
 * connect before doing anything.  If no connect, return FALSE.
 * These functions should allow line height and header selection
 * via a menu.
 */
 
#include <stdio.h>
#include <osbind.h>
#include "ed.h"
#include "printer.h"
 
/* PRINT eXtended command  Handles the print buffer function.  Gets user
 * parameters, calls printer init, and reports errors.  Bound to ^X <TAB>.
 */
 
static  char prnfin[NFILEN];
 
print(f, n)
register int f;
register int n;
{
 
        register int s,i;
        register int lm, rm, cw;
        char buf[MYBUF];
        lm = 6;         /* for now use 6 char left margins */
        cw = 12;        /* for now use 12 char pitch */
        i  = 0;
 
        if (n > 1)
                pagelen = n;    /* pagelen is set by routine in page.c */
 
        /* Eventually change these mode line questions into a window */
        /* on the screen using the cursor keys to select options */
 
        if (isnprint || (PRNRDY == NULL))
                {
                mlwrite("Device LST: is being used");
                return(FALSE);
                }
        if((s = readpattern("What is your name? ", &prnhdr[0])) != TRUE)
                return(s);
        if((s = readpattern("What is today's date? ", &prndate[0])) != TRUE)
                return(s);
        if((s = mlyesno("Do you want double spacing? ")) == FALSE)
                spacing = 1;
        else
                spacing = 2;
 
        strcpy(prnfin,"~temp\\prn.fin");
        parsefn(prnfin);
        mlwrite("[Writing buffer file: %s page length = %d]", prnfin,pagelen);
 
        if(! tabsize)
                temptab = 8;
        else
                temptab = tabsize;
 
        rm = 80;
 
        printout(prnfin, rm);   /* Temp file for buffer */
        if((in = open(prnfin, 0)) == EOF)
                {
                mlwrite("OPEN failure on buffer file");
                return(FALSE);
                }
        setprn(cw, spacing, temptab, lm, rm); /* Initialize printer */
        isnprint = TRUE;                        /* We are printing */
        /* Initially fill printer buffer */
        if ((s = read(in, buf, MYBUF)) > NULL)
                while (s--)
                        {
                        if (buf[i] == '\n')
                                Cprnout('\r');
                        if (!(int)gemdos(0x5,buf[i++]))
                                {
                                mlwrite("Write error on LST:");
                                return(FIOERR);
                                }
                        }
                return(TRUE);
}
 
/* SETPRN Local function to set printer parameters.  Mostly uses macros from
 * printer.h
 */
 
static int
setprn(pitch, lheight, tabstop, lmarg, rmarg)
register int pitch, lheight, tabstop, lmarg, rmarg;
{
        register int i;
        pitch -= 2;
        lheight = (lheight * 5) + 4;    /* this sort of gives single and */
                                        /* double spacing @ 6 per inch */
        RESET;
        for(i=0;i<lmarg;i++)
                PRINT(SPACE);
        SET_LMARG;
        while(rmarg)
                {
                for(i=0;i<tabstop;i++,--rmarg)
                        PRINT(SPACE);
                SET_TAB;
                }
        PRINT(CR);
        SET_PITCH(pitch);
        SET_HEIGHT(lheight);
        return(TRUE);
}
 
/*
 * This function performs the details of file buffer
 * printing. Uses the file management routines in the
 * "fileio.c" package.
 */
 
static int
printout(fn, marg)
register char   *fn;
register int marg;
{
        register int    s;
        register LINE   *lp;
        register int    nline;
        register short f;
 
        f = FALSE;                              /* first time through */
 
        if ((s=ffwopen(fn)) != FIOSUC)          /* Open writes message. */
                return (FALSE);
        lp = lforw(curbp->b_linep);             /* First line.          */
        nline = 0;                              /* Number of lines.     */
        linecnt = 0;
        pagecnt = 1;
        while (lp != curbp->b_linep)
                {
                if (linecnt == 0)
                        {
                        if((s=prhdg(f, pagecnt++, marg)) != TRUE)
                                break;
                        f = TRUE;               /* Each new page gets \f */
                        linecnt += 9;
                        }
                if ((s=ffputline(&lp->l_text[0], llength(lp))) != FIOSUC)
                        break;
                ++nline;
                lp = lforw(lp);
                if(linecnt > pagelen - 3)
                        {
                        linecnt = 0;
                        continue;
                        }
                ++linecnt;
        }
        if (s == FIOSUC)                        /* No write error.      */
                s = ffclose();
        if (s != FIOSUC)                        /* Some sort of error.  */
                return (FALSE);
        return (TRUE);
}
 
/* This function reads the temp file written above and writes the file to
 * the list device.  It then deletes the temp file.
 */
 
prnbuf()
{
        register int stat;
        register int i;
        char buf[BUFSIZE];
        i = 0;
 
        if ((stat = read(in, buf, BUFSIZE)) > NULL)
                {
                while(stat--)
                        {
                        if (buf[i] == '\n')
                                Cprnout('\r');
                        if (!(int)gemdos(0x5,buf[i++]))
                                {
                                mlwrite("Write error on LST:");
                                return(FIOERR);
                                }
                        }
                return(TRUE);
                }
        isnprint = FALSE;
        close(in);
        unlink(prnfin);
        NEWPAGE;
        mlwrite("[Printing completed]");
        update();
        return(TRUE);
}
