/* PATH.C  commands that deal with paths are in here */
 
#include "shell.h"
 
/* SETPATH set the current path and default drive.  This is needed on the
 * ST for shell programs that expand wildcards incorrectly when given
 * a command line which requests a drive other than the default.  The
 * command also uses the aliases listed above.  Bound to CTLX-D.
 */
setpath(f, n)
int f, n;
{
        register char *ptr;
        extern char *index(),*alias();
        char template[MAXINPUT+1];
        char subdir[MAXINPUT+1];        /* handle multiple path */
 
        if (n == 0)
                {
                f = (int)Dgetdrv();
                Dgetpath(path,(f+1));
                mlwrite("Default drive: %c: Default path: %s",(f + 'A'),path);
                return(TRUE);
                }
        mlreply("New drive and path: ",template,MAXINPUT-1);
        if (template[0] == '~') /* use alias if possible */
                {
                if ((ptr=index(template,' '))!=(char *)NULL)
                        *ptr = '\0';
                if ((ptr=index(template,'\t'))!=(char *)NULL)
                        *ptr = '\0';
                if ((ptr=index(template,'\\'))!=(char *)NULL)
                        {
                        *ptr = '\0';
                        ++ptr;
                        strcpy(subdir,ptr);
                        n = 0;
                        }
                if (alias(&path[0],&template[1]) == (char *)NULL)
                        return(FALSE);
                if (n==0)
                        strcat(path,subdir);
                }
        else
                strcpy(path,template);
        if ((ptr=index(path,':'))!=(char *)NULL)
                {
                --ptr;
                f = (int)toupper(*ptr);
                if (f < 'A' || f > 'P')
                        {
                        mlwrite("Illegal drive specification %c:",f);
                        return(FALSE);
                        }
                f -= 'A';
                Dsetdrv(f);
                }
        Dsetpath(path);
        return(TRUE);
}
 
/* look up the string template in the known aliased names.  If it's a
 * known alias, copy the actual path into dirpath and return a pointer
 * to dirpath.  If it is not legit, complain and return NULL.  Called
 * by any command that looks at a file on disk.
 */
char *
alias(dirpath, template)
register char *dirpath;
register char *template;
{
        register ALITAB *apt;
 
        apt = aheadp;
        if (apt == NULL)
                {
                mlwrite("No aliases defined");
                return((char *)NULL);
                }
        while (apt)
                {
                if (strcmp(template,apt->alias)==NULL)
                        {
                        strncpy(dirpath,apt->value,MAXINPUT);
                        return(dirpath);
                        }
                apt=apt->a_forw;
                }
        return((char *)NULL);
}
