#include <stdio.h>
#include <ctype.h>
#include <osbind.h>
#include "ed.h"
#include "kermit.h"
 
#ifndef ESC
#define ESC 0x1b
#endif
#ifndef DEL
#define DEL 0x7f
#endif
 
extern  int *aline_addr; /* Ptr to base of Aline variables */
extern  int sav_row, sav_col;
 
typedef struct MACTAB {
        struct  MACTAB  *m_fmac;        /* next MACTAB  */
        short   *keymac;                /* pointer to the macro */
        char    key;                    /* the key      */
} MACTAB;
 
/* Do a direct read of the console. The present scheme does not always
 * work with a minimal NULL modem (i.e. only lines 1,2,&3 connected).
 */
readcon()
{
 
        register int c,i;
        extern MACTAB *mheadp, *mcralloc();
        register MACTAB *mt;
        char fname[16];
        extern char *getfname();
        extern short getktpcode();
 
        c=getkkey();    /* Read the keyboard and get mask */
        if (c == '`')   /* keyboard macro */
                {
                c = (*term.t_getchar)();
                if (c == '`')
                        {
                        sendaux('`');
                        return(TRUE);
                        }
                if (mheadp==NULL || mheadp->m_fmac == NULL)
                        {
                        mtwrite("No defineable macros assigned");
                        return(TRUE);
                        }
                if((mt=mcralloc(FALSE,c))!= (MACTAB *)NULL)
                        sendmacro(mt->keymac);
                }
        else if (shiftstatus == 12 && scancode == 0x30) /* CTRL-ALT-B */
                sendbrk();
        else if (shiftstatus == 12 && scancode == 0x2e) /* CTRL-ALT-C */
                {
                setterm(HOST);
                shell(FALSE,HUGE);
                setterm(REMOTE);
                }
        else if (shiftstatus == 17 || shiftstatus == 18) /* C-Lock + Shift */
                {
                i=tolower(c);
                sendaux(i);
                }
        else if (shiftstatus == 0 && scancode == 0x62) /* HELP Key */
                setterm(SHOWHELP);
        else if (shiftstatus == 8)      /* ALT key pressed */
                {
                switch(scancode)
                        {
                        case 0x12:      /* E */
                        /* save cursor position */
                                sav_row = aline_addr[-13];
                                sav_col = aline_addr[-14];
                                commfil(TRUE,TRUE);
                                ttopen();       /* update color */
                                (*term.t_move)(sav_row,sav_col);
                                return(TRUE);
                        case 0x61:      /* UNDO */
                                return(FALSE);
                        case 0x2e:      /* C */
                        /* save cursor position */
                                sav_row = aline_addr[-13];
                                sav_col = aline_addr[-14];
                                paintbuffer(TRUE,TRUE);
                                (*term.t_move)(sav_row,sav_col);
                                return(TRUE);
                        case 0x30:      /* B */
                                return(setbaud());
                        case 0x26:      /* L */
                                sav_row = aline_addr[-13];
                                sav_col = aline_addr[-14];
                                loadmac(TRUE);
                                (*term.t_move)(sav_row,sav_col);
                                return(TRUE);
                        case 0x18:      /* O */
                                /* Turn off flow control */
                                flow = NOFLO;
                                Rsconf(-1,flow,-1,-1,-1,-1);
                                mtwrite("[Handshaking disabled]");
                                return(TRUE);
                        case 0x13:      /* R */
                                flow = RTS;
                                Rsconf(-1,flow,-1,-1,-1,-1);
                                mtwrite("[RTS/CTS active]");
                                return(TRUE);
                        case 0x14:
                                showtime(TRUE,HUGE);
                                return(TRUE);
                        case 0x2d:      /* X */
                                flow = XON;
                                Rsconf(-1,flow,-1,-1,-1,-1);
                                mtwrite("[XON/XOFF active]");
                                return(TRUE);
                        case 0x35:      /* / ? */
                                setterm(SHOWHELP);
                                return(TRUE);
                        default:
                                sendaux(c);
                                return(TRUE);
                        }
                }
        else
                {
                if (c & SPEC)
                        if (getfname(c,fname)!=(char *)NULL)
                                c = (int)getktpcode(fname);
                if (c & META)
                        {
                        i = c & ~META;
                        sendaux(ESC);
                        c = i;
                        }
                if (c & CTLX)
                        {
                        i = c & ~CTLX;
                        sendaux(0x18);
                        c = i;
                        }
                if (c & CTRL)
                        {
                        i = c & ~CTRL;
                        c = i - '@';
                        }
                sendaux(c);
                }
        return(TRUE);
}
 
/* pratically identical to getkey in main.c but that one uses mlwrite
 * which would damage the terminal screen when it tried to update.
 */
getkkey()
{
        register int c;
        extern char keyscan[];
 
        c = (*term.t_getchar)();
#if     ST
        if (scancode == 0x70 && shiftstatus != 16)
                return (CTRL|'X');
#endif
        if (c == DEL)
                return(c);
        if (c == METACH) {                      /* Apply M- prefix      */
                mtwrite("Meta: ");
                c = (*term.t_getchar)();
                return (META | c);
        }
#if     ST
        /* use special keys or number pad (code >= 0x63) ?
         * 0x03 = scancode for ^@ (setmark).
         */
        if ((c == NULL && scancode != 0x03) || scancode >= 0x4a)
                if (scancode > 0x32)
                        {
                        /* if CapsLock and number pad, use real numbers */
                        if (shiftstatus == 16 && (scancode > 0x62 ||
                                scancode == 0x4a || scancode == 0x4e))
                                return(c);
                        else
                                return (SPEC | scancode);
                        }
                else    {
                        c = keyscan[scancode];
                        return (META | c);
                        }
#endif
        if (c>=0x00 && c<=0x1F)                 /* C0 control -> C-     */
                c = CTRL | (c+'@');
        return (c);
}
 
/* Allows keyboard macros to go through completely on a slow and noisy line */
 
sendmacro(buf)
register short *buf;
{
        register int c;
        char fname[16];
 
        while(*buf != (CTLX|')'))
                {
                while(!(int)Cauxos())   /* wait for line to clear */
                        ;
                if (*buf & SPEC)
                        if (getfname(*buf,fname)!=(char *)NULL)
                                *buf = (int)getktpcode(fname);
                if (*buf & META)
                        {
                        c = *buf & ~META;
                        sendaux(ESC);
                        *buf = c;
                        }
                if (*buf & CTLX)
                        {
                        c = *buf & ~CTLX;
                        sendaux(0x18);
                        *buf = c;
                        }
                if (*buf & CTRL)
                        {
                        c = *buf & ~CTRL;
                        *buf = c - '@';
                        }
                sendaux(*buf++);
                }
}
