/*
*       K e r m i t     File Transfer Utility
*       Header file for uEmail
*/
 
/* Symbol Definitions */
 
#define MAXPACKSIZ      94      /* Maximum packet size */
#define MYPACKSIZ       94      /* My packet size */
#define SOH             1       /* Start of header */
#define CLEAR           26      /* ^Z clear screen */
#define LF              10      /* ASCII Line Feed */
#define CR              13      /* ASCII Carriage Return */
#define SP              32      /* ASCII space */
#define DEL             127     /* Delete (rubout) */
#define ESCCHR          0x1c    /* Default escape character for CONNECT */
#define REMOTE          1
#define HOST            2
#define SHOWHELP        3
#define DEFLO           1       /* default == XON/XOFF */
#define NOFLO           0
#define XON             1
#define RTS             2
#define DEFBPS          1200
#define BORDER          0
#define CURSOR          1
#define STATUS          2
#define LETTER          3
#define BLACK           0
#define COBALT          7
#define RED             0x700
#define TEAL            0x55
#define DEFPAR          '\0'    /* Default no parity */
 
#define MAXTRY          10      /* Times to retry a packet */
#define MYQUOTE         '#'     /* Quote character I will use */
#define MYPAD           0       /* Number of padding characters I will need */
#define MYPCHAR         0       /* Padding character I need (0) */
#define DEFMAXL         80      /* Default packer size */
#define DEFTIME         5       /* Default timeout */
#define DEFPAD          0       /* Default pad characters */
#define DEFPADC         0       /* Default pad character */
#define DEFEOL          '\n'    /* Default EOL character */
#define DEFQUOTE        '#'     /* Default QUOTE character */
#define DEFQBIN         'N'     /* Default QBIN character */
 
#define QBIN            '&'     /* Character for binary quoting */
 
#define MYEOL           '\r'    /* End-Of-Line character I need */
 
#define MYTIME          10      /* Seconds after which I should be timed out */
#define MAXTIM          60      /* Maximum timeout interval */
#define MINTIM          2       /* Minumum timeout interval */
 
/* Macro Definitions */
 
/*
* tochar:       converts a control character to a printable one by adding a
*               space.
*
* unchar:       undoes tochar.
*
* ctl:          converts between control characters and printable characters by
*               toggling the control bit (ie. ^A becomes A and A becomes ^A).
*/
#define tochar(ch)      ((ch) + ' ')
#define unchar(ch)      ((ch) - ' ')
#define ctl(ch)         ((ch) ^ 64 )
 
 
/* Global Variables */
int     size,
        spsiz,          /* Maximum send packet size */
        pad,            /* How much padding to send */
        timint,         /* Timeout for foreign host on sends */
        n,              /* Packet number */
        np,             /* Packet count for display */
        numtry,         /* Times this packet retried */
        oldtry,         /* Times previous packet retried */
        parity,         /* o,e,s,m or 0 */
        logfile,        /* log session to buffer */
        qflag;          /* -1 if doing 8 bit quoting */
 
char    state,          /* Present state of the automaton */
        padchar,        /* Padding character to send */
        eol,            /* End-Of-Line character to send */
        quotech,        /* Quote character in incoming data */
        qbin,           /* character for binary quoting */
        *filnam,        /* Current file name */
        recpkt[MAXPACKSIZ],       /* Receive packet buffer */
        packet[MAXPACKSIZ];       /* Packet buffer */
 
extern  char deflow[];
extern  int flow, defbaud, bps;
extern
void    spack(),
        rpar();
 
extern
char    rinit(),
        rfile(),
        rdata(),
        rpack(),
        sinit(),
        sfile(),
        sdata(),
        seof(),
        sbreak();
