/* File: wc.c
 * This file originally appeared in "The C Programming Language" (c) 1978.
 * Modified to become part of MicroEMACS.  Includes line and word information.
 * Searches current buffer only.
 */
 
#include <stdio.h>
#include <ctype.h>
#include "ed.h"
 
wc(f, n)
register int f, n;
{
 
        static double lpw = (0.00);
        static double tp1,tp2;
        register long nc, na, nw;
        register LINE *dlp;
        char lpwbuf[6];
        short dlo, inword;
 
        /*
         * nc = # of characters
         * f = # lines
         * nw = # words
         * na = # alpha characters
         * inword = "Are we in a word?"
        */
 
        inword = NO;
        f = 00;
        na = nw = nc = 0L;
        dlp = curwp->w_dotp;
        dlo = curwp->w_doto;
 
        gotobob(NULL, 1);
 
        while (curwp->w_dotp != curbp->b_linep)
                {
                ++nc;
                n = lgetc(curwp->w_dotp, curwp->w_doto);
                if (curwp->w_doto == llength(curwp->w_dotp))
                        {
                        ++f;
                        inword = NO;
                        }
                if (isspace(n))
                        inword = NO;
                else    if (inword == NO)
                                {
                                inword = YES;
                                ++nw;
                                }
                if (isalpha(n))
                        ++na;
                forwchar(NULL, 1);
                }
        --nw;
        curwp->w_dotp = dlp;
        curwp->w_doto = dlo;
        curwp->w_flag |= WFHARD;
        if (nw > 0L)            /* avoid division by zero */
                {
                tp1 = (double)na;
                tp2 = (double)nw;
                lpw = (double)(tp1/tp2);
                }
        ftoa(lpw, lpwbuf, 2);
        n = mlwrite("Length:=%D Lines:=%d Words:=%D Letters:=%D \
Avg. word:=%s letters", nc, f, nw, na, lpwbuf);
        return(n);
}
