*************************************************************************
* Add all of this to your gemstart.s file.  You will need the latest
* version.  It is copyrighted, or I would include it also.  You need
* the stack variable to allow shell commands.  The __BDOS function is
* a bug fix.  The copy function handles screens in the terminal section.
* The getmem function is for rettpa.  I include gemdos-xbios in my
* startup so that link68 does not have to load osbind.o.
*************************************************************************
*
* STACK variable summary:
*       -1=keep all
*        0=keep MINSTACK bytes
*        1=keep 1/4 of free memory
*        2=keep 2/4
*        3=keep 3/4
*        4=use _STKSIZ: keep (if >0) or give up (if <0) _STKSIZ bytes.
*    other=keep that many bytes (positive) or give back that many (negative)
 
STACK=4                 * CHANGE THIS VARIABLE TO CHOOSE A MEMORY MODEL
*
* Surprise, the trap #2 vector is largely a do nothing routine.
* Redirecting the basic calls may help solve a few problems.
*
        .globl ___BDOS
 
___BDOS:
        link    A6,#-4
        cmpi.w  #9,$8(A6)
        beq     togem
        cmpi.w  #2,$8(A6)
        beq     togem
        cmpi.w  #1,$8(A6)
        beq     togem
        cmpi.w  #26,$8(A6)
        bne     bdos
togem:
        move.l  $a(A6),(sp)     * value
        move.w  $8(A6),-(sp)    * function
        bsr     _gemdos
        addq.l  #2,sp
        bra     out
bdos:
        move.l  $a(A6),d1       * value
        move.w  $8(A6),d0       * function
        trap    #2              * Enter BDOS
        cmpa.l  __break,sp      * Check for stack ovf
        bcs     __sovf          * overflow! print msg and abort
 
out:    unlk    A6              * no error; return
        rts                     * Back to caller
 
*
*       GEMDOS, BIOS, and XBIOS calls
*
        .globl  _gemdos
        .globl  _bios
        .globl  _xbios
_gemdos:
        move.l  (sp)+,biosret
        trap    #1
        move.l  biosret,-(sp)
        rts
*
_bios:  move.l  (sp)+,biosret
        trap    #13
        move.l  biosret,-(sp)
        rts
*
_xbios: move.l  (sp)+,biosret
        trap    #14
        move.l  biosret,-(sp)
        rts
*       from _Programming the 68000_ by Steve Williams
*       copy(src,dst,length);
*       char    *src;
*       char    *dst;
*       int     length;
*
        .globl  _copy
_copy:  move.l  4(a7),a0
        move.l  8(a7),a1
        move.w  12(a7),d0
        sub.w   #1,d0
loop:   move.b  (a0)+,(a1)+
        dbra    d0,loop
        rts
*
*       getmem function to return present top of memory
*
        .globl  _getmem
_getmem:
        move.l  a7,d0   * real simple and it works
        rts
        .bss
        .even
biosret:        .ds.l   1
 
