#include <stdio.h>
#include "ed.h"
 
int pagelen = 60;       /* default page length */
 
/* PAGINATE : eXtended command  Set mark, goto beginning of file and move
 * beginning to end inserting formfeeds.  Bound to CTLX-!.
 */
 
paginate(f, n)
register int f, n;
{
        setmark(NULL, 1);
        gotobob(NULL, 1);
 
        while(pageforw(NULL, 1) != FALSE)
                {
                openline(NULL, 1);
                linsert(1 ,'\f');
                }
        return(swapmark(NULL, 1));
}
 
/* SETPAGE eXtended command  Set page length for paginate.  Or tell page
 * length already set.  Bound to CTLX-#.
 */
 
setpage(f ,n)
register int f, n;
{
 
        if (n > 1 && n < 100)
                pagelen = n;
 
        mlwrite ("Page length is %d", pagelen);
                return(TRUE);
}
 
/* PAGEFORW eXtended command  move forward by set page size.  Bound to
 * CTLX-+.
 */
 
pageforw(f, n)
register int f, n;
{
        register int c;
 
        c = 0;
 
        if (n < 0)
                return(pageback(f, -n));
        while(n)
                {
                if (curwp->w_dotp != curbp->b_linep)
                        {
                        forwline(NULL, 1);
                        ++c;
                        if (c == pagelen)
                                {
                                c = 0;
                                --n;
                                continue;
                                }
                        }
                else
                        return(FALSE);
                }
        return(TRUE);
}
 
/* PAGEBACK eXtended command  move forward by set page size.  Bound to
 * CTLX-+.
 */
 
pageback(f, n)
register int f, n;
{
        register int c;
 
        c = 0;
 
        if (n < 0)
                return(pageforw(f, -n));
        while(n)
                {
                if (lback(curwp->w_dotp) != curbp->b_linep)
                        {
                        backline(NULL, 1);
                        ++c;
                        if (c == pagelen)
                                {
                                c = 0;
                                --n;
                                continue;
                                }
                        }
                else
                        return(FALSE);
                }
        return(TRUE);
}
