/* misc.c  miscellaneous commands, some macros and mode commands */
 
#include <stdio.h>
#include <ctype.h>
#include <osbind.h>
#include "ed.h"
 
typedef short boolean;
static int count = 1;
char *modes[] = {"Fundamental","Wrap","C"};
 
/* MINDNL : META command Indent subsequent newline same as the present
 * one.  Bound to M-J.
 */
 
mindnl(f, n)
register int f, n;
{
        curwp->w_doto = llength(curwp->w_dotp);
        return(indent(f, n));
}
 
/* MDELELN : CTRL command Delete entire line from beginning. Bound to ^K.
 */
 
mdeleln(f, n)
register int f, n;
{
        curwp->w_doto = 0;
        return(kill(NULL, 1));
}
 
/* MDELWLN : META command Delete entire line including NL. Bound to M-^K.
 */
 
mdelwln(f, n)
register int f, n;
{
        curwp->w_doto = 0;
        return(kill(TRUE, 1));
}
 
/* MDELIND : META command Delete beginning indentation on line. Bound to M-\.
 */
 
mdelind(f, n)
register f, n;
{
        register int odo;
 
        f = llength(curwp->w_dotp);
        odo = curwp->w_doto;
 
        curwp->w_doto = 0;
        while ((n = lgetc(curwp->w_dotp, curwp->w_doto)) <= ' '
                && curwp->w_doto != llength(curwp->w_dotp))
                if (forwdel(NULL, 1) == FALSE)
                        return(FALSE);
        if ((n = llength(curwp->w_dotp)) == NULL)
                curwp->w_doto = n;
        else {
                if (odo == NULL)
                        curwp->w_doto = odo;
                else
                        curwp->w_doto = odo - (f - n);
        }
        lchange(WFEDIT);
        return(TRUE);
}
 
/* CLOWSP Meta Command  Close up white space from point forward.
 * Bound to M-^O.
 */
 
clowsp(f, n)
register int f, n;
{
        while ((n = lgetc(curwp->w_dotp, curwp->w_doto)) <= ' '
                || curwp->w_doto == llength(curwp->w_dotp))
                if(forwdel(NULL, 1) == FALSE)
                        return(FALSE);
        return(linsert(1, ' '));
}
 
/* MARKPAR : Meta Command Mark paragraph for moving or deleting.  Bound to
 * M-H.
 */
 
markpar(f, n)
register int f, n;
{
        goteop(NULL, n);
        setmark(NULL, 1);
        gotbop(NULL, n);
        return(TRUE);
}
 
/* KILLSENT : Meta command  Kills sentence forward.  Bound to M-K.
 */
 
killsent(f, n)
register int f, n;
{
        setmark(NULL,1);
        forwsent(f, n);
        return(killregion(NULL, 1));
 
}
 
/* TGLCASE : Meta command  Toggles case of letter at point.  Bound to M-^P.
 */
 
tglcase(f, n)
register int f, n;
{
        register int c;
 
        if (n < 0)
                return(FALSE);
        while(n--)
                {
                c = lgetc(curwp->w_dotp, curwp->w_doto);
                if(islower(c))
                        c = toupper(c);
                else
                        c = tolower(c);
 
                lputc(curwp->w_dotp, curwp->w_doto, c);
                lchange(WFEDIT);
                if(forwchar(FALSE, 1) == FALSE)
                        return(FALSE);
                }
        return(TRUE);
}
 
/* GRTW eXtended command  Globally removes trailing white space.  Bound to
 * ^X-\.
 */
 
grtw(f, n)
register int f, n;
{
 
        register int dlo, d;
        register LINE *dlp;
 
        dlp = curwp->w_dotp;
        dlo = curwp->w_doto;
 
        gotobob(NULL, 1);
 
        while((d = ltrw(FALSE, 1)) != EOF)
                forwline(NULL, 1);
 
        if (dlo > llength(dlp))
                dlo = llength(dlp);
 
        curwp->w_dotp = dlp;
        curwp->w_doto = dlo;
        curwp->w_flag |= WFHARD;
        return(TRUE);
}
 
/* LTRW internal function delete trailing white space on current line.
 * called by grtw() and fillpar().  Any arguments are ignored.  Returns
 * length of line or EOF at end of buffer.
 */
 
ltrw(f, n)
register int f, n;
{
        register int c, d;
 
        if(curwp->w_dotp == curbp->b_linep)
                return(EOF);
        d = llength(curwp->w_dotp);
        curwp->w_doto = d;
 
        if (d == NULL)
                return(NULL);
        while (--d >= 0)
                {
                backchar(FALSE, 1);
                c = lgetc(curwp->w_dotp, curwp->w_doto);
                if(c != ' ' && c != '\t')
                        break;
                if(ldelete(1, NULL) == FALSE)
                        return(EOF);
                }
        return(llength(curwp->w_dotp));
}
 
/* TWADDLE Meta command  More at twiddle.  Transpose two words on a line.
 * Bound to M-T.
 */
 
twaddle(f, n)
register int f, n;
{
        boolean flag = FALSE;
        boolean punct= FALSE;
        register int c;
        char word[20];
 
        n = 0;
 
        if(backchar(FALSE, 1) == FALSE)
                return (FALSE);
        c = lgetc(curwp->w_dotp, curwp->w_doto);
        if(ispunct(c))
                {
                punct = c;
                if (forwdel(NULL, 1) == FALSE)
                        return (FALSE);
                }
        else if (forwchar(FALSE, 1) == FALSE)
                        return (FALSE);
 
        c = lgetc(curwp->w_dotp, curwp->w_doto);
        if (isspace(c))
                flag = c;
        else if (ispunct(c))
                flag = c;
        else
                word[n++] = c;
        if (ldelete(1, NULL) == FALSE)
                return (FALSE);
 
        while(c = lgetc(curwp->w_dotp, curwp->w_doto))
                {
                if (curwp->w_doto == llength(curwp->w_dotp))
                        break;
                if (isalnum(c))
                        {
                        word[n++] = c;
                        if (forwdel(NULL, 1) == FALSE)
                                return (FALSE);
                        }
                else
                        break;
                }
        if(backword(NULL, 1) == FALSE)
                return (FALSE);
        c = 0;
        while(n--)
                if (linsert(1, word[c++]) == FALSE)
                        return (FALSE);
        if (punct)
                if (linsert(1, punct) == FALSE)
                        return (FALSE);
        if (flag)
                if (linsert(1, flag) == FALSE)
                        return (FALSE);
        return(TRUE);
}
 
/* MRFLUSH META Command right flush current line.  Bound to M-^R */
 
mrflush(f, n)
register int f, n;
{
        register short p;       /* where we are in line */
        register short l;       /* length of line */
        register short o;       /* offset for new location */
 
        p = curwp->w_doto;
        if((l = llength(curwp->w_dotp)) == NULL)
                return(FALSE);
        if (fillcol)
                f = fillcol;
        else    f = 80;
        if((o = f - l) < 0)
                return(FALSE);
        curwp->w_doto = 0;
        linsert(o, ' ');
        forwchar(NULL, p);
        return(TRUE);
}
 
/* MCENTER META Command center current line.  Bound to M-^C */
 
mcenter(f, n)
register int f, n;
{
        register short p;       /* where we are in line */
        register short l;       /* length of line */
        register short o;       /* offset for new location */
 
        p = curwp->w_doto;
        if((l = llength(curwp->w_dotp)) == NULL)
                return(FALSE);
        if (fillcol)
                f = fillcol;
        else    f = 80;
        if((o = (f - l)/2) < 0)
                return(FALSE);
        curwp->w_doto = 0;
        linsert(o, ' ');
        forwchar(NULL, p);
        return(TRUE);
}
 
/* SETMODE Extended Command.  Only one mode at a time.  Bound to ^X-M.
 */
 
setmode(f, n)
register int f, n;
{
        char mymode[12];
        register char *ptr;
        extern char *index();
        register BUFFER *bp;
        register WINDOW *wp;
 
        if((f=mlreply("New mode: ",mymode,12)) != TRUE)
                return(f);
        /* don't fail because of stray spaces */
        if ((ptr=index(mymode,' '))!=NULL)
                *ptr = '\0';
        else if ((ptr=index(mymode,'\t'))!=NULL)
                *ptr = '\0';
        n = strlen(mymode);
        /* adjust case */
        for (f=0;f<=n;f++)
                if (f == 0)
                        mymode[f] = toupper(mymode[f]);
                else
                        mymode[f] = tolower(mymode[f]);
        for (f=0;f<=NUMMODES-1;f++)
                {
                if (strncmp(modes[f],mymode,12)==0)
                        {
                        switch(f)
                                {
                                case 0:
                                        curbp->b_bmode &= ~BMWRAP;
                                        curbp->b_bmode &= ~BMCMODE;
                                        curbp->b_bmode |= BMNWRAP;
                                        break;
                                case 1:
                                        curbp->b_bmode &= ~BMNWRAP;
                                        curbp->b_bmode &= ~BMCMODE;
                                        curbp->b_bmode |= BMWRAP;
                                        break;
                                case 2:
                                        curbp->b_bmode &= ~BMNWRAP;
                                        curbp->b_bmode &= ~BMWRAP;
                                        curbp->b_bmode |= BMCMODE;
                                        break;
                                }
                        upmode();
                        return(TRUE);
                        }
                }
                mlwrite("No match");
                return(FALSE);
}
 
/* SGLMODE META-Command Set the flag glmode.  The flag is used only by
 * bfind and this command.  Call this after reading in a new color file
 * and answer "color" to the mode question to install new colors.
 */
 
sglmode(f, n)
int f, n;
{
        char mymode[12];
        register char *ptr;
        extern char *index();
        register BUFFER *bp;
        register WINDOW *wp;
 
        if((f=mlreply("New global mode: ",mymode,12)) != TRUE)
                return(f);
        /* don't fail because of stray spaces */
        if ((ptr=index(mymode,' '))!=NULL)
                *ptr = '\0';
        else if ((ptr=index(mymode,'\t'))!=NULL)
                *ptr = '\0';
        n = strlen(mymode);
        /* adjust case */
        for (f=0;f<=n;f++)
                if (f == 0)
                        mymode[f] = toupper(mymode[f]);
                else
                        mymode[f] = tolower(mymode[f]);
        if (strcmp(mymode,"Color")==NULL)
                {
                ttopen();
                return(TRUE);
                }
        for (f=0;f<=NUMMODES-1;f++)
                {
                if (strncmp(modes[f],mymode,12)==0)
                        {
                        switch(f)
                                {
                                case 0:
                                        glmode &= ~BMWRAP;
                                        glmode &= ~BMCMODE;
                                        glmode |= BMNWRAP;
                                        break;
                                case 1:
                                        glmode &= ~BMNWRAP;
                                        glmode &= ~BMCMODE;
                                        glmode |= BMWRAP;
                                        break;
                                case 2:
                                        glmode &= ~BMNWRAP;
                                        glmode &= ~BMWRAP;
                                        glmode |= BMCMODE;
                                        break;
                                }
                        return(TRUE);
                        }
                }
                mlwrite("No match");
                return(FALSE);
}
 
/* RETTPA META-Command returns current memory use and available buffer
 * to msgline.  Bound to M-@.
 */
 
rettpa(f, n)
int f, n;
#if ST
{
        register long low, u_buf;
        unsigned long tpa, stkadd;
        extern long progend;
        extern unsigned long getmem();
        extern long sbrk();
 
        low = sbrk(0);
        stkadd = getmem();
        u_buf = low - progend;
        tpa = stkadd - low;
        mlwrite("Used:%D bytes Heap address:%D Stack address:%lu TPA:%lu bytes",
        u_buf,low,stkadd,tpa);
        return(TRUE);
}
#else
{
        return(FALSE);
}
#endif
 
/* GOLINE  Meta command go to argument line in text.  Bound to M-G.
 */
 
goline(f, n)
register int f, n;
{
        return(gotobob(f, n) && forwline(f, n));
}
 
/* ENUMERATE  Meta Command  Based on value of n, initialize or increment
 * a counter variable.  If n < NULL, simply write the value on the mode
 * line.  Bound to M-CTRL-N.
 */
 
enumerate(f, n)
register int f, n;
{
        char num[5+1];
 
        if (n == -1)    /* request value of count */
                mlwrite("Counter = %d",count);
        else if (n == TRUE)     /* increment counter */
                count++;
        else if (n == NULL)
                {
                ltoa(num, 5, (long)count++); /* make it a string */
                putlin(num);    /* put count in doc */
                putlin(". ");           /* do some formatting */
                }
        else if (n > 1)                 /* n > 1.  Set counter to arg value */
                {
                count = n;
                enumerate(NULL,-1);
                }
        else if (n < -1)        /* Request to reset counter */
                count = 1;
        return(TRUE);
}
 
/* GOSPELL  eXtended command goto next spell mark to correct spelling
 * mistakes.  Bound to X-S.
 */
 
gospell(f, n)
register int f, n;
{
 
        while(TRUE)
                {
                if (curwp->w_dotp == curbp->b_linep)
                        {
                        mlwrite("No spell marks found");
                        return(FALSE);
                        }
                f = lgetc(curwp->w_dotp, curwp->w_doto);
                if (f == 0x93)
                        {
                        if (forwdel(NULL, TRUE) == FALSE)
                                return (FALSE);
                        mlwrite("Correction mark found");
                        return(TRUE);
                        }
                forwchar(NULL,TRUE);
                }
}
 
/* showtime print current time on mode line.  If n > 1 insert in document.
 */
showtime(f,n)
register int f, n;
{
        register int time;
        register int hours, minutes, seconds;
        char mortem[3]; /* am or pm */
        char timeline[20];
 
        time  = Tgettime();
        seconds = (time&31)*2;
        minutes = (time>>5)&63;
        hours   = (time>>11)&31;
        if (hours >= 12)
                strcpy(mortem, "pm");
        else
                strcpy(mortem, "am");
        if (hours > 12)
                hours-=12;
        if (hours == 0)
                hours = 12;
        sprintf(timeline,"Time: %d:%02d:%02d %s",hours,minutes,seconds,mortem);
        if (n <= 1)
                mlwrite(timeline);
        else if (n == HUGE)
                mtwrite(timeline);
        else
                putlin(timeline);
        return(TRUE);
}
 
/* MDONCOM  do named command.  Bound to M-X.
 */
mdoncom(f, n)
register int f, n;
{
        char fname[16];         /* function name */
        register char *ptr;
        extern char *index();
        extern short getktpcode();
        register short c;
 
        mlreply("Function: ",fname,15);
        /* don't fail because of stray spaces */
        if ((ptr=index(fname,' '))!=NULL)
                *ptr = '\0';
        else if ((ptr=index(fname,'\t'))!=NULL)
                *ptr = '\0';
        if ((c=getktpcode(fname))!=NULL)
                c = (short)execute(c,f,n);
        else
                {
                mlwrite("No match!");
                (*term.t_beep)();
                }
        return((int)c);
}
