/* FILE:         cc.c
 * DATE:         27-Jan-1987
 *               Updated 07-01-1987 to allow wildcards and linking multiple
 *               files.
 *               Updated 27-01-1987 to allow assembling and/or compiling and
 *               to allow linking without compiling.
 * AUTHOR:       Robert Royar rdroya01@bitnet
 * SYSTEM:       Atari ST
 * COMPILER:     Alcyon v. 4.14
 * PURPOSE:      A simple minded compiler driver, no frills. (well, almost)
 * USAGE:        cc filename[s] (path must agree with cc.ini)
 *               the command line may contain wildcards as long as all
 *               source files are on the drive designated as the sdir in
 *               this file.  Using the link option will cause the linker to
 *               look for a command file on the source directory.  That link
 *               file should be named `foo.lnk' where `foo' is the name in
 *               the cc.ini file associated with the lnkfile value.  The
 *               link file should tell the linker to place the output on the
 *               source dir if the relocation program is to find the
 *               `foo.68k' file and successfully create a `foo.prg' file.
 *               Calling the program without a command line and with dolink=1
 *               will force it to try to link the file `linkfile.68k' and
 *               then call relmod.  Giving it a filename with an .s extent
 *               will skip the compiling and assemble the file.  Files with
 *               .s extents and .c extents may be mixed on a line.
 * DISTRIBUTION: Public Domain.  Do with it what you will.  Just leave
 *               the header intact.
 */
#include <stdio.h>
#include <osbind.h>
#include <ctype.h>
#include <errno.h>
 
unsigned long _STKSIZ = 16284;  /* keep 16K */
 
/* These are the defaults.  All of them can be over-ridden by values
 * in the cc.ini file if that file is on the default drive and directory.
 */
char sdir[81] = "e:\\"; /* where the source files are */
char include[81] = "d:\\stdlib.h\\"; /* include files */
char tdir[81] = "m:\\"; /* temporary files (all of them) */
char bin[81] = "c:\\bin\\";     /* compiler directory */
char symb[81] = "c:\\bin\\";    /* as68 symbols */
char floflag[12] = " ";         /* float ?      */
char delflag[12] = "1";         /* delete temporary files */
char lnkflag[12] = "0";         /* link file[s] if == "1" */
char warn[12] = " ";            /* make it -w to suppress warnings */
char syslib[81] = "c:\\bin\\";  /* drive to log for linker */
char lnk[81] = "out";           /* .68K and .lnk filename */
char fprg[81] = "out";          /* final output name */
char pname[81];
char command[81];
char source[81];
int temdrv;
char delfile[80];
int delete = 1;
int dolink = 0;
int doasm  = FALSE;
char path[128];
int exec;
int curdrv;
char author[30] = "Robert Royar";
 
main(argc,argv)
register int argc;
char *argv[];
{
        register char c, *ptr;
        register int argnum;
        char *index();
 
        argnum = 1;
        curdrv = (int)Dgetdrv(); /* 0 = A */
        Dgetpath(path,(1+curdrv)); /* 1 = A */
        if (access("cc.ini",4) != -1)
                if (!inivar())
                        exit(-1);
        if (argc == 1 && dolink == FALSE)
                {
                fprintf(stderr,"usage: %s filename[s]\n",argv[0]);
                exit(-1);
                }
        if (argc == 1)
                {
                exec = linkfil();
                goto out;
                }
        if (tdir[1] == ':')
                {
                c = (char)toupper(tdir[0]);
                temdrv = (int)(c - 'A');
                Dsetdrv(temdrv);        /* Log into temp drive */
                }
        if((exec=(int)Dsetpath(tdir))!=0)
                goto out;
        while(--argc)
                {
                strcpy(source,argv[argnum++]);
                if ((ptr=index(source,':'))!=NULL)
                        strcpy(source,++ptr);
                /* If the file has an .s extent, then assemble it.
                 * Check the source dir first.  If it's not there,
                 * check the temp dir.  Set the doasm flag to fit
                 * the outcome, or break if no file found.
                 */
                if ((ptr=index(source,'.'))!=NULL)
                        {
                        *ptr = '\0';    /* don't let the extension through */
                        /* delete any existing .o files */
                        sprintf(delfile,"%s%s.o",tdir,source);
                        if (access(delfile,4)==NULL)
                                unlink(delfile);
                        ++ptr;
                        if (*ptr != '\0')
                                {
                                *ptr = tolower(*ptr);
                                if (strcmp(ptr,"s")==NULL) /* assemb only */
                                        {
                                        sprintf(command,"%s%s.s",sdir,source);
                                        if ((exec=access(command,4)) == -1)
                                                {
                                                sprintf(command,"%s%s.s",
                                                       tdir,source);
                                                if ((exec=access(command,4))
                                                     == -1)
                                                        continue;
                                                else /* this is a tdir file */
                                                        doasm = FALSE;
                                                }
                                        else    /* this asm file is on sdir */
                                                doasm = TRUE;
                                        if ((exec=as())!=NULL)
                                                goto out;
                                        else
                                                continue;
                                        }
                                }
                        }
                /* delete any existing .o files */
                sprintf(delfile,"%s%s.o",tdir,source);
                if (access(delfile,4)==NULL)
                        unlink(delfile);
                doasm = FALSE;
                sprintf(command,"%s%s.c",sdir,source);
                if ((exec=access(command,4)) == -1)
                        break;
                if ((exec=cc())!=NULL)
                        break;
                }
        if (dolink && (exec == NULL))
                exec = linkfil();
out:    Dsetdrv(curdrv);
        Dsetpath(path);
        exit(exec);
}
 
cc()
{
        fprintf(stderr,"\nCompiling : %s%s.c\n",sdir,source);
        sprintf(&command[1],"-i %s %s%s.c %s%s.i ",
                include,sdir,source,tdir,source);
        command[0] = (char)strlen(&command[1]);
        sprintf(pname,"%sCP68.PRG",bin);
        if((exec=(int)Pexec(0,pname,command,0L))!=0)
                return(exec);
        sprintf(&command[1],"%s%s.i %s%s.1 %s%s.2 %s%s.3 %s %s",
                tdir,source,tdir,source,tdir,source,tdir,source,floflag,warn);
        command[0] = (char)strlen(&command[1]);
        sprintf(pname,"%sC068.PRG",bin);
        if((exec=(int)Pexec(0,pname,command,0L))!=0)
                return(exec);
        if (delete)
                {
                sprintf(command,"%s%s.i",tdir,source);
                unlink(command);
                }
        sprintf(&command[1],"%s%s.1 %s%s.2 %s%s.s",
        tdir,source,tdir,source,tdir,source);
        command[0] = (char)strlen(&command[1]);
        sprintf(pname,"%sC168.PRG",bin);
        if((exec=(int)Pexec(0,pname,command,0L))!=0)
                return(exec);
        sprintf(command,"%s%s.1",tdir,source);
        unlink(command);
        sprintf(command,"%s%s.2",tdir,source);
        unlink(command);
        exec = as();
        return(exec);
}
 
as()
{
        if (!doasm)
                {
                fprintf(stderr,"\nAssembling : %s%s.s\n",tdir,source);
                sprintf(&command[1],"-l -u -s %s %s%s.s",bin,tdir,source);
                }
        else
                {
                fprintf(stderr,"\nAssembling : %s%s.s\n",sdir,source);
                sprintf(&command[1],"-l -u -s %s %s%s.s",bin,sdir,source);
                }
        command[0] = (char)strlen(&command[1]);
        sprintf(pname,"%sAS68.PRG",bin);
        if((exec=(int)Pexec(0,pname,command,0L))!=0)
                return(exec);
        sprintf(command,"%s%s.o",tdir,source);
        if ((exec=access(command,4))==NULL)
                if (delete)
                        {
                        sprintf(command,"%s%s.s",tdir,source);
                        unlink(command);
                        }
        return(exec);
}
 
linkfil()
{
        register char c;
 
        if (syslib[1] == ':')
                {
                c = (char)toupper(syslib[0]);
                temdrv = (int) (c - 'A');
                Dsetdrv(temdrv);
                }
        else
                Dsetdrv(curdrv);
        Dsetpath(syslib);
        /* save disk write errors */
        sprintf(delfile,"%s%s.68k",sdir,lnk);
        if (access(delfile,4)==NULL)
                unlink(delfile);
        sprintf(delfile,"%s%s.prg",tdir,lnk);
        if (access(delfile,4)==NULL)
                unlink(delfile);
        sprintf(source,"%s%s",sdir,lnk);
        sprintf(pname,"%s%s",bin,"link68.ttp");
        sprintf(&command[1],"[co[%s.lnk]]",source);
        command[0] = (char)strlen(&command[1]);
        if ((exec=Pexec(0,pname,command,0L))!=0)
                return(exec);
        sprintf(source,"%s%s.68K",sdir,lnk);
        if ((exec=access(source,4))!=NULL)
                return(exec);
        sprintf(pname,"%s%s",tdir,lnk);
        sprintf(&command[1],"%s %s",source,pname);
        sprintf(pname,"%s%s",bin,"relmod.ttp");
        command[0] = (char)strlen(&command[1]);
        if ((exec=Pexec(0,pname,command,0L))!=0)
                return(exec);
        if ((exec=access(delfile,4))==NULL)
                if (delete)
                        unlink(source);
        return(exec);
}
 
inivar()
{
        FILE *freopen();
        char *gets(), *index();
        register char *ptr;
        static char line[81];
 
        if (freopen("cc.ini","r",stdin) != stdin)
                {
                fprintf(stderr,"cc: cannot open %scc.ini\n",path);
                return(0);
                }
        while (gets(line))
                {
                if ((ptr=index(line,' '))!=(char *)NULL)
                        *ptr = '\0';
                if ((ptr=index(line,'\t'))!=(char *)NULL)
                        *ptr = '\0';
                if ((ptr=index(line,'='))!=(char *)NULL)
                        *ptr = '\0';
                else
                        continue;
                ++ptr;
                if (strcmp(line,"source")==NULL)
                        strncpy(sdir,ptr,80);
                else if (strcmp(line,"include")==NULL)
                        strncpy(include,ptr,80);
                else if (strcmp(line,"temp")==NULL)
                        strncpy(tdir,ptr,80);
                else if (strcmp(line,"bin")==NULL)
                        strncpy(bin,ptr,80);
                else if (strcmp(line,"symb")==NULL)
                        strncpy(symb,ptr,80);
                else if (strcmp(line,"syslib")==NULL)
                        strncpy(syslib,ptr,80);
                else if (strcmp(line,"linkfile")==NULL)
                        strncpy(lnk,ptr,80);
                else if (strcmp(line,"float")==NULL)
                        strncpy(floflag,ptr,3);
                else if (strcmp(line,"warn")==NULL)
                        strncpy(warn,ptr,3);
                else if (strcmp(line,"delete")==NULL)
                        {
                        strncpy(delflag,ptr,2);
                        if (strncmp(delflag,"0",1)==NULL)
                                delete = FALSE;
                        }
                else if (strcmp(line,"dolink")==NULL)
                        {
                        strncpy(lnkflag,ptr,2);
                        if (strncmp(lnkflag,"1",1)==NULL)
                                dolink = TRUE;
                        }
                else if (feof(stdin))
                        break;
                }
        return(1);
}
