 
                                   Uemail
 
Uemail is an emacs-like full-screen editor for the Atari-ST computer
equipped with a color or monochrome monitor.  It supports all of the major
commands offered by microEmacs version 30, plus some extensions that make
its interface closer to that used by GNU_EMACS. Although smaller than
1ST_WORD and many GEM-based programs, uemail is a large program by TOS
standards.  It was ported from a two megabyte 68K system and scaled down to
fit in the small memory of a 1040ST. It requires more than 128K to load.
To support shell commands, it returns 256K to the operating system at
startup.  On the 68K system the shell command required only 12K of code and
128K of operating space and did not require loading a command processor to
get at the operating system.  But since the ST has no command control
processor, you must load a shell program such as COMMAND.PRG or
PCOMMAND.PRG to get at the file system.  You may run any TOS based program
from within the editor, but programs that require a GEM interface will
crash the system.  You will have to exit the editor entirely to run GEM
programs as there is just not enough extra memory to run GEM programs.
 
Running uemail from within a shell program diminishes the available text
buffer space.  The return TPA command (ESC-@) reports the amount of space
used and the amount available.  Long source code files (900 or more lines)
are the biggest memory eaters.  If uemail runs directly from the desktop,
buffer space is rarely a problem even with a 360K ramdisk loaded, but
running this program and trying to edit large files on a 520ST may be a
problem if ramdisks or numerous desk accessories are in memory.  Files
consume approximately one and one-half times their physical size.  Text
files consume a little less, and because program code often has a number of
blank lines for which space must be allocated, it consumes somewhat more
memory in relation to its size.
 
The main reason for the size of the program is the added kermit utility not
usually found in a text editor, and the aliasing system for loading text
files and shell programs.  The disadvantage of tying these functions into
the program and using up memory space is outwayed by the advantage gained
by integration.  The ability to transfer text directly into and out of an
editor buffer saves time and programming effort.  The integrated program
also gives the programmer a relatively easy way to implement individual
protocol schemes to communicate with remote systems since all of the
readaux and sendaux functions are already defined.  If the kermit section
and the terminal section were to be separate from the editor, then loading
those free standing programs into memory would require a larger shell space
as each of those programs would be linked to its own copy of the run-time
library.  Finally, the additional features make the editor more of an
all-purpose tool, the type of program that can be loaded and serve as a
simple shell from which to carry out most tasks on the computer.
 
Uemail is designed to work in tandem with GNU_EMACS on a remote computer.
When the program is connected to the serial line, all of the function keys
and the number pad keys send the same commands as they do from within
uemail, and the defined keyboard macros (macros triggered by the accent
grave key) are also sent across the line. This allows you to set up special
function key definition files and macro definition files to use with a
remote emacs. Macro files can be loaded into memory from within an editor
buffer or while online using the terminal section.
 
In addition to the direct connect terminal section, uemail has a connect
mode which supports kermit protocol for 7-bit transfers between two
computers. This ability allows the editor to work with text from a remote
system and to transfer it back to that system when done.  For remotes that
do not support the kermit protocol there are log and transfer commands
which use the ST's flow control (settable from within the terminal mode) to
transfer text without dropping characters (provided that the remote
supports one of the ST's handshaking protocols).  Because the modem I have
does not support RTS/CTS, I have not been able to determine if it works as
well with an RTS/CTS protocol as it does with XON/XOFF.  Uemail sets the
baud rate while in connect mode.  At the beginning of the connect session,
the baud rate defaults to 1200 bps, but it can be reset to 300, 2400, 9600,
or 19200 bps.  When uemail exits from terminal mode, it saves the terminal
screen.  When it returns to terminal mode, it rewrites that screen placing
the cursor at its previous position.  You cannot set parity or stop bits
from within the terminal section, if anyone finds this to be a problem, let
me know, and I'll figure a way to get around it.  However, you can always
run a TOS-based modem program from within uemail that can set the additional
parameters.  The sample alias file shows how to define an xmodem program
that will run when the CTRL-C command is given `xmodem' for a program name.
 
Macro commands are a quick way to automate repetitive tasks, and they also
may be used to send strings, such as dial commands or logon scripts, to a
modem.  The limitations of the execute macro command (CTLX-E) in many
microemaxen are only one macro may be defined at a time, defining a new
macro kills the old one, macros cannot be saved across editing sessions,
and macros cannot be loaded from a disk file.  Uemail overcomes these
limitations while retaining the "flavor" of the original define and execute
macro command.  Any macro defined by the define macro command (CTLX-() may
be assigned to a key on the keyboard using the getmacro command (CTLX-`)
which will prompt for the key to bind.  The current keyboard macro is
copied into a safe place in memory, and a pointer to it is stored in a
macro table (a dynamically allocated structure).  From then on typing the
accent grave (`) key followed by the key that you assigned to that macro
will cause the appropriate macro to execute.  Macros can then be saved to
disk, using the `-CTRL-M command, for later loading, using the `-CTRL-L
command.  When the editor starts up, it attempts to load the file
UEMAIL.MCR default macro file from the default drive and path.  The
off-line program EXTMAC reads a macro file and writes a C-code equivalent
of each function to a file.  This external program, which can be run using
the shell command, replaces the old C-Mac buffer scheme in previous
versions and, unlike the earlier built-in function, will create C-code for
any defined macro.
 
Macro files may also be loaded from the terminal mode using the ALT-L
command.  Macros are used in the terminal mode the same way as they are in
an editor buffer (by typing a ` followed by the appropriate character).
Macros are of two basic types: character strings and command strings.
Character strings are words that have been typed to the screen while
defining a macro.  For example from within a buffer you can type the begin
macro command, type "ATDT5551234<CR>," followed by the end macro command
(CTLX-)), and the getmacro command (CTLX-`), binding this string to `5.
Then from the terminal section you can type `5 to send the string to your
modem. Command strings are macros which would normally cause uemail to
execute a series of commands (such as CTRL-A CTRL-O to go to the beginning
of the line and open a blank line above it).  Command strings make the most
sense when uemail is serving as a terminal connection to a remote Emacs
editor, allowing you to define a set of macros that behave the same way in
both editors.
 
As of version 33 of uemail ST, the cc command is an off-line program which
runs in the space uemail returns to the operating system.  The sample
start-up file (cc.ini) shows how to define an alias for CC.PRG which makes
the new interface transparent.  The CC.PRG will also run by itself to drive
the Alcyon compiler.  It accepts wildcards or multiple files on the command
line, can compiler or simply assemble a file.  (It goes directly to the
assembler for any file with an `.S' file type.)  It will link a group of
files if the cc.ini file has the `dolink=1' command in it.  It will compile
the files first if you supply a command line.  With no command line and the
dolink option on, the program will skip compilation and go directly to the
linker.  It envokes the linker by passing it a command file whose first
name is that defined in the cc.ini file as the `linkfile.'  If the linker
is successful, the program will attempt to relmod the resulting linker
output. To make all of this work properly you must define the parts of your
cc.ini program correctly.  the source directory is where the compiler,
assembler, and relmod expect to find their input files.  The temp directory
is where the assembler places its output.  The program expects the linkfile
to be on the source directory and assumes that the linkfile contains a
complete link68 script.  It also assumes that the linker output file will
have the same filename as the linkfile name, that the extension will be
68K, and that it will be located on the source directory.  Because the
link68 program cannot handle filenames longer than 13 letters, including
the path and drive, your filename plus source directory should be no more
than 10 characters long.
 
WARNING:  it is not safe to batter the CTRL-C key while CC.PRG is running in
the background as this will often send you back to the desktop (OK if you
have saved your files).  Instead if you find runaway errors while compiling,
type CTRL-S first and wait for the program to stop; then type one CTRL-C.
Future versions of uemail will incorpaorate a buffer in which to run all
shell commands.  That buffer will allow you to type a number of different
halt commands to stop runaway background programs.  It will also let you
keep the program output.  This will require operating system redirection and
all sorts of stack manipulation, so don't expect it any time soon, but a
version with this feature is currently running under CP/M-68K using the
Alcyon compiler.
 
One added ability the command buffer will give is being able to run SID
from within the editor and, with a split screen, to read the source for a
file currently being debugged.  The CP/M version uses the <ESC> key to
suspend the background process and return to the editing buffer.  That
allows the background program to be reentered at anytime without having it
reloaded.  Using SID this way to debug a file for which the symbols table
has remained intact, is very close to using the fancy symbolic debuggers on
other systems.  With two megs you can even load the assembly source code
produced by the compiler and go line by line through SID.  But these are
features not yet available for the ST version.
 
The aliasing feature mention above is implemented via the cc.ini file.  When
uemail starts up, it attempts to read the file from the current directory
and drive.  It attempts to read this file before any initialization takes
palce; therefore, you can use aliases (provided the cc.ini file is on the
correct drive and directory) on the startup line.  The cc.ini file (example
below) may contain any aliases you wish to use.  And new files may be loaded
from the disk (using CTLX CTRL-E) at any time.  The function key and number
pad definitions do not cause any additional space to be allocated.  But all
other aliases do use space (approximately 10 bytes plus the number of
characters in the alias string and the definition per each alias).
 
Aliases are freed from memory and new pointers are installed everytime the
alias function sees a matching alias name, it does not check to see whether
the aliases value is the same as the original, but simply reallocates space
and frees the old value.  This means that alias files need not contain
every value that is needed.  For example you might wish to redefine the
number pad or the function keys but not change the paths.  You can do this
by creating an alias file listing just those keys you wish to redefine and
loading that file with the CTLX-CTRL-E command.  The alias file also
controls the screen color with a color monitor; however the load alias
command issued from an editing buffer does not automatically update the
screen.  The new colors will be installed if you issue the set global modes
command and give it the word `color' as a mode name.  The colors will also
be installed when you return from a terminal session or from a background
(shell) operation.  The load command file command is also available from
the modem section using the ALT-E key.  In that case the colors are
installed immediately.  The following is a sample cc.ini file:
 
/* cc.ini file for cc.prg and uemail.prg
 * the first ten are used by the cc or link commands. the aliases must
 * be spelled as they are here and must be in lower case. change the
 * path names to match your set-up.
 */
/* these are for the cc.prg which also reads this file */
source=e:                       /* C, lnk, and 68K files        */
include=d:\stdlib.h\            /* headers                      */
temp=m:                         /* temporary files, o files, and final prg  */
symb=c:\bin\                    /* as68symb.dat                 */
bin=c:\bin\                     /* compilers, assembler, linker, and loader */
syslib=c:\bin\                  /* library directory            */
linkfile=xemacs                 /* filename of link command file*/
float=                          /* flag for floating point -f, -e or nil*/
dolink=1                        /* if 1, call linker after compiling file[s] */
delete=1                        /* delete I, S, 68K files? 1==YES       */
/* the next two are used by shell */
shell=c:\util\pcommand.prg      /* shell program        */
xmodem=c:\comm\bmodem.ttp       /* xmodem program       */
extmac=c:\uemail\extmac.ttp     /* extract macros       */
cc=c:\uemail\cc.prg             /* compiler driver      */
/* these are not used and if not needed, may be deleted */
home=c:\uemail\                 /* where it all began   */
root=c:\                        /* boot directory       */
assembly=d:\assembly.s\         /* assembly sources     */
etc=c:\util\                    /* utility programs     */
comm=c:\comm\                   /* communications       */
arc=c:\util\arc.ttp             /* arc cruncher         */
vt100=c:\comm\vt100.tos         /* small vt100 prog     */
/* set up colors the way I like. aliases and color names must be lower
 * case.  additional colors are grey, magenta, teal, green, yellow, and
 * white. cobalt is a deep blue. if colors are not aliased, you get
 * white on black as default.
 */
border=black                    /* color #0             */
desk=cobalt                     /* color #2             */
cursor=red                      /* color #1             */
letter=black                    /* color #3             */
/* function key bindings for uemail.ttp The F must be upper case */
F1=setmark                      /* sets the mark        */
F2=listbuffers                  /* lists current buffers        */
F3=filename                     /* change current filename      */
F4=writeregion                  /* write text between point and mark to file */
F5=fileinsert                   /* insert file at point         */
F6=fileread                     /* read file into current buffer*/
F7=filevisit                    /* visit (find) a file          */
F8=filewrite                    /* write out buffer to named file       */
F9=filesave                     /* save current buffer if changed       */
F10=quit                        /* save all changed buffers and exit    */
/* Number pad bindings for uemail.ttp. the N must be upper case as must
 * the word NENTER.
 */
N(=backword                     /* backward word        */
N)=forwword                     /* forward word         */
N/=grtw                         /* globally remove trailing whitespace */
N*=retversion                   /* return current version to message line */
N7=gotobol                      /* goto beginning of line */
N8=gotoeol                      /* goto end of line     */
N9=rettpa                       /* return usage to message line */
N-=pageback                     /* back by one text page (60 lines default) */
N4=backsent                     /* goto beginning of sentence */
N5=forwsent                     /* goto end of sentence */
N6=unkncom                      /* unknown              */
N+=pageforw                     /* forward by one text page */
N1=gotbop                       /* goto beginning of paragraph (blank line) */
N2=goteop                       /* goto end of paragraph (blank line) */
N3=unkncom                      /* unknown              */
N.=forwdel                      /* delete character under cursor */
NENTER=indent                   /* newline and indent   */
 
Each line must be formatted as above.  The word before the equal sign is
the `alias' name used by the program, and the line to the left of the equal
sign is the actual path name assigned to the aliased variable.  There can
be no embedded blanks or tabs in a name or alias, but comments may appear
on any line as long as there is at least one space or tab character between
the end of the path and the beginning of the comment.  No special comment
characters are necessary although using standard comment markers like those
above help to make the comments more readable.  The order of definitions is
unimportant, and lines that contain no `=' signs are ignored.
 
The aliasing mechanism attempts to find aliases for any command file you
type at the shell command (but not for the command line arguments).  Typing
`cc' after issuing the shell command (CTRL-C) and the filename at the
command line prompt invokes the compiler driver CC.PRG. It will also expand
`temp' to m:\ because it does not check to see is the aliased name makes
sense in context.  If the aliased name would not load, you will receive an
error message on the message line. You also can use the aliases the usual
way in the shell command.  If the first character of the program name is a
`~,' the function will attempt to expand the aliased path.  Thus
`~etc\arc.ttp' is the same as `arc' and `c:\util\arc.ttp.'
 
The set path command and all the file commands also use the alias table. If
at the command's prompt you type a line which begins with a `~', these
commands look up the word after the ~ and test it against the known
aliases.  If the word match matches a known alias, the string associated
with that alias is copied into the filename.  Thus if "temp=c:\files\temp"
is in the cc.ini file at startup, typing the read file command CTRL-X
CTRL-R and asking for the file ~temp\test.i will read in the file
c:\files\temp\test.i (note that the `\' character is necessary, and the `~'
must be the first character on the line).
 
Uemail also supports writers.  In addition to the useful macro function,
uemail provides sentence, paragraph, and page movement commands.  It
provides two punctuation movement commands, forward to next punctation and
backward to previous puntuation, useful for moving to the next comma or
quotation mark in a text.  Uemail extends the usual microemacs on-screen
editing features, adding an indent column with the ability to define an
indent prefix.  Unlike other versions of microemacs, uemail's fill
paragraph command leaves the cursor inside the paragraph in the same spot
where it was when the command was issued.  There are line-based commands for
formatting texts.  The flushleft, flushright, center, transpose words, and
globally delete trailing whitespace all deal with text appearance.  The
indent subsequent newline same as this lets you open a line underneath the
present line with the same indentation without having to be at the end of
the present line.  The drop line and indent command works similarly but
inserts the new line above the present line.  Both of these functions are
not only useful for formatting text, but also for indenting program code.
 
Uemail provides a rudimentary interface for a spelling checker.  If your
spelling checker uses the standard spell correction mark (0x93), the
program will search for that character in your file when you type the go
spell command (CTLX-S), placing your cursor at the beginning of the word to
correct. The program has a word count function which reports the average
size of words in a buffer.  This function reports the length of your buffer
in letters and characters.  It uses the letter total to determine averages.
This leads to a more accurate average than methods which divide the total
number of characters in a buffer by the total number of words.
 
Uemail can print buffers with page numbers, two header lines, and single or
double spacing.  The page size is settable, and the internal code
automatically sets up any Diablo/Xerox compatible printer for standard 12
pitch type.  The program can print while editing (as long as there is
keyboard activity), and if you try to exit while printing, uemail will ask
whether you want to exit for sure.  In order for the print buffers command
to work properly, be sure to define a temp directory in your cc.ini file.
 
Uemail allows you to set your colors at start up to any four of nine
possible colors (black, white, grey, teal, red, green, yellow, magenta, and
cobalt).  Each of the four parts of the screen is attached to a color.  You
may use up to four color, defining them with lines in your cc.ini file (see
example above).  When you read a new set of colors, you update the colors
on the screen by issuing the set global modes command (META-M) and choosing
color as the new mode.  If you are currently in the kermit mode, the colors
are automatically updated when you load the file.  The aliasing mechanism
allows you to write short color files that contain only the information
needed to set up the colors you want and to load them into memory as
needed.  One additonal command (CTLX-C) alllows you to switch your
background to any color currently defined.  The command is intelligent
enough to prevent the screen from "dissappearing" if you choose to make the
background the same as the letter color (background is the `desk').  For
example, if your desk is cobalt and your letters are black, issuing the
command and answering black for the new color will give you a black desk
with blue letters and a blue border.  A similar transposition occurs if you
wish the background to be the color of the cursor.
 
Unlike most microEmaxen, uemail follows the GNU_EMACS convention of
writing all `dirty' buffers when exitting.  If a normal exit is chosen
(CTLX-CTRL-C) and no argument is given, the program asks the user whether
individual modified files should be saved.  The quick exit command (CTRL-Z)
saves every modified buffer without asking.  The ST is prone to BUS and
address errors, uemail tries to protect the user from these by intercepting
the vectors associated with these exceptions. When the code signals an
error, the program gives you the opportunity to save your files before
restoring the system and exiting.  This can avoid a lot of frustration.
 
The following list of commands is arranged according to category.  The
column marked KEY shows the keystrokes bound to the command.  The column
marked COMMAND gives the internal name of the command that uemail uses.
And the DESCRIPTION gives a brief explanation of what the command does.  In
the chart, the ^ character in front of a letter means that letter is a
control character; ESC is the escape key, and ` is the accent grave.  Any
ESC sequence that uses a simple alphabetic key as the second argument is
reachable using the ALT key while typing the alpha key.  For example both
ESC-F and ALT-F move forward one word.  The difference between the two
options is that the ESC version requires typing two keys, while the ALT
version requires one "shifted" keystroke.  Some of the commands below react
differently depending upon whether the function is passed a numeric
argument.  Numeric arguments are used most often to cause commands to
repeat a set number of times.  There are two ways to signify an argument to
a function.  Each method requires typing a repeat command before typing the
function.  The two repeat commands are CTRL-U and the ESC key followed by
any digit or by the negative sign.  CTRL-U is called the universal prefix
and always defaults to four repeats.  Typing CTRL-U repeatedly multiplies
the repeat count.  The count echos to the message line.  Typing ESC
followed by a number does essentially the same thing but allows you to
choose the number directly.  For example: ESC-2 followed by CTRL-K deletes
two full lines forward, which is equivalent to deleting a line and the
trailing newline.  Some commands look for zero arguments to change their
normal actions.  For example: CTLX-D is the set path command; however, when
it is prefaced with ESC-0 or CTRL-U-0, it returns the current default drive
and path to the message line.  The showtime command is similar.  If it is
called normally, without an argument, or if it is called with a zero or
negative argument, it writes the current time to the message line.  If it
is called with a possitive argument less than 1000 (a special case), it
writes the time into the document at the current position.  The 1000 value
is used by the kermit section to write to the message line.  Since the
kermit section must use a different message writing scheme from that used
by the editor.
 
Commands for Uemail
===================
KEY (lower case OK)     COMMAND                 DESCRIPTION
--------------------------------------------------------------------------
MISCELLANEOUS UTILITIES
ESC-~           clearflag();            /* Clear changed buffer flag    */
^X-~ or ^C      shell();                /* run a child process or cc    */
^Q              quote();                /* Insert literal               */
^G              ctrlg();                /* Abort out of things          */
^X-^C           quit();                 /* Quit prompt to save files    */
^Z              quickexit();            /* low keystroke exit and save  */
^X-=            showcpos();             /* Show the cursor position     */
^X-W            wc();                   /* word and line count of buffer*/
^X-*            retversion();           /* version date                 */
^X-M            setmode();              /* set a mode for a buffer      */
^X-^T           showtime();             /* tell the time or insert in buffer */
ESC-M           sglmode();              /* set global mode              */
ESC-X           mdoncom();              /* do named command             */
ESC-@           rettpa();               /* show available memory and usage */
ESC-^N          enumerate();            /* start or incr. counter variable */
Lots-o-keys     unkncom();              /* unknown command BEEP         */
 
FILE OPERATIONS
^X-^E           commfill();             /* Read a cc.ini command file   */
^X-I            fileinsert();           /* Insert existing file at point*/
^X-^R           fileread();             /* Get a file, into existing buf*/
^X-^V           filevisit();            /* Get a file, new buffer       */
^X-^W           filewrite();            /* Write a file                 */
^X-^S           filesave();             /* Save current file            */
^X-^F           filename();             /* Change file name             */
^X-D            setpath();              /* set path if arg=0 get path   */
 
CURSOR MOVEMENT
^A              gotobol();              /* Move to start of line or prev*/
^E              gotoeol();              /* Move to end of line or next  */
^B              backchar();             /* Move backward by characters  */
^F              forwchar();             /* Move forward by characters   */
^P              backline();             /* Move backward by lines       */
^N              forwline();             /* Move forward by lines        */
ESC-V           backpage();             /* Move backward by screens     */
^V              forwpage();             /* Move forward by screens      */
ESC-B or ESC-^B backword();             /* Backup by words              */
ESC-F or ESC-^F forwword();             /* Advance by words             */
ESC-N           goteop();               /* goto end of paragraph        */
ESC-P           gotbop();               /* goto beginning of paragraph  */
^X-<            btopunct();             /* move backward to last punctuation */
^X->            ftopunct();             /* move forward to next punctuation  */
ESC-A           backsent();             /* backward to beginning of sentence */
ESC-E           forwsent();             /* forward to end of sentence   */
ESC-, or ESC-<  gotobob();              /* Move to start of buffer      */
ESC-. or ESC->  gotoeob();              /* Move to end of buffer        */
ESC-G           goline();               /* goto arg line in text        */
^@ or ESC-SP    setmark();              /* Set mark                     */
^X-^X           swapmark();             /* Swap "." and mark            */
 
DOCUMENT FORMATTING
^X-#            setpage();              /* set page size to arg length  */
^X-!            paginate();             /* insert '\f' every page       */
^X-+            pageforw();             /* move forward set page length */
^X-- (dash)     pageback();             /* move back set page length    */
^X-TAB          print();                /* print buffer with heading    */
^X-F            setfillcol();           /* Set fill column.             */
ESC-Q           fillpar();              /* fill paragraph to fill column*/
^X-.            setindcol();            /* Set indent column or prefix  */
^T              twiddle();              /* Twiddle characters           */
ESC-T           twaddle();              /* transpaose two words in place*/
TAB             tab();                  /* Insert tab                   */
RETURN          newline();              /* Insert CR-LF                 */
^J              indent();               /* Insert CR-LF, then indent    */
^O              openline();             /* Open up a blank line         */
^X-^O           deblank();              /* Delete blank lines           */
ESC-O           mdropln();              /* drop current line and move up*/
ESC-J           mindnl();               /* indent subsequent NL same as this */
ESC-\           mdelind();              /* delete beginning line indentation */
ESC-^R          mrflush();              /* flush right current line     */
ESC-^C          mcenter();              /* center current line          */
^X-\            grtw();                 /* remove trailing white space  */
ESC-^O          clowsp();               /* close up intervening white space  */
ESC-^P          tglcase();              /* toggle case of letter at point    */
 
BUFFERS AND WINDOWS
^X-^B           listbuffers();          /* Display list of buffers      */
^X-B            usebuffer();            /* Switch a window to a buffer  */
^X-K            killbuffer();           /* Make a buffer go away.       */
ESC-!           reposition();           /* Reposition window            */
^L              refresh();              /* Refresh the screen           */
^X-^N           mvdnwind();             /* Scroll window down           */
^X-^P           mvupwind();             /* Scroll window up             */
^X-N            nextwind();             /* Move to the next window      */
^X-P or ^X-O    prevwind();             /* Move to the previous window  */
^X-1            onlywind();             /* Make current window only one */
^X-2            splitwind();            /* Split current window         */
^X-Z            enlargewind();          /* Enlarge display window.      */
^X-^Z           shrinkwind();           /* Shrink window.               */
^X-C            paintbuffer();          /* change the backgound color   */
 
DELETION AND REGIONS
ESC-H           markpar();              /* mark paragraph sets mark     */
^D              forwdel();              /* Forward delete               */
DEL             backdel();              /* Backward delete              */
ESC-TAB         kill();                 /* Kill line forward            */
^Y              yank();                 /* Yank back from killbuffer.   */
ESC-U           upperword();            /* Upper case word.             */
ESC-L           lowerword();            /* Lower case word.             */
^X-^L           upperregion();          /* Upper case region.           */
^X-^U           lowerregion();          /* Lower case region.           */
ESC-C           capword();              /* Initial capitalize word.     */
ESC-D           delfword();             /* Delete forward word.         */
ESC-DEL         delbword();             /* Delete backward word.        */
^K              mdeleln();              /* delete entire line from beginning */
ESC-^K          mdelwln();              /* delete entire line including NL   */
ESC-K           killsent();             /* kill sentence forward sets mark */
^W              killregion();           /* Kill region.                 */
ESC-W           copyregion();           /* Copy region to kill buffer.  */
^X-R            writereg();             /* write defined region to file */
 
SEARCHING
^S              forwsearch();           /* Search forward               */
^R              backsearch();           /* Search backwards             */
ESC-R           replace();              /* Search and replace           */
`^R or ESC-^T   backisearch();          /* Incremental search back      */
`^S or ESC-^S   forwisearch();          /* Incremental search forward   */
^X-S            gospell();              /* Search for 0x93 (unix spell) */
 
Function Key, Cursor Pad, and Numeric pad bindings.  The keycode associated
with the primary EMACS binding for each of the rebound functions is sent
over the serial line.  This allows you to set up your bindings at the ST to
match those you normally use with the EMACS on a remote computer.
 
KEY             FUNCTION
===========================
F1              setmark()
F2              listbuffers()
F3              filename()
F4              writeregion()
F5              fileinsert()
F6              fileread()
F7              filevisit()
F8              filewrite()
F9              filesave()
F10             quickexit()
Number pad      (bound to functions except when CapsLock is on)
(               backword()
)               forwword()
/               grtw()
*               retversion()
7               gotobol()
8               gotoeol()
-               pageback()
4               backsent()
5               forwsent()
+               pageforw()
1               gotbop()        /* beginning of paragraph */
2               goteop()        /* end of paragraph */
0               Control-X prefix
               forwdel()
ENTER           indent()
[All of the other number pad keys are bound to unkncom() (the unknown
command function), but those can be rebound to something useful through a
command file.]
[The cursor pad cannot be rebound.  It would not be that difficult to add
this feature to the source.]
CURSORS         what they look like they should do
INSERT          openline()
UNDO            yank()
HELP            kermit()        showhelp() in terminal mode
CLR             refresh()
 
KERMIT (and subcommands)
^_ or HELP      kermit();               /* file transfer */
 ________________
| [The following subcommands are supported.  Only the first letter is
|  significant.]
|  send         send a file (in a uemail buffer) to remote kermit
|  receive      receive a file from remote
|  put          send a file in server mode
|  get          recieve in server mode (uemail prompts for remote name)
|  finish       finish remote kermit server mode
|  bye          finish server and logoff remote
|  transfer     send a uemail buffer to remote appending EOF to end
|  emacs        same as above but without EOF
|  log          copy remote session into a uemail buffer (`^\ turns it off)
|  connect      connect to the RS232 line in terminal mode
|  ^G           abort a kermit session (get, put, rec, send, fin, or bye)
|               Use this if one of the kermit commands appears to "lock up"
 ================
|  [Terminal mode commands.]
|       ALT-CTRL-B      send break
|       ALT-CTRL-C      run program or shell
|       ALT-B           set baud rate (prompts for value)
|       ALT-C           change background color
|       ALT-E           load alias file and update color
|       ALT-L           load macros file
|       ALT-O           turn off handshaking
|       ALT-R           use RTS/CTS handshaking
|       ALT-T           show time on mode line
|       ALT-X           use XON/XOFF handshaking
|       ALT-?           show help information
|       HELP            show help information
|       ALT-UNDO        exit terminal mode (return to current uemail buffer)
|       ALT-any-other   sends the character (i.e. NULL)
 ----------------
 
MACROS
======
^X-(            ctlxlp();               /* Begin macro                  */
^X-)            ctlxrp();               /* End macro                    */
^X-E            ctlxe();                /* Execute macro                */
 ________________
| The following commands let you bind a macro that was defined using
| ^X( to any keyboard key.  That macro can be executed using the accent
| grave (putmacro) command.  The macros can be saved to disk and reloaded
| when needed.
 ----------------
` (grave)       putmacro();             /* print line macros in text    */
^X`             getmacro();             /* bind current kbdm to key     */
[The following macros are predefined and cannot be rebound.]
`^G             abort
`^L             load a file of previously defined macros
`^M             write currently defined macros to file
`^R             incremental search back
`^S             incremental search forward
`^T             show time on mode line
``              insert an accent grave
