/*
 * The routines in this file
 * provide support for Atari ST terminals
 * over a serial line. The serial I/O services are
 * provided by routines in "osbind.h".
 */
#include        <stdio.h>
#include        "ed.h"
 
#if     ST
#include <osbind.h>
 
#define NROW    25                      /* Screen size.                 */
#define NCOL    80                      /* Edit if you want to.         */
#define MARGIN  8                       /* Size of minimum margin and   */
#define SCRSIZ  64                      /* Scroll size of extended lines*/
#define BIAS    0x20                    /* Origin 0 coordinate bias.    */
#define ESC     0x1B                    /* ESC character.               */
#define BEL     0x07                    /* ascii bell character         */
 
extern  int     ttopen();               /* Forward references.          */
extern  int     ttgetc();
extern  int     ttputc();
extern  int     ttflush();
extern  int     ttclose();
extern  int     stmove();
extern  int     steeol();
extern  int     steeop();
extern  int     stbeep();
extern  int     stopen();
extern  int     strev();
 
/*
 * Dispatch table. All the
 * hard fields just point into the
 * terminal I/O code.
 */
TERM    term    = {
        NROW-1,
        NCOL,
        MARGIN,
        SCRSIZ,
        &stopen,
        &ttclose,
        &ttgetc,
        &ttputc,
        &ttflush,
        &stmove,
        &steeol,
        &steeop,
        &stbeep,
        &strev
};
 
stmove(row, col)
{
        Bconout(2,ESC);
        Bconout(2,'Y');
        Bconout(2,row+BIAS);
        Bconout(2,col+BIAS);
}
 
steeol()
{
        Bconout(2,ESC);
        Bconout(2,'K');
}
 
steeop()
{
        Bconout(2,ESC);
        Bconout(2,'J');
}
 
stbeep()
{
#ifdef  BEL
        Bconout(2,BEL);
        ttflush();
#endif
}
 
strev(status)
int status;
{
        if (status)
                {
                Bconout(2,ESC);
                Bconout(2,'p');
                }
        else
                {
                Bconout(2,ESC);
                Bconout(2,'q');
                }
}
 
stopen()
{
#if     V7
        register char *cp;
        char *getenv();
 
        if ((cp = getenv("TERM")) == NULL) {
                puts("Shell variable TERM not defined!");
                exit(1);
        }
        if (strcmp(cp, "st") != 0 && strcmp(cp, "z19") != 0) {
                puts("Terminal type not 'st25' or 'vt52' !");
                exit(1);
        }
#endif
        ttopen();
}
#endif
 
