/* Printer defines for Brother Letter quality printers */
 
#define BUFSIZE 512     /* 4 * 128 */
#define MYBUF 1536      /* 3/4 of my print buffer */
#define ESC 0x1b
#define FORMFEED '\f'
#define TAB 0x09
#define SPACE  ' '
#define NEWLINE  '\n'
#define CR '\r'
#define RS 0x1e
#define US 0x1f
#define RN 0x50
 
extern int tabsize;
extern int isnprint;
static int in;          /* file descriptor for low level printer I/O */
static int spacing;
static int temptab;
static int linecnt;
static char *prnstr;
int pagecnt;
 
#define RESET Cprnout(ESC);Cprnout(CR);Cprnout(RN)
#define NEWPAGE Cprnout(FORMFEED);Cprnout(CR)
#define PRINT(arg) Cprnout((arg))
#define SET_LMARG Cprnout(ESC);Cprnout(0x39);\
        Cprnout(CR)
#define SET_TAB Cprnout(ESC);Cprnout(0x31)
#define SET_PITCH(arg) Cprnout(ESC);Cprnout(US);\
        Cprnout((arg))
#define SET_HEIGHT(arg) Cprnout(ESC);Cprnout(RS);\
        Cprnout((arg))
#define PRNOUT(arg1,arg2) Cprnout(ESC);Cprnout((arg1));\
        Cprnout((arg2))
