; shdw_struct();            /* C calling sequence */
;===========================
; SHDW_STRUCT
;===========================
shdw_struct:
    MOVE.W  #$0, -(A7)      ; function number (returns pointer to shdw_rec)
    TRAP    #15             ; D0 contains pointer to structure on return
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_receive(buffer, length, mode);   /* C calling sequence */
;===========================
; SHDW_RECEIVE
;===========================
shdw_receive:
    MOVE.L  12(A6), -(A7)   ; push length of buffer  (length)
    MOVE.L  8(A6), -(A7)    ; push pointer to buffer (buffer)
    MOVE.W  16(A6), -(A7)   ; push transfer option   (mode)
    MOVE.W  #$1, -(A7)      ; push function number
    TRAP    #15
    ADDA.L  #$c, A7         ; clean up stack
    RTS

; shdw_send(buffer, length, mode);      /* C calling sequence */
;===========================
; SHDW_SEND
;===========================
shdw_send:
    MOVE.L  12(A6), -(A7)   ; push length of file to send (moot for batch)
    MOVE.L  8(A6), -(A7)    ; push pointer to buffer
    MOVE.W  16(A6), -(A7)   ; push transfer option
    MOVE.W  #$2, -(A7)      ; push function number
    TRAP    #15
    ADDA.L  #$c, A7         ; clean up stack
    RTS

; shdw_abort();             /* C calling sequence */
;===========================
; SHDW_ABORT
;===========================
shdw_abort:
    MOVE.W  #$3, -(A7)      ; function number (abort all transfers)
    TRAP    #15
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_digits();            /* C calling sequence */
;===========================
; SHDW_DIGITS
;===========================
shdw_digits:
    MOVE.W  #$4, -(A7)      ; function number (turn on on-screen count)
    TRAP    #15
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_nodigits();          /* C calling sequence */
;===========================
; SHDW_NODIGITS
;===========================
shdw_nodigits:
    MOVE.W  #$5, -(A7)      ; function number (turn off on-screen count)
    TRAP    #15
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_bell();              /* C calling sequence */
;===========================
; SHDW_BELL
;===========================
shdw_bell:
    MOVE.W  #$6, -(A7)      ; function number (turn on completion bell)
    TRAP    #15
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_nobell();            /* C calling sequence */
;===========================
; SHDW_NOBELL
;===========================
shdw_nobell:
    MOVE.W  #$7, -(A7)      ; function number (turn off completion bell)
    TRAP    #15
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_init();              /* C calling sequence */
;===========================
; SHDW_INIT
;===========================
shdw_init:
    MOVE.W  #$8, -(A7)      ; function number (call to restart or init)
    TRAP    #15             ; this function is not needed by user!
    ADDQ.L  #2, A7          ; clean up stack
    RTS

; shdw_dial(number, connect, fail1, fail2);     /* C calling sequence */
;===========================
; SHDW_DIAL
;===========================
shdw_dial:                  ; dial a number in background
    MOVE.L  20(A6), -(A7)   ; fail2 string
    MOVE.L  16(A6), -(A7)   ; fail1 string
    MOVE.L  12(A6), -(A7)   ; connect string
    MOVE.L  8(A6), -(A7)    ; number string (pass zero here to abort)
    MOVE.W  #$9, -(A7)      ; function number
    TRAP    #15
    ADDA.L  #$12, A7        ; clean up stack
    RTS

; shdw_check();             /* C calling sequence */
;===========================
; SHDW_CHECK
;===========================
shdw_check:                 ; this function checks for Shadow's presence
    CLR.L   -(A7)           ; must execute this code in
    MOVE.W  #$20, -(A7)     ; Supervisor mode
    TRAP    #1              ; GEMDOS
    ADDQ.L  #6, A7          ; pop stack

    CLR.L   D2              ; set to fail status
    MOVEA.L $42e, A0        ; get phys_top
    CMPA.L  #$400000, A0    ; is it 4 meg boundary?
    BEQ.B   nxtck           ; yep, check for NON RESET PROOF mode
    CMPI.W  #$dc, (A0)      ; does phys_top point to #$00DC (magic number)?
    BNE.B   nxtck           ; nope, check for NON RESET PROOF handler
    MOVE.L  #2, D2          ; set status for NON RESET PROOF mode
                            ; shadow clears buffer pointer and length
                            ; automatically when in NON RESET PROOF mode
                            ; with RAMdisk installed
    TST.L   2(A0)           ; is transfer buffer allocated?
    BEQ.B   leave           ; nope, bye
    MOVE.L  #3, D2          ; set status to indicate installed with buffer
                            ; and rez change when in NON RESET PROOF mode
    CMPA.L  16(A0), A0      ; is buffer below phys_top?
    BGT.B   leave           ; yes, must be NON RESET PROOF w/rez change
    MOVE.L  #1, D2          ; RESET PROOF SHADOW is here, return 1
    BRA.B   leave           ;

nxtck:
    MOVE.L  $bc, A0         ; get trap #15 vector
    SUBA.L  #22, A0         ; get pointer to start of SHADOW rec
    CMPI.W  #$dc, (A0)      ; is it magic?
    BNE.B   leave           ; nope, nothing installed
    MOVE.L  #3, D2          ; set status to indicate installed with buffer
                            ; and rez change when in NON RESET PROOF mode
    TST.L   2(A0)           ; buffer allocated?
    BEQ.B   leave           ; yes, definitely a rez change
    MOVE.L  #2, D2          ; nope, must be a reset in NON RESET PROOF mode
                            ; and just started or buffer not allocated yet
leave:
    MOVE.L  D0, -(A7)       ; leave supervisor mode
    MOVE.W  #$20, -(A7)
    TRAP    #1
    ADDQ.L  #6, A7
    MOVE.L  D2, D0          ; return status
                            ; 1 = RESET PROOF
                            ; 2 = NON RESET PROOF with no transfer buffer
                            ; 3 = NON RESET PROOF with transfer buffer
    RTS

; shdw_timeout(seconds);    /* C calling sequence */
;===========================
; SHDW_TIMEOUT
;===========================
shdw_timeout:
    MOVE.W 8(A6),-(A7)      ; push time in seconds or -1 for current timeout
    MOVE.W #10,-(A7)        ; peform SHADOW function #10
    TRAP   #15              ; call it
    ADDQ.L #4, A7           ; fix up stack
    RTS                     ; returns current timeout seconds (if passed -1)
                            ; or current timeout multiplied by 60
                            ; if passed positive values

; shdw_version();           /* C calling sequence */
;===========================
; SHDW_VERSION
;===========================
shdw_version:
    MOVE.W #11,-(A7)        ; perform SHADOW function #11
    TRAP   #15              ; call it
    ADDQ.L #2, A7           ; fix up stack
    RTS                     ; returns an integer value equal to the current
                            ; handler version number, ie 110 = v 1.10
                            ; old handlers will return the function # (11)

; shdw_location(x,y);       /* C calling sequence */
;===========================
; SHDW_LOCATION
;===========================
shdw_location:
    MOVE.W  10(A6), -(A7)   ; push y in character coordinates
    MOVE.W  8(A6), -(A7)    ; push x in character coordinates
                            ; or -1 for current location
                            ; x returned in D0, y returned in D1
    MOVE.W  #12, -(A7)      ; function number
    TRAP    #15             ; do it
    ADDQ.L  #6, -(A7)       ; fix up stack
    RTS

; shdw_set_values(length, buffer);  /* C calling sequence */
;===========================
; SHDW_SET_VALUES
;===========================
    MOVE.L  $bc, A0         ; get trap #15 vector
    SUBA.L  #22, A0         ; point to start of SHADOW rec
    MOVE.L  8(A6), 2(A0)    ; store length of transfer buffer
    MOVE.L  12(A6), 16(A0)  ; store pointer to transfer buffer
    RTS                     ; use this call to store info about transfer
                            ; buffer when in NON RESET PROOF mode

