#define SMTPTRACE			/* enable tracing for smtp */
#define SMTP_PORT	25		/* well-known port for smtp */
#define SMTPCLITIME	900		/* 15 minutes between client starts */
#define MAXSESSIONS	10		/* most connections allowed */
#define JOBNAME		13		/* max size of a job name with null */
#define	LINELEN		128
#define SLINELEN	32

extern char mailspool[];
extern char mailqdir[];		/* Outgoing spool directory */
extern char mailqueue[];	/* Prototype of work file */
extern char maillock[];		/* Mail system lock */
extern char baddir[];		/* Undeliverable jobs */
extern char hostname[];
extern int32 mailroute();
extern int mlock(),rmlock();

/* Recipient address entry */
struct addr {
	struct addr *next;
	char *val;
};

/* Per-session control block  used by smtp server */
struct mail {
	struct tcb *tcb;	/* TCP control block pointer */
	char state;
#define	COMMAND_STATE	0
#define	DATA_STATE	1
	char *system;		/* Name of remote system */
	char *from;		/* sender address */
	struct addr *to;	/* Linked list of recipients */
	char buf[LINELEN];	/* Input buffer */
	char cnt;		/* Length of input buffer */
	FILE *data;		/* Temporary input file pointer */
	int32 seqn;		/* message id */
};

/* used by smtpcli as a queue entry for a single message */
struct smtp_job {
	struct 	smtp_job *next;	/* pointer to next mail job for this system */
	char	jobname[9];	/* the prefix of the job file name */
	char	*from;		/* address of sender */
	char	*to;		/* address recipient  */
};

/* control structure used by an smtp client session */
struct smtp_cb {
	struct tcb *tcb;	/* tcp task control buffer */
	int32	ipaddr;		/* address of forwarding system */
	char	 state;		/* state machine placeholder */
#define CLI_OPEN_STATE	0
#define	CLI_HELO_STATE	1
#define CLI_MAIL_STATE	2
#define CLI_RCPT_STATE	3
#define CLI_DATA_STATE	4
#define	CLI_SEND_STATE	5
#define	CLI_UNLK_STATE	6
#define CLI_QUIT_STATE	7
#define CLI_IDLE	8
	char	*wname;		/* name of workfile */
	char	*tname;		/* name of data file */
	char	buf[LINELEN];	/* Input buffer */
	char	cnt;		/* Length of input buffer */
	FILE	*tfile;
	struct	smtp_job *jobq;
};

#define	NULLADDR	(struct addr *)0
#define	NULLMAIL	(struct mail *)0
#define	NULLCB		(struct smtp_cb *)0
#define NULLJOB		(struct smtp_job *)0
