#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "iface.h"
#include "trace.h"

extern FILE *stdprt;
extern int printtrace;		/* DG2KK: (see st.c kbread()) for details */

/* Redefined here so that programs calling dump in the library won't pull
 * in the rest of the package
 */
static char nospace[] = "No space!!\n";

dump(interface,direction,type,bp)
register struct interface *interface;
int direction;
unsigned type;
struct mbuf *bp;
{
	struct mbuf *tbp;
	void ascii_dump(),hex_dump();
	int ax25_dump(),ether_dump(),ip_dump(),at_dump(),slfp_dump();
	int (*func)();
	/* added (timestamp) */
	char *cp;
	long t;
	int16 size;

	if((interface->trace & direction) == 0)
		return;	/* Nothing to trace */

	if(bp == NULLBUF || (size = len_mbuf(bp)) == 0)
		return;

#ifdef SCREEN
	(void)outscreen(1);		/* DG2KK: switch to trace screen */
#endif
	time(&t);			/* DG2KK: get time */
	cp = ctime(&t);
	rip(cp);

	switch(direction){
	case IF_TRACE_IN:
		printf("%s recv: [%s]\n",interface->name,cp);
		if (printtrace != 0)
			fprintf(stdprt,"%s recv: [%s]\n",interface->name,cp);
		break;
	case IF_TRACE_OUT:
		printf("%s sent: [%s]\n",interface->name,cp);
		if (printtrace != 0)
			fprintf(stdprt,"%s sent: [%s]\n",interface->name,cp);
		break;
	}
	if(type < NTRACE)
		func = tracef[type];
	else
		func = NULLFP;

	dup_p(&tbp,bp,0,size);
	if(tbp == NULLBUF){
		printf(nospace);
		if (printtrace != 0) {
			fprintf(stdprt,nospace);
			fflush(stdprt);
		}
		fflush(stdout);
		return;
	}
	if(func != NULLFP)
		(*func)(&tbp,1);
	if(interface->trace & IF_TRACE_ASCII){
		/* Dump only data portion of packet in ascii */
		ascii_dump(&tbp);
	} else if(interface->trace & IF_TRACE_HEX){
		/* Dump entire packet in hex/ascii */
		free_p(tbp);
		dup_p(&tbp,bp,0,len_mbuf(bp));
		if(tbp != NULLBUF)
			hex_dump(&tbp);
		else
			printf(nospace);
	}
	free_p(tbp);
	printf("\n");			/* added */
	if (printtrace != 0)
		fprintf(stdprt,"\n");
	fflush(stdout);
	if (printtrace != 0)
		fflush(stdprt);

#ifdef SCREEN
	(void)outscreen(0);		/* switch back to main screen */
#endif
}

/* Dump an mbuf in hex */
void
hex_dump(bpp)
register struct mbuf **bpp;
{
	int16 n;
	int16 address;
	void fmtline();
	char buf[16];

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	address = 0;
	while((n = pullup(bpp,buf,16)) != 0){
		fmtline(address,buf,n);
		address += n;
	}
}
/* Dump an mbuf in ascii */
void
ascii_dump(bpp)
register struct mbuf **bpp;
{
	char c;
	register int16 tot;

	if(bpp == NULLBUFP || *bpp == NULLBUF)
		return;

	tot = 0;
	while(pullup(bpp,&c,1) == 1){
		if((tot % 64) == 0) {
			printf("%04x  ",tot);
			if (printtrace != 0) {
				fprintf(stdprt,"%04x  ",tot);
			}
		}
		if(isprint(c)) {
			putchar(c);
			if (printtrace != 0)
				putc(c,stdprt);
		} else {
			putchar('.');
			if (printtrace != 0)
				putc('.',stdprt);
		}
		tot++;
		if((tot % 64) == 0) {
			printf("\n");
			if (printtrace != 0) {
				fprintf(stdprt,"\n");
			}
		}
	}
	if((tot % 64) != 0) {
		printf("\n");
		if (printtrace != 0) {
			fprintf(stdprt,"\n");
		}
	}
}

/* Print a buffer up to 16 bytes long in formatted hex with ascii
 * translation, e.g.,
 * 0000: 30 31 32 33 34 35 36 37 38 39 3a 3b 3c 3d 3e 3f  0123456789:;<=>?
 */
void
fmtline(addr,buf,len)
int16 addr;
char *buf;
int16 len;
{
	char line[80];
	register char *aptr,*cptr;
	register int16 c;
	void ctohex();

	for(cptr = line;cptr < &line[80];cptr++)
		*cptr = ' ';
	ctohex(line,(int16)hibyte(addr));
	ctohex(line+2,(int16)lobyte(addr));
	aptr = &line[6];
	cptr = &line[55];
	while(len-- != 0){
		c = *buf++ & 0xff;
		ctohex(aptr,c);
		aptr += 3;
		c &= 0x7f;
		if(isprint(c)){
			*cptr++ = c;
		} else {
			*cptr++ = '.';
		}
	}
	*cptr++ = '\r';
	*cptr++ = '\n';
	fwrite(line,1,(unsigned)(cptr-line),stdout);
	/* added */
	if (printtrace == 1) {
		fwrite(line,1,(unsigned)(cptr-line),stdprt);
	}
}
/* Convert byte to two ascii-hex characters */
static
void
ctohex(buf,c)
register char *buf;
register int16 c;
{
	static char hex[] = "0123456789abcdef";

	buf[0] = hex[hinibble(c)];
	buf[1] = hex[lonibble(c)];
}

