/* System-dependent definitions of various files, spool directories, etc */

#if	(LATTICE || MAC || ATARI_ST)
/* These compilers require special open modes when reading binary files
 * 
 * "The single most brilliant design decision in all of UNIX was the
 * choice of a SINGLE character as the end-of-line indicator" -- M. O'Dell
 *
 * "Whoever picked the end-of-line conventions for MS-DOS and the Macintosh
 * should be shot!" -- P. Karn's corollary to O'Dells' declaration
 *
 * Index definitions for this array are in global.h
 */
char *binmode[] = {
	"rb",	/* Read binary */
	"wb",	/* Write binary */
	"ab"	/* Append binary */
};
#else
/* fopen modes for binary files under Aztec -- same as UNIX */
char *binmode[] = {
	"r",	/* Read */
	"w",	/* Write */
	"a"	/* Append */
};
#endif

/* don't move the Atari files def, there is a bug in the compiler that causes */
/* trouble with the "mailqueue" definition of other systems (comment sequence) */
/* the a: in filenames below is fixed at program startup - don't remove it! */
/* Well, I beg to differ. I like the following def's better. DG2KK */
#ifdef	ATARI_ST
char startup[]	 = "\\net.rc";			/* Initialization file */
char userfile[]  = "\\ftpusers"; 		/* Authorized FTP users and passwords */
char hosts[]	 = "\\hosts.net";		/* Network host table */
char mailspool[] = "\\spool\\inbound\\";	/* Incoming mail */
char mailqdir[]  = "\\spool\\outbound\\"; 	/* Outgoing mail spool */
char mailqueue[] = "\\spool\\outbound\\*.wrk";	/* Outgoing mail work files */
char baddir[]	 = "\\spool\\badjobs\\";	/* Undeliverable jobs */
char tmpdir[]	 = "\\tmp";			/* temp files directory */
char bm_rc[]	 = "\\bm.rc";			/* BM reconfiguration file */
#endif

#ifdef	MSDOS
char startup[] = "/autoexec.net";		/* Initialization file */
char userfile[] = "/ftpusers";			/* Authorized FTP users and passwords */
char hosts[] = "/hosts.net";			/* Network host table */
char mailspool[] = "/spool/mail/";		/* Incoming mail */
char mailqdir[] = "/spool/mqueue/";		/* Outgoing mail spool */
char mailqueue[] = "/spool/mqueue/*.wrk";	/* Outgoing mail work files */
char baddir[] = "/spool/badjobs/";		/* Undeliverable jobs */
char bm_rc[] = "/bm.rc";			/* BM reconfiguration file */
#endif

#ifdef	UNIX
char startup[] = "./startup.net";		/* Initialization file */
char config[] = "./config.net"; 		/* Device configuration list */
char userfile[] = "./ftpusers";
char hosts[] = "./hosts.net";
char mailspool[] = "/usr/spool/mail/";
char mailqdir[] = "/usr/spool/mqueue/";
char mailqueue[] = "/usr/spool/mqueue/*.wrk";	/* Outgoing mail work files */
char baddir[] = "/usr/spool/badjobs/";
#endif

#ifdef	AMIGA
char startup[] = "TCPIP:net.start";
char config[] = "TCPIP:config.net";		/* Device configuration list */
char userfile[] = "TCPIP:ftpusers";
char hosts[] = "TCPIP:hosts.net";
char mailspool[] = "TCPIP:spool/mail/";
char mailqdir[] = "TCPIP:spool/mqueue/";
char mailqueue[] = "TCPIP:spool/mqueue/*.wrk";	/* Outgoing mail work files */
char baddir[] = "TCPIP:spool/badjobs/";
#endif

#ifdef	MAC
char startup[] ="Mikes Hard Disk:net.start";
char config[] = "Mikes Hard Disk:config.net";	/* Device configuration list */
char userfile[] = "Mikes Hard Disk:ftpusers";
char hosts[] = "Mikes Hard Disk:hosts.net";
char mailspool[] = "Mikes Hard Disk:spool:mail:";
char mailqdir[] = "Mikes Hard Disk:spool:mqueue:";
char mailqueue[] = "Mikes Hard Disk:spool:mqueue:*.wrk"; /* Outgoing mail work files */
char baddir[] = "Mikes Hard Disk:spool:badjobs:";
#endif

