/* Test Library Implementation */

#include "libs.h"
#define XLIB_IMPLEMENTATION
#include "xlib.h"
#include <debug.h>


/*===== Library Entry Points =====*/


void XLibP0 () { DEBUG(("in XLibP0\n")); }
void XLibP1 () { DEBUG(("in XLibP1\n")); }
void XLibP2 () { DEBUG(("in XLibP2\n")); }


/*===== Overhead =====*/


/* array of entry points for this library */

Procedure XLibBase[] = {
  XLibP0,
  XLibP1,
  XLibP2
};


/*
	This routine is called by FindLibrary when a program wants
	to use the library.  If the version number given by the caller
	is not acceptable we will return NULL.  If we wanted to support
	more than one version with the same library, we could choose to
	return a different library base pointer for some versions. 
*/

Library
Entrance (version)
  int version;
{
  DEBUG(("XLib Entrance with version %d\n",version)); 
  if (version==XLIB_VERSION)
    return XLibBase;
  return 0L;
}


/* The link for this library */

LibLink XLib = {
  0L,
  XLIB_NAME,
  XLIB_VERSION,
  Entrance
};


/* initialization code for library */

int
main ()
{
  /* install this library */
  return InstallLibrary(&XLib,0L);
}
