/* 
	Definitions for shared library support 
	written November, 1987
	by Preston L. Bannister
*/

#define LIBSUPPORT_NAME		"LibSupport"
#define LIBSUPPORT_VERSION	1

#define LIB_FIND_VECTOR	0x200
#define LIB_ADD_VECTOR	0x201

typedef long (*Procedure)();
typedef Procedure * Library;
typedef Library (*GetLibraryFunction)();

typedef struct _LibLink {
  struct _LibLink *next;
  char *name;
  int version;
  GetLibraryFunction entrance;
} LibLink;

extern Library LibSupportBase;

extern void InstallLibrary(/*lib,keep*/);
extern int  InitLibSupport();

#ifndef LIBSUPPORT_IMPLEMENTATION

#define AddLibrary	(*LibSupportBase[0])
#define FindLibrary	(*LibSupportBase[1])
#define ForEachLibrary	(*LibSupportBase[2])

#endif
