/*
	Shared library support.
	written October, 1987
	by Preston L. Bannister
*/

#include <osbind.h>
#include <bios.h>
#include <basepage.h>
#include <debug.h>
#define LIBSUPPORT_IMPLEMENTATION
#include "libs.h"

LibLink *Libraries;


/*===== entry points =====*/


/*
	Add a new library to the list of installed libraries.
*/

void
AddLibrary (lib)
  LibLink *lib;		/* IN a new library link */
{
  ENTER(AddLibrary);
  lib->next = Libraries;
  Libraries = lib;
  LEAVE(AddLibrary);
}


/*
	Find an installed library to match the given name and version.
	Returns a NULL pointer if the library was not found or if the
	entrance routine of the library itself decided it was not 
	compatible with the given version.
*/

Library
FindLibrary (name,version)
  char *name;		/* IN name of the library to find */
  int version;		/* IN version number of library */
{
  LibLink *p = Libraries;
  ENTER(FindLibrary);
  DEBUG(("Looking for '%s'\n",name));
  for (p=Libraries; p; p=p->next)
  {
    DEBUG(("Examining '%s'\n",p->name));
    if (strcmp(name,p->name)==0)
    {
      LEAVE(FindLibrary:FoundIt);
      return ((*p->entrance)(version));
    }
  }
  LEAVE(FindLibrary:NotFound);
  return 0L;
}


/*
	For each installed library, call the given procedure with a pointer 
	to the given data and a pointer to the library link structure.
*/

void
ForEachLibrary (proc,data)
  int (*proc)();
  int *data;
{
  LibLink *p = Libraries;
  ENTER(ForEachLibrary);
  for (p=Libraries; p; p=p->next)
  {
    if ((*proc)(data,p))
      break;
  }
  LEAVE(ForEachLibrary);
}


/*===== =====*/


Procedure LibSupportBase[] = {
  AddLibrary,
  FindLibrary,
  ForEachLibrary
};


/* Called when client finds this library */

Library
Entrance (version)
  int version;
{
  DEBUG(("In LibSupport Entrance\n"));
  switch (version)
  {
    case LIBSUPPORT_VERSION:
      return LibSupportBase;
  }
  return 0L;
}


LibLink LibSupport = {
  0L,
  LIBSUPPORT_NAME,
  LIBSUPPORT_VERSION,
  Entrance
};


main ()
{
  extern int end[];

  DEBUG(("\nInstalling LibSupport\n"));
  Libraries = &LibSupport;
  Setexc(LIB_FIND_VECTOR,FindLibrary);
  DEBUG(("LibSupport vector 0x%04x set to 0x%08X FindLibrary\n",
          LIB_FIND_VECTOR,FindLibrary));
  Setexc(LIB_ADD_VECTOR,AddLibrary);
  DEBUG(("LibSupport vector 0x%04x set to 0x%08X AddLibrary\n",
          LIB_ADD_VECTOR,AddLibrary));
  Ptermres((long)end-(long)BP,0);
  DEBUG(("LibSupport installation failed!\n"));
  return 1;
}
