/*
 * PD mini VDI interface, Eric Gisin
 */

#include <osbind.h>
#include <vdi.h>
#include <gfont.h>

#define	NULL	0L

static	short ct [12];		/* VDI/AES control block */
static	short ii [140];
static	short pi [16];
static	short io [47];
static	short po [16];
struct Params v_ps = {ct, ii, pi, io, po, NULL};
struct Params v_pt = {ct, ii, pi, io, po, NULL}; /* modifiable version of v_ps */

/* VDI operations with no parameters */
vdi_none(h, op)
	short h, op;
{
	vdi_setup(op, h, 0, 0);
	vdi(&v_ps);
}

/* VDI operations with one integer parameter */
vdi_int1(h, op, i)
	short h, op;
	short i;
{
	ii[0] = i;
	vdi_setup(op, h, 1, 0);
	vdi(&v_ps);
	return io[0];
}

/* VDI operations with one point parameter */
vdi_pnt1(h, op, x, y)
	short h, op;
	short x, y;
{
	pi[0] = x, pi[1] = y;
	vdi_setup(op, h, 0, 1);
	vdi(&v_ps);
}

vdi_pnt4v(h, op, fn, pnt)
	short h;
	short op, fn;
	short *pnt;
{
	register int i;

	for (i = 0; i < 4; i++)
		pi[i] = pnt[i];
	vdi_setup(op, h, 0, 2);
	ct[5] = fn;
	vdi(&v_ps);
}

/* open virtual work */
v_opnvwk(in, hp, out) /* todo: vdi_open */
	short in[];
	short *hp;
	short out[];
{
	v_pt.ii = in;
	v_pt.io = out;
	v_pt.pi = pi;
	v_pt.po = out+34;
	vdi_setup(100, *hp, 11, 0);
	vdi(&v_pt);
	*hp = ct[6];
}

vdi_cpyfm(h, op, mode, sdr, src, dst)
	short h, op;
	short mode;
	short *sdr;			/* source/dest rectangles */
	Form *src, *dst;		/* source/dest forms */
{
	register int i;

	*((Form**)&ct[7]) = src;
	*((Form**)&ct[9]) = dst;
	ii[0] = mode;
	for (i = 0; i < 8; i++)
		pi[i] = sdr[i];
/***
	*((Rect*)&pi[0]) = sdr[0];
	*((Rect*)&pi[4]) = sdr[1];
***/
	vdi_setup(op, h, 1, 4); vdi(&v_ps);
}

vst_alignment(h, x, y, xp, yp) 
	short h;
	short x, y;
	short *xp, *yp;
{
	ii[0] = x, ii[1] = y;
	vdi_setup(39, h, 2, 0);
	vdi(&v_ps);
	*xp = io[0], *yp = io[1];
}

v_gtext(h, x, y, s)
	short h;
	short x, y;
	unsigned char *s;
{
	register int i;

	for (i = 0; *s != 0 && i < 140; i++)
		ii[i] = *s++;
	pi[0] = x; pi[1] = y;
	vdi_setup(8, h, i, 1);
	vdi(&v_ps);
}

vqt_attributes(h, at)
	short *at;	/*struct vdi_tattr *at;*/
{
	v_pt.io = at; v_pt.po = at+6;
	vdi_setup(38, h, 0, 0);
	vdi(&v_pt);
}

static char *vdi_scratch = NULL;	/* VDI/LineA scratch buffer */

#if 0
/* load GDOS fonts using user's vx_load_fonts */
vst_load_fonts(h, select)
	short h, select;
{
	GFont * fp;
	extern char * malloc();
	extern GFont * vx_load_fonts();	/* user routine to load fonts */

	if (vdi_scratch == NULL)
		vdi_scratch = malloc(1024);	/* scratch buffer */
	*((char **)&ct[7]) = vdi_scratch;
	ct[9] = 256;			/* offset of enlargment buffer */
	*((char **)&ct[10]) = fp = vx_load_fonts(select); /* GDOS font list */
	if (fp == 0)
		return 0;
	vdi_setup(119, h, 0, 0);
	vdi(&v_ps);
	return io[0];			/* number of fonts loaded */
}

vst_unload_fonts(h)
{
	extern void vx_unload_fonts();

	vdi_setup(120, h, 0, 0);
	vdi(&v_ps);
	vx_unload_fonts();
}
#endif

/* load GDOS fonts using fp */
/* make sure your ct array is large enough if you port this */
vstx_load_fonts(h, fp)
	short h;
	GFont *fp;
{
	extern char * malloc();

	if (vdi_scratch == NULL)
		vdi_scratch = malloc(1024);	/* scratch buffer */
	*((char **)&ct[7]) = vdi_scratch;
	ct[9] = 256;			/* offset of enlargment buffer */
	*((char **)&ct[10]) = fp;
	if (fp == NULL)
		return 0;
	vdi_setup(119, h, 0, 0);
	vdi(&v_ps);
	return io[0];			/* number of fonts loaded */
}

vstx_unload_fonts(h)
{
	vdi_setup(120, h, 0, 0);
	vdi(&v_ps);
}

#if 0
/*
 * This code invokes VDI ESC 102 code (page 440 in the July '86
 * Abacus ST Internals BIOS listing).  I decompiled some library
 * routines to see how to make it work.  It may not work on new ROMS.
 * Martin Minow, Arlington MA 02174.  This routine is in the public domain.
 */
vt_set_font(fp)
	register GFont * fp;
{
	(*(GFont**)&ii[0]) = fp;	/* Put font info in intin[0] */
	vdi_setup(5, 0, 2, 0);
	ct[5] = 102;
	vdi(&v_ps);
}
#endif

