/*
 * Sample program to load fonts, display them. Eric Gisin.
 * try: vdit -f91 fixed8 fixed9 fixed10 fixed11 fixed12
 *
 *	void vstx_load_fonts(short vdi_handle, GFont *fonts);
 *	void vstx_unload_fonts(short vdi_handle);
 *
 * These two undocumented VDI functions are used to add fonts
 * to a virtual screen. Unlike the VDI function vst_load_fonts,
 * which requires GDOS, it does not load the fonts from disk.
 * Instead you load them explicitly with load_fonts (or load_font),
 * and pass the linked list of fonts to vstx_load_fonts as "fonts".
 * To change the fonts in a virtual screen, unload then load again.
 *
 * The fonts must have valid font_id and size information.
 * The font_id is used by vst_font to select a font family.
 */

#include <vdi.h>
#include <gfont.h>

#define	NULL	0L

extern	GFont *load_fonts();

main(argc, argv)
	char ** argv;
{
	register int i;
	int font = 1, size = 10;
	short h = 1;
	short in [11];
	short out [57];

	/* parse options */
	for (i = 1; i < argc; i ++) {
		register char * arg = argv[i];
		if (arg[0]=='-') {
		    if (arg[1]=='f')
			font = atoi(&arg[2]);
		    if (arg[1]=='p')
			size = atoi(&arg[2]);
		} else
			break;
	}
		
	/* set up opnvwk parameters */
	in[0] = 1;			/* device is screen */
	in[1] = in[2] = 1;		/* line type/color */
	in[3] = in[4] = 1;		/* marker type/color */
	in[5] = in[6] = 1;		/* text font/color */
	in[7] = in[8] = in[9] = 1;	/* fill type/style/color */
	in[10] = 2;			/* raster coordinates */

	v_opnvwk(in, &h, out);
	vstx_load_fonts(h, load_fonts(&argv[i]));
	v_clrwk(h);
	i = vst_font(h, font);
	for (i = 6; i < 25; i += (i<14) ? 1 : 2) {
		vst_point(h, i);
		v_gtext(h, 0, i*16, "A test of load_fonts ?! {123<@>}");
	}
	vstx_unload_fonts(h);
	v_clsvwk(h);
	return 0;
}

