/*
 * Internal representation of GDOS font. Author unknown.
 */

typedef struct {
	short	font_id;	/* Font face identifier, 1 -> system font */
	short	size;		/* Font size in points */
	char	name[32];	/* Font name */
	short	first_ade;	/* Lowest ADE value in the face */
	short	last_ade;	/* Highest ADE value in the face */
	short	top;		/* Distance of top line relative to baseline */
	short	ascent;		/* Distance of ascent line relative to baseline */
	short	half;		/* Distance of half line relative to baseline */
	short	descent;	/* Distance of decent line relative to baseline */
	short	bottom;		/* Distance of bottom line relative to baseline */
				/* All distances are measured in absolute values */
				/* rather than as offsets. They are always +ve */
	short	max_char_width;	/* Width of the widest character in font */
	short	max_cell_width;	/* Width of the widest cell character cell in face */
	short	loffset;	/* Left Offset see Vdi appendix G */
	short	roffset;	/* Right offset   "      "     " */
	short	thicken;	/* Number of pixels by which to thicken characters */
	short	ul_size;	/* Width in pixels of the underline */
	short	lighten;	/* The mask used to lighten characters */
	short	skew;		/* The mask used to determine when to perform */
			/* additional rotation on the character to perform skewing */
	short	flags;		/* Flags */
				/*  $01 default system font */
				/*   02 horiz offset table should be used */
				/*   04 byte-swap flag (thanks to Motorla idiots) */
				/*   08 mono spaced font */
	short *	hoff_base;	/* Offset to horizontal offset table */
	short *	coff_base;	/* Offset to character offset table */
		/* font bitmap is byte[width][height], width must be even */
	short *	form_base;	/* Offset to font data */
	short	form_width;	/* Form width (#of bytes/scanline in font data) */
	short	form_height;	/* Form height (#of scanlines in font data) */
	char *	next_font;	/* Pointer to next font in face */
} GFont;

