/*
 * PD mini VDI interface, Eric Gisin
 */

/* Memory Form descriptor */
typedef struct {
	short *	base;
	short	width;
	short	height;
	short	wwidth;
	short	standard;
	short	planes;
	short	resv1, resv2, resv3;
} Form;

/* Rectangle descriptor */
typedef struct {
	short	x1, y1;		/* upper left */
	short	x2, y2;		/* lower right */
} Rect;

/* VDI/AES parameter block */
struct Params {
	short  *ct;			/* control */
	short  *ii;			/* ints in */
	short  *pi;			/* points in */
	short  *io;			/* ints out */
	short  *po;			/* points out */
	short  *xx;
};

#define	vdi(params)		bdos(115, params)
#define	vdi_setup(f, h, ii, pi) {ct[0] = f; ct[6] = h; ct[1] = pi; ct[3] = ii; }

#define	v_clsvwk(h)		vdi_none(h, 101)
#define	v_clrwk(h)		vdi_none(h, 3)
#define	vro_cpyfm(h, m, r, s, d) vdi_cpyfm(h, 109, m, r, s, d)
#define	vrt_cpyfm(h, m, r, s, d) vdi_cpyfm(h, 121, m, r, s, d)
#define	vsf_color(h, c)		vdi_int1(h, 25, c)
#define	vsf_perimeter(h, f)	vdi_int1(h, 104, f)
#define	vsf_interior(h, s)	vdi_int1(h, 23, s)
#define	vsf_style(h, s)		vdi_int1(h, 24, s)
#define	vst_color(h, c)		vdi_int1(h, 22, c)
#define	vst_effects(h, e)	vdi_int1(h, 106, e)
#define	vst_point(h, s)		vdi_int1(h, 107, s)
#define	vst_rotation(h, a)	vdi_int1(h, 13, a)
#define	vst_font(h, f)		vdi_int1(h, 21, f)
#define	vswr_mode(h, m)		vdi_int1(h, 32, m)
#define	vst_height(h, ht)	vdi_pnt1(h, 12, 0, ht)
#define	v_bar(h, p)		vdi_pnt4v(h, 11, 1, p)
#define	v_rbox(h, p)		vdi_pnt4v(h, 11, 8, p)
#define	v_rfbox(h, p)		vdi_pnt4v(h, 11, 9, p)
#define	v_recfl(h, p)		vdi_pnt4v(h, 114, 0, p)

