/*
 * Load GDOS font, Eric Gisin.
 * loads a font from file name.FED. Tries in ., then $FONTDIR, then A:\FONT.
 * does not have enough error checking.
 */

#define	NULL	0L
#include <gfont.h>

#define	open(file, mode)	gemdos(0x3D, file,mode)
#define close(fd)		gemdos(0x3E, fd)
#define	read(fd, buf, size)	gemdos(0x3F, fd,(long)size,buf)

#define	Swapw(v)	(v) = ((v)<<8) | ((v)>>8)&0x00FF
#define	Swapl(v)	(v) = ((v)>>24)&0x000000FF | ((v)>>8)&0x0000FF00

char * font_dir = NULL;
extern char * malloc();
extern char * getenv();

/*
 * load GDOS font, return pointer to font.
 */
GFont *
load_font(name)
	char *	name;
{
	int fd, i, n, size;
	char temp [64], * p = temp;
	char * q, * tcwd;
	int swapf;
	register GFont*	fp;

	if (font_dir == NULL)
		font_dir = getenv("FONTDIR");
	if (font_dir == NULL)
		font_dir = "A:\\font";

	fp = malloc(sizeof(GFont));
	if (fp == NULL) return NULL;

	/* set up font file's path name */
	for (q = font_dir; *q; )
		*p++ = *q++;
	*p++ = '\\';
	tcwd = p;
	for (q = name; *q; )
		*p++ = *q++;
	for (q = ".fed"; *q; )
		*p++ = *q++;
	*p = '\0';

	/* open font file */
	fd = open(tcwd, 0);		/* try name.fed */
	if (fd < 0)
		fd = open(temp, 0);
	if (fd < 0)
		return (0);

	/* read header */
	size = sizeof(GFont);
	read(fd, fp, size);		/* should (char *)fp */

	swapf = !(fp->flags&0x0004);
	if (swapf) {
		/* swap header words and longs */
		Swapw(fp->font_id);		Swapw(fp->size);
		Swapw(fp->first_ade);		Swapw(fp->last_ade);
		Swapw(fp->top);			Swapw(fp->ascent);
		Swapw(fp->half);		Swapw(fp->descent);
		Swapw(fp->bottom);
		Swapw(fp->max_char_width);	Swapw(fp->max_cell_width);
		Swapw(fp->loffset);		Swapw(fp->roffset);
		Swapw(fp->thicken);		Swapw(fp->ul_size);
		/* Swapw(fp->flags); */		Swapl(fp->hoff_base);
		Swapl(fp->coff_base);		Swapl(fp->form_base);
		Swapw(fp->form_width);		Swapw(fp->form_height);
	}

	/* read offset table */
	n = fp->last_ade + 1 - fp->first_ade + 1;
	size = n * sizeof(short);
	fp->coff_base = malloc(size);
	if (fp->coff_base == NULL) return NULL;
#if 0
	for (i = 0; i < fp->first_ade; i++)
		fp->coff_base[i] = 0;
#endif
	read(fd, fp->coff_base, size);
	if (swapf)		/* swap offset array words */
		for (i = 0; i < n; i++)
			Swapw(fp->coff_base[i]);

	/* read bitmap */
	size = fp->form_width*fp->form_height;
	fp->form_base = malloc(size);
	if (fp->form_base == NULL) return NULL;
	read(fd, fp->form_base, size);

	close(fd);
	return fp;
}

/* load a set of fonts, linking them for vst_load_font */
GFont *
load_fonts(fontv)
	char **fontv;
{
	int errors = 0;			/* should return */
	GFont * fhead = NULL;
	GFont * f, ** fpp = &fhead;

	/* load fonts, create linked list fhead */
	while (*fontv != NULL) {
		*fpp = f = load_font(*fontv++);
		if (f != NULL)
			fpp = &f->next_font;
		else
			errors++;
	}
	return fhead;
}


