





TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







NAME

     termcap - terminal capability data base



SYNOPSIS

     /etc/termcap



DESCRIPTION

     _T_e_r_m_c_a_p is a data base describing terminals, used, _e._g., by

     _v_i(1) and _c_u_r_s_e_s(3X).  Terminals are described in _t_e_r_m_c_a_p by

     giving a set of capabilities that they have and by describ-

     ing how operations are performed.	Padding requirements and

     initialization sequences are included in _t_e_r_m_c_a_p.



     Entries in _t_e_r_m_c_a_p consist of a number of `:'-separated

     fields.  The first entry for each terminal gives the names

     that are known for the terminal, separated by `|' charac-

     ters.  The first name is always two characters long and is

     used by older systems which store the terminal type in a

     16-bit word in a system-wide data base.  The second name

     given is the most common abbreviation for the terminal, the

     last name given should be a long name fully identifying the

     terminal, and all others are understood as synonyms for the

     terminal name.  All names but the first and last should be

     in lower case and contain no blanks; the last name may well

     contain upper case and blanks for readability.



     Terminal names (except for the last, verbose entry) should

     be chosen using the following conventions.  The particular

     piece of hardware making up the terminal should have a root

     name chosen, thus "hp2621".  This name should not contain

     hyphens.  Modes that the hardware can be in or user prefer-

     ences should be indicated by appending a hyphen and an indi-

     cator of the mode.  Therefore, a "vt100" in 132-column mode

     would be "vt100-w".  The following suffixes should be used

     where possible:



     Suffix   Meaning					Example

     -w       Wide mode (more than 80 columns)		vt100-w

     -am      With automatic margins (usually default)	vt100-am

     -nam     Without automatic margins                 vt100-nam

     -_n       Number of lines on the screen		aaa-60

     -na      No arrow keys (leave them in local)	concept100-na

     -_np      Number of pages of memory                 concept100-4p

     -rv      Reverse video				concept100-rv



CAPABILITIES

     The characters in the _N_o_t_e_s field in the table have the fol-

     lowing meanings (more than one may apply to a capability):



     N	 indicates numeric parameter(s)

     P	 indicates that padding may be specified

     *	 indicates that padding may be based on the number of lines affected







Printed 8/14/86          1 November 1985			1













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     o	 indicates capability is obsolete



     "Obsolete" capabilities have no _t_e_r_m_i_n_f_o equivalents, since

     they were considered useless, or are subsumed by other capa-

     bilities.	New software should not rely on them at all.



     Name  Type  Notes	Description

     ae    str	 (P)	End alternate character set

     AL    str	 (NP*)	Add _n new blank lines

     al    str	 (P*)	Add new blank line

     am    bool         Terminal has automatic margins

     as    str	 (P)	Start alternate character set

     bc    str	 (o)	Backspace if not ^H

     bl    str	 (P)	Audible signal (bell)

     bs    bool  (o)	Terminal can backspace with ^H

     bt    str	 (P)	Back tab

     bw    bool         le (backspace) wraps from column 0 to last column

     CC    str		Terminal settable command character in prototype

     cd    str	 (P*)	Clear to end of display

     ce    str	 (P)	Clear to end of line

     ch    str	 (NP)	Set cursor column (horizontal position)

     cl    str	 (P*)	Clear screen and home cursor

     CM    str	 (NP)	Memory-relative cursor addressing

     cm    str	 (NP)	Screen-relative cursor motion

     co    num		Number of columns in a line (See BUGS section below)

     cr    str	 (P)	Carriage return

     cs    str	 (NP)	Change scrolling region (VT100)

     ct    str	 (P)	Clear all tab stops

     cv    str	 (NP)	Set cursor row (vertical position)

     da    bool         Display may be retained above the screen

     dB    num	 (o)	Milliseconds of bs delay needed (default 0)

     db    bool         Display may be retained below the screen

     DC    str	 (NP*)	Delete _n characters

     dC    num	 (o)	Milliseconds of cr delay needed (default 0)

     dc    str	 (P*)	Delete character

     dF    num	 (o)	Milliseconds of ff delay needed (default 0)

     DL    str	 (NP*)	Delete _n lines

     dl    str	 (P*)	Delete line

     dm    str		Enter delete mode

     dN    num	 (o)	Milliseconds of nl delay needed (default 0)

     DO    str	 (NP*)	Move cursor down _n lines

     do    str		Down one line

     ds    str		Disable status line

     dT    num	 (o)	Milliseconds of horizontal tab delay needed (default 0)

     dV    num	 (o)	Milliseconds of vertical tab delay needed (default 0)

     ec    str	 (NP)	Erase _n characters

     ed    str		End delete mode

     ei    str		End insert mode

     eo    bool         Can erase overstrikes with a blank

     EP    bool  (o)	Even parity

     es    bool         Escape can be used on the status line

     ff    str	 (P*)	Hardcopy terminal page eject







Printed 8/14/86          1 November 1985			2













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     fs    str		Return from status line

     gn    bool         Generic line type (_e._g. dialup, switch)

     hc    bool         Hardcopy terminal

     HD    bool  (o)	Half-duplex

     hd    str		Half-line down (forward 1/2 linefeed)

     ho    str	 (P)	Home cursor

     hs    bool         Has extra "status line"

     hu    str		Half-line up (reverse 1/2 linefeed)

     hz    bool         Cannot print ~s (Hazeltine)

     i1-i3 str		Terminal initialization strings (_t_e_r_m_i_n_f_o only)

     IC    str	 (NP*)	Insert _n blank characters

     ic    str	 (P*)	Insert character

     if    str		Name of file containing initialization string

     im    str		Enter insert mode

     in    bool         Insert mode distinguishes nulls

     iP    str		Pathname of program for initialization (_t_e_r_m_i_n_f_o only)

     ip    str	 (P*)	Insert pad after character inserted

     is    str		Terminal initialization string (_t_e_r_m_c_a_p only)

     it    num		Tabs initially every _n positions

     K1    str		Sent by keypad upper left

     K2    str		Sent by keypad upper right

     K3    str		Sent by keypad center

     K4    str		Sent by keypad lower left

     K5    str		Sent by keypad lower right

     k0-k9 str		Sent by function keys 0-9

     kA    str		Sent by insert-line key

     ka    str		Sent by clear-all-tabs key

     kb    str		Sent by backspace key

     kC    str		Sent by clear-screen or erase key

     kD    str		Sent by delete-character key

     kd    str		Sent by down-arrow key

     kE    str		Sent by clear-to-end-of-line key

     ke    str		Out of "keypad transmit" mode

     kF    str		Sent by scroll-forward/down key

     kH    str		Sent by home-down key

     kh    str		Sent by home key

     kI    str		Sent by insert-character or enter-insert-mode key

     kL    str		Sent by delete-line key

     kl    str		Sent by left-arrow key

     kM    str		Sent by insert key while in insert mode

     km    bool         Has a "meta" key (shift, sets parity bit)

     kN    str		Sent by next-page key

     kn    num	 (o)	Number of function (k0-k9) keys (default 0)

     ko    str	 (o)	Termcap entries for other non-function keys

     kP    str		Sent by previous-page key

     kR    str		Sent by scroll-backward/up key

     kr    str		Sent by right-arrow key

     kS    str		Sent by clear-to-end-of-screen key

     ks    str		Put terminal in "keypad transmit" mode

     kT    str		Sent by set-tab key

     kt    str		Sent by clear-tab key

     ku    str		Sent by up-arrow key







Printed 8/14/86          1 November 1985			3













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     l0-l9 str		Labels on function keys if not "f_n"

     LC    bool  (o)	Lower-case only

     LE    str	 (NP)	Move cursor left _n positions

     le    str	 (P)	Move cursor left one position

     li    num		Number of lines on screen or page (See BUGS section below)

     ll    str		Last line, first column

     lm    num		Lines of memory if > li (0 means varies)

     ma    str	 (o)	Arrow key map (used by _v_i version 2 only)

     mb    str		Turn on blinking attribute

     md    str		Turn on bold (extra bright) attribute

     me    str		Turn off all attributes

     mh    str		Turn on half-bright attribute

     mi    bool         Safe to move while in insert mode

     mk    str		Turn on blank attribute (characters invisible)

     ml    str	 (o)	Memory lock on above cursor

     mm    str		Turn on "meta mode" (8th bit)

     mo    str		Turn off "meta mode"

     mp    str		Turn on protected attribute

     mr    str		Turn on reverse-video attibute

     ms    bool         Safe to move in standout modes

     mu    str	 (o)	Memory unlock (turn off memory lock)

     nc    bool  (o)	No correctly-working cr (Datamedia 2500, Hazeltine 2000)

     nd    str		Non-destructive space (cursor right)

     NL    bool  (o)	\n is newline, not line feed

     nl    str	 (o)	Newline character if not \n

     ns    bool  (o)	Terminal is a CRT but doesn't scroll

     nw    str	 (P)	Newline (behaves like cr followed by do)

     OP    bool  (o)	Odd parity

     os    bool         Terminal overstrikes

     pb    num		Lowest baud where delays are required

     pc    str		Pad character (default NUL)

     pf    str		Turn off the printer

     pk    str		Program function key _n to type string _s (_t_e_r_m_i_n_f_o only)

     pl    str		Program function key _n to execute string _s (_t_e_r_m_i_n_f_o only)

     pO    str	 (N)	Turn on the printer for _n bytes

     po    str		Turn on the printer

     ps    str		Print contents of the screen

     pt    bool  (o)	Has hardware tabs (may need to be set with is)

     px    str		Program function key _n to transmit string _s (_t_e_r_m_i_n_f_o only)

     r1-r3 str		Reset terminal completely to sane modes (_t_e_r_m_i_n_f_o only)

     rc    str	 (P)	Restore cursor to position of last sc

     rf    str		Name of file containing reset codes

     RI    str	 (NP)	Move cursor right _n positions

     rp    str	 (NP*)	Repeat character _c _n times

     rs    str		Reset terminal completely to sane modes (_t_e_r_m_c_a_p only)

     sa    str	 (NP)	Define the video attributes

     sc    str	 (P)	Save cursor position

     se    str		End standout mode

     SF    str	 (NP*)	Scroll forward _n lines

     sf    str	 (P)	Scroll text up

     sg    num		Number of garbage chars left by so or se (default 0)

     so    str		Begin standout mode







Printed 8/14/86          1 November 1985			4













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     SR    str	 (NP*)	Scroll backward _n lines

     sr    str	 (P)	Scroll text down

     st    str		Set a tab in all rows, current column

     ta    str	 (P)	Tab to next 8-position hardware tab stop

     tc    str		Entry of similar terminal - must be last

     te    str		String to end programs that use _t_e_r_m_c_a_p

     ti    str		String to begin programs that use _t_e_r_m_c_a_p

     ts    str	 (N)	Go to status line, column _n

     UC    bool  (o)	Upper-case only

     uc    str		Underscore one character and move past it

     ue    str		End underscore mode

     ug    num		Number of garbage chars left by us or ue (default 0)

     ul    bool         Underline character overstrikes

     UP    str	 (NP*)	Move cursor up _n lines

     up    str		Upline (cursor up)

     us    str		Start underscore mode

     vb    str		Visible bell (must not move cursor)

     ve    str		Make cursor appear normal (undo vs/vi)

     vi    str		Make cursor invisible

     vs    str		Make cursor very visible

     vt    num		Virtual terminal number (not supported on all systems)

     wi    str	 (N)	Set current window

     ws    num		Number of columns in status line

     xb    bool         Beehive (f1=ESC, f2=^C)

     xn    bool         Newline ignored after 80 cols (Concept)

     xo    bool         Terminal uses xoff/xon (DC3/DC1) handshaking

     xr    bool  (o)	Return acts like ce cr nl (Delta Data)

     xs    bool         Standout not erased by overwriting (Hewlett-Packard)

     xt    bool         Tabs ruin, magic so char (Teleray 1061)

     xx    bool  (o)	Tektronix 4025 insert-line



     A Sample Entry



     The following entry, which describes the Concept-100, is

     among the more complex entries in the _t_e_r_m_c_a_p file as of

     this writing.



     ca|concept100|c100|concept|c104|concept100-4p|HDS Concept-100:\

	     :al=3*\E^R:am:bl=^G:cd=16*\E^C:ce=16\E^U:cl=2*^L:cm=\Ea%+ %+ :\

	     :co#80:.cr=9^M:db:dc=16\E^A:dl=3*\E^B:do=^J:ei=\E\200:eo:im=\E^P:in:\

	     :ip=16*:is=\EU\Ef\E7\E5\E8\El\ENH\EK\E\200\Eo&\200\Eo\47\E:k1=\E5:\

	     :k2=\E6:k3=\E7:kb=^h:kd=\E<:ke=\Ex:kh=\E?:kl=\E>:kr=\E=:ks=\EX:\

	     :ku=\E;:le=^H:li#24:mb=\EC:me=\EN\200:mh=\EE:mi:mk=\EH:mp=\EI:\

	     :mr=\ED:nd=\E=:pb#9600:rp=0.2*\Er%.%+ :se=\Ed\Ee:sf=^J:so=\EE\ED:\

	     :.ta=8\t:te=\Ev	\200\200\200\200\200\200\Ep\r\n:\

	     :ti=\EU\Ev  8p\Ep\r:ue=\Eg:ul:up=\E;:us=\EG:\

	     :vb=\Ek\200\200\200\200\200\200\200\200\200\200\200\200\200\200\EK:\

	     :ve=\Ew:vs=\EW:vt#8:xn:\

	     :bs:cr=^M:dC#9:dT#8:nl=^J:ta=^I:pt:



     Entries may continue onto multiple lines by giving a \ as

     the last character of a line, and empty fields may be







Printed 8/14/86          1 November 1985			5













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     included for readability (here between the last field on a

     line and the first field on the next).  Comments may be

     included on lines beginning with "#".



     Types of Capabilities



     Capabilities in _t_e_r_m_c_a_p are of three types: Boolean capabil-

     ities, which indicate particular features that the terminal

     has; numeric capabilities, giving the size of the display or

     the size of other attributes; and string capabilities, which

     give character sequences that can be used to perform partic-

     ular terminal operations.	All capabilities have two-letter

     codes.  For instance, the fact that the Concept has

     _a_u_t_o_m_a_t_i_c _m_a_r_g_i_n_s (_i._e., an automatic return and linefeed

     when the end of a line is reached) is indicated by the

     Boolean capability am.  Hence the description of the Concept

     includes am.



     Numeric capabilities are followed by the character `#' then

     the value.  In the example above co, which indicates the

     number of columns the display has, gives the value `80' for

     the Concept.



     Finally, string-valued capabilities, such as ce (clear-to-

     end-of-line sequence) are given by the two-letter code, an

     `=', then a string ending at the next following `:'.  A

     delay in milliseconds may appear after the `=' in such a

     capability, which causes padding characters to be supplied

     by _t_p_u_t_s after the remainder of the string is sent to pro-

     vide this delay.  The delay can be either a number, _e._g.

     `20', or a number followed by an `*', _i._e., `3*'.	An `*'

     indicates that the padding required is proportional to the

     number of lines affected by the operation, and the amount

     given is the per-affected-line padding required.  (In the

     case of insert-character, the factor is still the number of

     _l_i_n_e_s affected; this is always 1 unless the terminal has in

     and the software uses it.) When an `*' is specified, it is

     sometimes useful to give a delay of the form `3.5' to

     specify a delay per line to tenths of milliseconds.  (Only

     one decimal place is allowed.)



     A number of escape sequences are provided in the string-

     valued capabilities for easy encoding of control characters

     there.  \E maps to an ESC character, ^X maps to a control-X

     for any appropriate X, and the sequences \n \r \t \b \f map

     to linefeed, return, tab, backspace, and formfeed, respec-

     tively.  Finally, characters may be given as three octal

     digits after a \, and the characters ^ and \ may be given as

     \^ and \\.  If it is necessary to place a : in a capability

     it must be escaped in octal as \072.  If it is necessary to

     place a NUL character in a string capability it must be

     encoded as \200.  (The routines that deal with _t_e_r_m_c_a_p use C







Printed 8/14/86          1 November 1985			6













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     strings and strip the high bits of the output very late, so

     that a \200 comes out as a \000 would.)



     Sometimes individual capabilities must be commented out.  To

     do this, put a period before the capability name.	For exam-

     ple, see the first cr and ta in the example above.



     Preparing Descriptions



     We now outline how to prepare descriptions of terminals.

     The most effective way to prepare a terminal description is

     by imitating the description of a similar terminal in

     _t_e_r_m_c_a_p and to build up a description gradually, using par-

     tial descriptions with _v_i to check that they are correct.

     Be aware that a very unusual terminal may expose deficien-

     cies in the ability of the _t_e_r_m_c_a_p file to describe it or

     bugs in _v_i.  To easily test a new terminal description you

     can set the environment variable TERMCAP to the absolute

     pathname of a file containing the description you are work-

     ing on and programs will look there rather than in

     /_e_t_c/_t_e_r_m_c_a_p.  TERMCAP can also be set to the _t_e_r_m_c_a_p entry

     itself to avoid reading the file when starting up a program.



     To get the padding for insert-line right (if the terminal

     manufacturer did not document it), a severe test is to use

     _v_i to edit /_e_t_c/_p_a_s_s_w_d at 9600 baud, delete roughly 16 lines

     from the middle of the screen, then hit the `u' key several

     times quickly.  If the display messes up, more padding is

     usually needed.  A similar test can be used for insert-

     character.



     Basic Capabilities



     The number of columns on each line of the display is given

     by the co numeric capability.  If the display is a CRT, then

     the number of lines on the screen is given by the li capa-

     bility.  If the display wraps around to the beginning of the

     next line when the cursor reaches the right margin, then it

     should have the am capability.  If the terminal can clear

     its screen, the code to do this is given by the cl string

     capability.  If the terminal overstrikes (rather than clear-

     ing the position when a character is overwritten), it should

     have the os capability.  If the terminal is a printing ter-

     minal, with no soft copy unit, give it both hc and os.  (os

     applies to storage scope terminals, such as the Tektronix

     4010 series, as well as to hard copy and APL terminals.) If

     there is a code to move the cursor to the left edge of the

     current row, give this as cr.  (Normally this will be

     carriage-return, ^M.) If there is a code to produce an audi-

     ble signal (bell, beep, _e_t_c.), give this as bl.











Printed 8/14/86          1 November 1985			7













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     If there is a code (such as backspace) to move the cursor

     one position to the left, that capability should be given as

     le.  Similarly, codes to move to the right, up, and down

     should be given as nd, up, and do, respectively.  These

     _l_o_c_a_l _c_u_r_s_o_r _m_o_t_i_o_n_s should not alter the text they pass

     over; for example, you would not normally use "nd= " unless

     the terminal has the os capability, because the space would

     erase the character moved over.



     A very important point here is that the local cursor motions

     encoded in _t_e_r_m_c_a_p have undefined behavior at the left and

     top edges of a CRT display.  Programs should never attempt

     to backspace around the left edge, unless bw is given, and

     never attempt to go up off the top using local cursor

     motions.



     In order to scroll text up, a program goes to the bottom

     left corner of the screen and sends the sf (index) string.

     To scroll text down, a program goes to the top left corner

     of the screen and sends the sr (reverse index) string.  The

     strings sf and sr have undefined behavior when not on their

     respective corners of the screen.	Parameterized versions of

     the scrolling sequences are SF and SR, which have the same

     semantics as sf and sr except that they take one parameter

     and scroll that many lines.  They also have undefined

     behavior except at the appropriate corner of the screen.



     The am capability tells whether the cursor sticks at the

     right edge of the screen when text is output there, but this

     does not necessarily apply to nd from the last column.

     Leftward local motion is defined from the left edge only

     when bw is given; then an le from the left edge will move to

     the right edge of the previous row.  This is useful for

     drawing a box around the edge of the screen, for example.

     If the terminal has switch-selectable automatic margins, the

     _t_e_r_m_c_a_p description usually assumes that this feature is on,

     _i._e., am.	If the terminal has a command that moves to the

     first column of the next line, that command can be given as

     nw (newline).  It is permissible for this to clear the

     remainder of the current line, so if the terminal has no

     correctly-working CR and LF it may still be possible to

     craft a working nw out of one or both of them.



     These capabilities suffice to describe hardcopy and "glass-

     tty" terminals.  Thus the Teletype model 33 is described as



	     T3|tty33|33|tty|Teletype model 33:\

		     :bl=^G:co#72:cr=^M:do=^J:hc:os:



     and the Lear Siegler ADM-3 is described as











Printed 8/14/86          1 November 1985			8













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







	     l3|adm3|3|LSI ADM-3:\

		     :am:bl=^G:cl=^Z:co#80:cr=^M:do=^J:le=^H:li#24:sf=^J:



     Parameterized Strings



     Cursor addressing and other strings requiring parameters are

     described by a parameterized string capability, with

     _p_r_i_n_t_f(3S)-like escapes %x in it, while other characters are

     passed through unchanged.	For example, to address the cur-

     sor the cm capability is given, using two parameters: the

     row and column to move to.  (Rows and columns are numbered

     from zero and refer to the physical screen visible to the

     user, not to any unseen memory.  If the terminal has

     memory-relative cursor addressing, that can be indicated by

     an analogous CM capability.)



     The % encodings have the following meanings:



	  %%   output `%'

	  %d   output value as in _p_r_i_n_t_f %d

	  %2   output value as in _p_r_i_n_t_f %2d

	  %3   output value as in _p_r_i_n_t_f %3d

	  %.   output value as in _p_r_i_n_t_f %c

	  %+_x  add _x to value, then do %.

	  %>_x_y if value > _x then add _y, no output

	  %r   reverse order of two parameters, no output

	  %i   increment by one, no output

	  %n   exclusive-or all parameters with 0140 (Datamedia 2500)

	  %B   BCD (16*(value/10)) + (value%10), no output

	  %D   Reverse coding (value - 2*(value%16)), no output (Delta Data)



     Consider the Hewlett-Packard 2645, which, to get to row 3

     and column 12, needs to be sent "\E&a12c03Y" padded for 6

     milliseconds.  Note that the order of the row and column

     coordinates is reversed here and that the row and column are

     sent as two-digit integers.  Thus its cm capability is

     "cm=6\E&%r%2c%2Y".



     The Microterm ACT-IV needs the current row and column sent

     simply encoded in binary preceded by a ^T, "cm=^T%.%.".

     Terminals that use "%." need to be able to backspace the

     cursor (le) and to move the cursor up one line on the screen

     (up).  This is necessary because it is not always safe to

     transmit \n, ^D, and \r, as the system may change or discard

     them.  (Programs using _t_e_r_m_c_a_p must set terminal modes so

     that tabs are not expanded, so \t is safe to send.  This

     turns out to be essential for the Ann Arbor 4080.)



     A final example is the Lear Siegler ADM-3a, which offsets

     row and column by a blank character, thus "cm=\E=%+ %+ ".











Printed 8/14/86          1 November 1985			9













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     Row or column absolute cursor addressing can be given as

     single parameter capabilities ch (horizontal position abso-

     lute) and cv (vertical position absolute).  Sometimes these

     are shorter than the more general two-parameter sequence (as

     with the Hewlett-Packard 2645) and can be used in preference

     to cm.  If there are parameterized local motions (_e._g., move

     _n positions to the right) these can be given as DO, LE, RI,

     and UP with a single parameter indicating how many positions

     to move.  These are primarily useful if the terminal does

     not have cm, such as the Tektronix 4025.



     Cursor Motions



     If the terminal has a fast way to home the cursor (to the

     very upper left corner of the screen), this can be given as

     ho.  Similarly, a fast way of getting to the lower left-hand

     corner can be given as ll; this may involve going up with up

     from the home position, but a program should never do this

     itself (unless ll does), because it can make no assumption

     about the effect of moving up from the home position.  Note

     that the home position is the same as cursor address (0,0):

     to the top left corner of the screen, not of memory.

     (Therefore, the "\EH" sequence on Hewlett-Packard terminals

     cannot be used for ho.)



     Area Clears



     If the terminal can clear from the current position to the

     end of the line, leaving the cursor where it is, this should

     be given as ce.  If the terminal can clear from the current

     position to the end of the display, this should be given as

     cd.  cd must only be invoked from the first column of a

     line.  (Therefore, it can be simulated by a request to

     delete a large number of lines, if a true cd is not avail-

     able.)



     Insert/Delete Line



     If the terminal can open a new blank line before the line

     containing the cursor, this should be given as al; this must

     be invoked only from the first position of a line.  The cur-

     sor must then appear at the left of the newly blank line.

     If the terminal can delete the line that the cursor is on,

     this should be given as dl; this must only be used from the

     first position on the line to be deleted.	Versions of al

     and dl which take a single parameter and insert or delete

     that many lines can be given as AL and DL.  If the terminal

     has a settable scrolling region (like the VT100), the com-

     mand to set this can be described with the cs capability,

     which takes two parameters: the top and bottom lines of the

     scrolling region.	The cursor position is, alas, undefined

     after using this command.	It is possible to get the effect







Printed 8/14/86          1 November 1985		       10













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     of insert or delete line using this command - the sc and rc

     (save and restore cursor) commands are also useful.  Insert-

     ing lines at the top or bottom of the screen can also be

     done using sr or sf on many terminals without a true

     insert/delete line, and is often faster even on terminals

     with those features.



     If the terminal has the ability to define a window as part

     of memory which all commands affect, it should be given as

     the parameterized string wi.  The four parameters are the

     starting and ending lines in memory and the starting and

     ending columns in memory, in that order.  (This _t_e_r_m_i_n_f_o

     capability is described for completeness.	It is unlikely

     that any _t_e_r_m_c_a_p-using program will support it.)



     If the terminal can retain display memory above the screen,

     then the da capability should be given; if display memory

     can be retained below, then db should be given.  These indi-

     cate that deleting a line or scrolling may bring non-blank

     lines up from below or that scrolling back with sr may bring

     down non-blank lines.



     Insert/Delete Character



     There are two basic kinds of intelligent terminals with

     respect to insert/delete character that can be described

     using _t_e_r_m_c_a_p.  The most common insert/delete character

     operations affect only the characters on the current line

     and shift characters off the end of the line rigidly.  Other

     terminals, such as the Concept-100 and the Perkin Elmer Owl,

     make a distinction between typed and untyped blanks on the

     screen, shifting upon an insert or delete only to an untyped

     blank on the screen which is either eliminated or expanded

     to two untyped blanks.  You can determine the kind of termi-

     nal you have by clearing the screen then typing text

     separated by cursor motions.  Type "abc	def" using local

     cursor motions (not spaces) between the "abc" and the "def".

     Then position the cursor before the "abc" and put the termi-

     nal in insert mode.  If typing characters causes the rest of

     the line to shift rigidly and characters to fall off the

     end, then your terminal does not distinguish between blanks

     and untyped positions.  If the "abc" shifts over to the

     "def" which then move together around the end of the current

     line and onto the next as you insert, then you have the

     second type of terminal and should give the capability in,

     which stands for "insert null".  While these are two logi-

     cally separate attributes (one line _v_s. multi-line insert

     mode, and special treatment of untyped spaces), we have seen

     no terminals whose insert mode cannot be described with the

     single attribute.











Printed 8/14/86          1 November 1985		       11













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     _T_e_r_m_c_a_p can describe both terminals that have an insert mode

     and terminals that send a simple sequence to open a blank

     position on the current line.  Give as im the sequence to

     get into insert mode.  Give as ei the sequence to leave

     insert mode.  Now give as ic any sequence that needs to be

     sent just before each character to be inserted.  Most termi-

     nals with a true insert mode will not give ic; terminals

     that use a sequence to open a screen position should give it

     here.  (If your terminal has both, insert mode is usually

     preferable to ic.	Do not give both unless the terminal

     actually requires both to be used in combination.) If post-

     insert padding is needed, give this as a number of mil-

     liseconds in ip (a string option).  Any other sequence that

     may need to be sent after insertion of a single character

     can also be given in ip.  If your terminal needs to be

     placed into an `insert mode' and needs a special code

     preceding each inserted character, then both im/ei and ic

     can be given, and both will be used.  The IC capability,

     with one parameter _n, will repeat the effects of ic _n times.



     It is occasionally necessary to move around while in insert

     mode to delete characters on the same line (_e._g., if there

     is a tab after the insertion position).  If your terminal

     allows motion while in insert mode, you can give the capa-

     bility mi to speed up inserting in this case.  Omitting mi

     will affect only speed.  Some terminals (notably

     Datamedia's) must not have mi because of the way their

     insert mode works.



     Finally, you can specify dc to delete a single character, DC

     with one parameter _n to delete _n characters, and delete mode

     by giving dm and ed to enter and exit delete mode (which is

     any mode the terminal needs to be placed in for dc to work).



     Highlighting, Underlining, and Visible Bells



     If your terminal has one or more kinds of display attri-

     butes, these can be represented in a number of different

     ways.  You should choose one display form as _s_t_a_n_d_o_u_t _m_o_d_e,

     representing a good high-contrast, easy-on-the-eyes format

     for highlighting error messages and other attention getters.

     (If you have a choice, reverse video plus half-bright is

     good, or reverse video alone.) The sequences to enter and

     exit standout mode are given as so and se, respectively.  If

     the code to change into or out of standout mode leaves one

     or even two blank spaces or garbage characters on the

     screen, as the TVI 912 and Teleray 1061 do, then sg should

     be given to tell how many characters are left.



     Codes to begin underlining and end underlining can be given

     as us and ue, respectively.  Underline mode change garbage

     is specified by ug, similar to sg.  If the terminal has a







Printed 8/14/86          1 November 1985		       12













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     code to underline the current character and move the cursor

     one position to the right, such as the Microterm Mime, this

     can be given as uc.



     Other capabilities to enter various highlighting modes

     include mb (blinking), md (bold or extra bright), mh (dim or

     half-bright), mk (blanking or invisible text), mp (pro-

     tected), mr (reverse video), me (turn off _a_l_l attribute

     modes), as (enter alternate character set mode), and ae

     (exit alternate character set mode).  Turning on any of

     these modes singly may or may not turn off other modes.



     If there is a sequence to set arbitrary combinations of

     mode, this should be given as sa (set attributes), taking 9

     parameters.  Each parameter is either 0 or 1, as the

     corresponding attributes is on or off.  The 9 parameters

     are, in order: standout, underline, reverse, blink, dim,

     bold, blank, protect, and alternate character set.  Not all

     modes need be supported by sa, only those for which

     corresponding attribute commands exist.  (It is unlikely

     that a _t_e_r_m_c_a_p-using program will support this capability,

     which is defined for compatibility with _t_e_r_m_i_n_f_o.)



     Terminals with the "magic cookie" glitches (sg and ug),

     rather than maintaining extra attribute bits for each char-

     acter cell, instead deposit special "cookies", or "garbage

     characters", when they receive mode-setting sequences, which

     affect the display algorithm.



     Some terminals, such as the Hewlett-Packard 2621, automati-

     cally leave standout mode when they move to a new line or

     when the cursor is addressed.  Programs using standout mode

     should exit standout mode on such terminals before moving

     the cursor or sending a newline.  On terminals where this is

     not a problem, the ms capability should be present to say

     that this overhead is unnecessary.



     If the terminal has a way of flashing the screen to indicate

     an error quietly (a bell replacement), this can be given as

     vb; it must not move the cursor.



     If the cursor needs to be made more visible than normal when

     it is not on the bottom line (to change, for example, a

     non-blinking underline into an easier-to-find block or

     blinking underline), give this sequence as vs.  If there is

     a way to make the cursor completely invisible, give that as

     vi.  The capability ve, which undoes the effects of both of

     these modes, should also be given.



     If your terminal correctly displays underlined characters

     (with no special codes needed) even though it does not over-

     strike, then you should give the capability ul.  If







Printed 8/14/86          1 November 1985		       13













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     overstrikes are erasable with a blank, this should be indi-

     cated by giving eo.



     Keypad



     If the terminal has a keypad that transmits codes when the

     keys are pressed, this information can be given.  Note that

     it is not possible to handle terminals where the keypad only

     works in local mode (this applies, for example, to the

     unshifted Hewlett-Packard 2621 keys).  If the keypad can be

     set to transmit or not transmit, give these codes as ks and

     ke.  Otherwise the keypad is assumed to always transmit.

     The codes sent by the left-arrow, right-arrow, up-arrow,

     down-arrow, and home keys can be given as kl, kr, ku, kd,

     and kh, respectively.  If there are function keys such as

     f0, f1, ..., f9, the codes they send can be given as k0, k1,

     k9.  If these keys have labels other than the default f0

     through f9, the labels can be given as l0, l1, l9.  The

     codes transmitted by certain other special keys can be

     given: kH (home down), kb (backspace), ka (clear all tabs),

     kt (clear the tab stop in this column), kC (clear screen or

     erase), kD (delete character), kL (delete line), kM (exit

     insert mode), kE (clear to end of line), kS (clear to end of

     screen), kI (insert character or enter insert mode), kA

     (insert line), kN (next page), kP (previous page), kF

     (scroll forward/down), kR (scroll backward/up), and kT (set

     a tab stop in this column).  In addition, if the keypad has

     a 3 by 3 array of keys including the four arrow keys, then

     the other five keys can be given as K1, K2, K3, K4, and K5.

     These keys are useful when the effects of a 3 by 3 direc-

     tional pad are needed.  The obsolete ko capability formerly

     used to describe "other" function keys has been completely

     supplanted by the above capabilities.



     The ma entry is also used to indicate arrow keys on termi-

     nals that have single-character arrow keys.  It is obsolete

     but still in use in version 2 of _v_i which must be run on

     some minicomputers due to memory limitations.  This field is

     redundant with kl, kr, ku, kd, and kh.  It consists of

     groups of two characters.	In each group, the first charac-

     ter is what an arrow key sends, and the second character is

     the corresponding _v_i command.  These commands are h for kl,

     j for kd, k for ku, l for kr, and H for kh.  For example,

     the Mime would have "ma=^Hh^Kj^Zk^Xl" indicating arrow keys

     left (^H), down (^K), up (^Z), and right (^X).  (There is no

     home key on the Mime.)



     Tabs and Initialization



     If the terminal needs to be in a special mode when running a

     program that uses these capabilities, the codes to enter and

     exit this mode can be given as ti and te.	This arises, for







Printed 8/14/86          1 November 1985		       14













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     example, from terminals like the Concept with more than one

     page of memory.  If the terminal has only memory-relative

     cursor addressing and not screen-relative cursor addressing,

     a screen-sized window must be fixed into the display for

     cursor addressing to work properly.  This is also used for

     the Tektronix 4025, where ti sets the command character to

     be the one used by _t_e_r_m_c_a_p.



     Other capabilities include is, an initialization string for

     the terminal, and if, the name of a file containing long

     initialization strings.  These strings are expected to set

     the terminal into modes consistent with the rest of the

     _t_e_r_m_c_a_p description.  They are normally sent to the terminal

     by the _t_s_e_t program each time the user logs in.  They will

     be printed in the following order: is; setting tabs using ct

     and st; and finally if.  (_T_e_r_m_i_n_f_o uses i1-i2 instead of is

     and runs the program iP and prints i3 after the other ini-

     tializations.) A pair of sequences that does a harder reset

     from a totally unknown state can be analogously given as rs

     and if.  These strings are output by the _r_e_s_e_t program,

     which is used when the terminal gets into a wedged state.

     (_T_e_r_m_i_n_f_o uses r1-r3 instead of rs.) Commands are normally

     placed in rs and rf only if they produce annoying effects on

     the screen and are not necessary when logging in.	For exam-

     ple, the command to set the VT100 into 80-column mode would

     normally be part of is, but it causes an annoying glitch of

     the screen and is not normally needed since the terminal is

     usually already in 80-column mode.



     If the terminal has hardware tabs, the command to advance to

     the next tab stop can be given as ta (usually ^I).  A "back-

     tab" command which moves leftward to the previous tab stop

     can be given as bt.  By convention, if the terminal driver

     modes indicate that tab stops are being expanded by the com-

     puter rather than being sent to the terminal, programs

     should not use ta or bt even if they are present, since the

     user may not have the tab stops properly set.  If the termi-

     nal has hardware tabs that are initially set every _n posi-

     tions when the terminal is powered up, then the numeric

     parameter it is given, showing the number of positions

     between tab stops.  This is normally used by the _t_s_e_t com-

     mand to determine whether to set the driver mode for

     hardware tab expansion, and whether to set the tab stops.

     If the terminal has tab stops that can be saved in nonvola-

     tile memory, the _t_e_r_m_c_a_p description can assume that they

     are properly set.



     If there are commands to set and clear tab stops, they can

     be given as ct (clear all tab stops) and st (set a tab stop

     in the current column of every row).  If a more complex

     sequence is needed to set the tabs than can be described by

     this, the sequence can be placed in is or if.







Printed 8/14/86          1 November 1985		       15













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     Delays



     Certain capabilities control padding in the terminal driver.

     These are primarily needed by hardcopy terminals and are

     used by the _t_s_e_t program to set terminal driver modes

     appropriately.  Delays embedded in the capabilities cr, sf,

     le, ff, and ta will cause the appropriate delay bits to be

     set in the terminal driver.  If pb (padding baud rate) is

     given, these values can be ignored at baud rates below the

     value of pb.  For 4.2BSD _t_s_e_t, the delays are given as

     numeric capabilities dC, dN, dB, dF, and dT instead.



     Miscellaneous



     If the terminal requires other than a NUL (zero) character

     as a pad, this can be given as pc.  Only the first character

     of the pc string is used.



     If the terminal has commands to save and restore the posi-

     tion of the cursor, give them as sc and rc.



     If the terminal has an extra "status line" that is not nor-

     mally used by software, this fact can be indicated.  If the

     status line is viewed as an extra line below the bottom

     line, then the capability hs should be given.  Special

     strings to go to a position in the status line and to return

     from the status line can be given as ts and fs.  (fs must

     leave the cursor position in the same place that it was

     before ts.  If necessary, the sc and rc strings can be

     included in ts and fs to get this effect.) The capability ts

     takes one parameter, which is the column number of the

     status line to which the cursor is to be moved.  If escape

     sequences and other special commands such as tab work while

     in the status line, the flag es can be given.  A string that

     turns off the status line (or otherwise erases its contents)

     should be given as ds.  The status line is normally assumed

     to be the same width as the rest of the screen, _i._e., co.

     If the status line is a different width (possibly because

     the terminal does not allow an entire line to be loaded),

     then its width in columns can be indicated with the numeric

     parameter ws.



     If the terminal can move up or down half a line, this can be

     indicated with hu (half-line up) and hd (half-line down).

     This is primarily useful for superscripts and subscripts on

     hardcopy terminals.  If a hardcopy terminal can eject to the

     next page (form feed), give this as ff (usually ^L).



     If there is a command to repeat a given character a given

     number of times (to save time transmitting a large number of

     identical characters), this can be indicated with the

     parameterized string rp.  The first parameter is the







Printed 8/14/86          1 November 1985		       16













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     character to be repeated and the second is the number of

     times to repeat it.  (This is a _t_e_r_m_i_n_f_o feature that is

     unlikely to be supported by a program that uses _t_e_r_m_c_a_p.)



     If the terminal has a settable command character, such as

     the Tektronix 4025, this can be indicated with CC.  A proto-

     type command character is chosen which is used in all capa-

     bilities.	This character is given in the CC capability to

     identify it.  The following convention is supported on some

     UNIX systems: The environment is to be searched for a CC

     variable, and if found, all occurrences of the prototype

     character are replaced by the character in the environment

     variable.	This use of the CC environment variable is a very

     bad idea, as it conflicts with _m_a_k_e(1).



     Terminal descriptions that do not represent a specific kind

     of known terminal, such as _s_w_i_t_c_h, _d_i_a_l_u_p, _p_a_t_c_h, and _n_e_t_-

     _w_o_r_k, should include the gn (generic) capability so that

     programs can complain that they do not know how to talk to

     the terminal.  (This capability does not apply to _v_i_r_t_u_a_l

     terminal descriptions for which the escape sequences are

     known.)



     If the terminal uses xoff/xon (DC3/DC1) handshaking for flow

     control, give xo.	Padding information should still be

     included so that routines can make better decisions about

     costs, but actual pad characters will not be transmitted.



     If the terminal has a "meta key" which acts as a shift key,

     setting the 8th bit of any character transmitted, then this

     fact can be indicated with km.  Otherwise, software will

     assume that the 8th bit is parity and it will usually be

     cleared.  If strings exist to turn this "meta mode" on and

     off, they can be given as mm and mo.



     If the terminal has more lines of memory than will fit on

     the screen at once, the number of lines of memory can be

     indicated with lm.  An explicit value of 0 indicates that

     the number of lines is not fixed, but that there is still

     more memory than fits on the screen.



     If the terminal is one of those supported by the UNIX system

     virtual terminal protocol, the terminal number can be given

     as vt.



     Media copy strings which control an auxiliary printer con-

     nected to the terminal can be given as ps: print the con-

     tents of the screen; pf: turn off the printer; and po: turn

     on the printer.  When the printer is on, all text sent to

     the terminal will be sent to the printer.	It is undefined

     whether the text is also displayed on the terminal screen

     when the printer is on.  A variation pO takes one parameter







Printed 8/14/86          1 November 1985		       17













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     and leaves the printer on for as many characters as the

     value of the parameter, then turns the printer off.  The

     parameter should not exceed 255.  All text, including pf, is

     transparently passed to the printer while pO is in effect.



     Strings to program function keys can be given as pk, pl, and

     px.  Each of these strings takes two parameters: the func-

     tion key number to program (from 0 to 9) and the string to

     program it with.  Function key numbers out of this range may

     program undefined keys in a terminal-dependent manner.  The

     differences among the capabilities are that pk causes press-

     ing the given key to be the same as the user typing the

     given string; pl causes the string to be executed by the

     terminal in local mode; and px causes the string to be

     transmitted to the computer.  Unfortunately, due to lack of

     a definition for string parameters in _t_e_r_m_c_a_p, only _t_e_r_m_i_n_f_o

     supports these capabilities.



     Glitches and Braindamage



     Hazeltine terminals, which do not allow `~' characters to be

     displayed, should indicate hz.



     The nc capability, now obsolete, formerly indicated

     Datamedia terminals, which echo \r \n for carriage return

     then ignore a following linefeed.



     Terminals that ignore a linefeed immediately after an am

     wrap, such as the Concept, should indicate xn.



     If ce is required to get rid of standout (instead of merely

     writing normal text on top of it), xs should be given.



     Teleray terminals, where tabs turn all characters moved over

     to blanks, should indicate xt (destructive tabs).	This

     glitch is also taken to mean that it is not possible to

     position the cursor on top of a "magic cookie", and that to

     erase standout mode it is necessary to use delete and insert

     line.



     The Beehive Superbee, which is unable to correctly transmit

     the ESC or ^C characters, has xb, indicating that the "f1"

     key is used for ESC and "f2" for ^C.  (Only certain Super-

     bees have this problem, depending on the ROM.)



     Other specific terminal problems may be corrected by adding

     more capabilities of the form x_x.



     Similar Terminals



     If there are two very similar terminals, one can be defined

     as being just like the other with certain exceptions.  The







Printed 8/14/86          1 November 1985		       18













TERMCAP(5)	    UNIX Programmer's Manual	       TERMCAP(5)







     string capability tc can be given with the name of the simi-

     lar terminal.  This capability must be _l_a_s_t, and the com-

     bined length of the entries must not exceed 1024.	The capa-

     bilities given before tc override those in the terminal type

     invoked by tc.  A capability can be canceled by placing xx@

     to the left of the tc invocation, where _x_x is the capabil-

     ity.  For example, the entry



	  hn|2621-nl:ks@:ke@:tc=2621:



     defines a "2621-nl" that does not have the ks or ke capabil-

     ities, hence does not turn on the function key labels when

     in visual mode.  This is useful for different modes for a

     terminal, or for different user preferences.



AUTHOR

     William Joy

     Mark Horton added underlining and keypad support



FILES

     /etc/termcap   file containing terminal descriptions



SEE ALSO

     ex(1), more(1), tset(1), ul(1), vi(1), curses(3X),

     printf(3S), term(7).



CAVEATS AND BUGS

     Note: _t_e_r_m_c_a_p was replaced by _t_e_r_m_i_n_f_o in UNIX System V

     Release 2.0.  The transition will be relatively painless if

     capabilities flagged as "obsolete" are avoided.



     Lines and columns are now stored by the kernel as well as in

     the termcap entry.  Most programs now use the kernel infor-

     mation primarily; the information in this file is used only

     if the kernel does not have any information.



     _V_i allows only 256 characters for string capabilities, and

     the routines in _t_e_r_m_l_i_b(3) do not check for overflow of this

     buffer.  The total length of a single entry (excluding only

     escaped newlines) may not exceed 1024.



     Not all programs support all entries.



























Printed 8/14/86          1 November 1985		       19







