/****************************************************************/
/*      FIXTREE  -  by Guy L. Albertelli                        */
/*                      4142 Highland Dr.                       */
/*                      Mogadore, Oh.  44260                    */
/*                                                              */
/*      ************  SHAREWARE   ************                  */
/*                                                              */
/*      for the benefit of the ST community                     */
/*                                                              */
/*      ************  SHAREWARE   ************                  */
/*                                                              */
/*      This set of routines will convert a resource file       */
/*      in source format (.RSH) that has been compiled and      */
/*      linked with these routines to a working resource file   */
/*      for GEM. Conceptually this could eliminate the need     */
/*      for RSC files (provided the compiler can compile the    */
/*      necessary code.                                         */
/*                                                              */
/*      USAGE:                                                  */
/*              After the appl_init call, call fix_tree with    */
/*      the symbol NUM_TREE as a parameter. That symbol is      */
/*      defined in the .RSH file. After that call all the       */
/*      rsrc_ calls are valid except rsrc_load and rsrc_free.   */
/*      If you want to load a new resource file then call       */
/*      unfix_tree() to remove the effects of fix_tree.         */
/*                                                              */
/*      NOTE: Never call fix_tree twice, all hell will break    */
/*              loose.                                          */
/*                                                              */
/****************************************************************/

/****************************************************************/
/*      Modified by Chor-ming Lung              12/23/87        */
/*      for Megamax and Mark Williams C                         */
/*                                                              */
/*      I think this file was written for Alcyon C.             */
/*      The problems that Mark Williams C and Megamax C         */
/*      encounter with this file are :                          */
/* 1.   Some int and long items are actually pointer of         */
/*      something else.                                         */
/* 2.   rs_tedinfo[].te_ptext/te_ptmplt/te_pvalid in .C file    */
/*      generated by RCS are integer index for rs_strings.      */
/*      Actually, their definitions are char pointers. But,     */
/*      rs_tedinfo[k].te_ptext=rs_strings[rs_tedinfo[k].te_ptext*/
/*      is not acceptable.                                      */
/* 3.   rs_object[].ob_spec is a long number in Mark William C. */
/*      It is a char pointer in Megamax C.                      */
/* Note: The offending codes have been commented out            */
/* Note: Mark Williams' C preprocessor defines GEMDOS,M68000    */
/*      That is the way to handle problem 3.                    */
/****************************************************************/

/****************************************************************/
/*      Note from Jinfu Chen                      1/23/88       */
/*      Thanks to Lung for fixing the codes.                    */
/*      However, he left out the char pointer typecast  for MMC */
/*      so the text info still didn't work when compiled under  */
/*      MMC. Fix is simple, just change the fix_tree2 to char   */
/*      pointer instead of int                                  */
/****************************************************************/

/****************************************************************/
/* INCLUDE FILES                                                */
/****************************************************************/

/* original include files for Alcyon C ?
#include "portab.h"
#include "obdefs.h"
#include "define.h"
#include "gemdefs.h"
*/

#include <portab.h>
#include <obdefs.h>
#include <gemdefs.h>

/****************************************************************/
/* RESOURCE DATA                                                */
/****************************************************************/

extern  BYTE *rs_strings[];
extern  LONG rs_frstr[];
extern  BITBLK rs_bitblk[];
extern  LONG rs_frimg[];
extern  ICONBLK rs_iconblk[];
extern  TEDINFO rs_tedinfo[];
extern  OBJECT rs_object[];
extern  LONG rs_trindex[];
extern  struct foobar {
        WORD    dummy;
        WORD    *image;
        } rs_imdope[];

/****************************************************************/
/* EXTERNALS                                                    */
/****************************************************************/

extern WORD     global[];

/****************************************************************/
/*      Take the .RSH code from the RCS output and make it a    */
/*      usable set of resource trees.  This code will do the    */
/*      basic items that rsrc_load() would do without requiring */
/*      a file to load.                                         */
/*                                                              */
/* INPUT:                                                       */
/*      num     number of trees in .RSH file (NUM_TREE)         */
/****************************************************************/
/****************************************************************/
/* Note from Lung:                                              */
/*      My RCS can generate .C code but no .RSH code. The file  */
/*      SAMPLE.RSH seems not correct. I use RCS to generate     */
/*      .C file and recompile FIXTRTST.C. It runs flawlessly.   */
/****************************************************************/

fix_tree(num)
WORD    num;
{
/*
        LONG *pl;
*/
        WORD i,j;
        long fix_tree3();


        fix_tree1( &global[5], &rs_trindex[0]);
/*      pl = &global[5];
        *pl = &rs_trindex;
*/
        for (i=0;i<num;i++){
                j = rs_trindex[i];      /* get index of top obj in tree */
/*              rs_trindex[i] = &rs_object[j];
*/              rs_trindex[i] = fix_tree3(&rs_object[j]);
                fix_object(i,j,j);      /* fix top object then all rest */
                fix_level(i,rs_object[j].ob_head,rs_object[j].ob_tail,j);
        }
}

/****************************************************************/
/*      This routine will clear the pointer to the resource     */
/*      tree so that GEM doesn't try to free the memory         */
/****************************************************************/
unfix_tree()
{
/*      LONG *pl;
        pl = &global[5];
        *pl = 0L;
*/
        fix_tree1(&global[5],0L);
}

/****************************************************************/
/*      This routine will cycle across a level in the resource  */
/*      tree and fix each object in that level. After fixing    */
/*      up the object, it will use itself (recursion) to fix    */
/*      any objects on a level below.                           */
/*                                                              */
/* INPUT:                                                       */
/*      tr_x    index in rs_trindex of the tree being done      */
/*              needed by fix_object                            */
/*      h       object number within tree of first item in      */
/*              this level                                      */
/*      t       object number within tree of last item in       */
/*              this level                                      */
/*      to      object number within rs_object of first         */
/*              item in tree                                    */
/****************************************************************/
fix_level(tr_x,h,t,to)
WORD    tr_x,h,t,to;
{
        WORD i,nh,nt;

        if(h==-1 && t==-1) return;      /* nobody on this level */
        do {
                i = to + h;
                fix_object(tr_x,i,to);  /* fix this object up   */
                nh = rs_object[i].ob_head;  /* get next head */
                nt = rs_object[i].ob_tail;  /* and tail indexes */
                fix_level(tr_x,nh,nt,to);   /* then fix the next level down */
                h = rs_object[i].ob_next;   /* go to next obj on this level */
        } while(t+to!=i);       /* till we have done the tail item */
}

/****************************************************************/
/*      This routine will fix up the pointers in each object    */
/*      and any associated control blocks. It will then use     */
/*      rsrc_obfix to update the pixel information to adjust    */
/*      for the current resolution and display format.          */
/*                                                              */
/* INPUT:                                                       */
/*      tr_x    index in rs_trindex of the tree being done      */
/*              needed by rsrc_obfix                            */
/*      i       object number within rs_object to fixup         */
/*      to      object number within rs_object of tree top      */
/****************************************************************/
fix_object(tr_x,i,to)
WORD    tr_x,i,to;
{
        WORD k;
        LONG tst;

        long fix_tree3();
        int fix_tree2();
        char *fix_tree4();
        int lu;

/*      tst = rs_object[i].ob_spec; */  /* get current ob_spec value */
        tst = fix_tree3(rs_object[i].ob_spec);  /* get current ob_spec value */
        k = (WORD) tst;

        switch(rs_object[i].ob_type){   /* handle things depending on type */

        case G_TEXT:
        case G_BOXTEXT:
        case G_FTEXT:
        case G_FBOXTEXT:
                if (tst!=-1L){
/*                      rs_object[i].ob_spec = &rs_tedinfo[k];
                        rs_tedinfo[k].te_ptext =
                                rs_strings[rs_tedinfo[k].te_ptext];
                        rs_tedinfo[k].te_ptmplt =
                                rs_strings[rs_tedinfo[k].te_ptmplt];
                        rs_tedinfo[k].te_pvalid =
                                rs_strings[rs_tedinfo[k].te_pvalid];
*/
#ifdef GEMDOS
                        rs_object[i].ob_spec = fix_tree3(&rs_tedinfo[k]);
#else
                        rs_object[i].ob_spec = fix_tree4(&rs_tedinfo[k]);
#endif
                        lu=fix_tree2(rs_tedinfo[k].te_ptext);
                        rs_tedinfo[k].te_ptext = rs_strings[lu];
                        lu = fix_tree2(rs_tedinfo[k].te_ptmplt);
                        rs_tedinfo[k].te_ptmplt = rs_strings[lu];
                        lu = fix_tree2(rs_tedinfo[k].te_pvalid);
                        rs_tedinfo[k].te_pvalid = rs_strings[lu];
                }
                break;
        case G_BUTTON:
        case G_STRING:
        case G_TITLE:
                if (tst!=-1L) {
/*                      rs_object[i].ob_spec =
                                rs_strings[k];
*/
#ifdef GEMDOS
                        rs_object[i].ob_spec = fix_tree3(rs_strings[k]);
#else
                        rs_object[i].ob_spec = fix_tree4(rs_strings[k]);
#endif
                }
                break;
        case G_ICON:
                if (tst!=-1L) {
/*                      rs_object[i].ob_spec =
                                &rs_iconblk[k];
                        rs_iconblk[k].ib_pmask=
                                rs_imdope[rs_iconblk[k].ib_pmask].image;
                        rs_iconblk[k].ib_pdata=
                                rs_imdope[rs_iconblk[k].ib_pdata].image;
                        rs_iconblk[k].ib_ptext =
                                rs_strings[rs_iconblk[k].ib_ptext];
*/
#ifdef GEMDOS
                        rs_object[i].ob_spec = fix_tree3(&rs_iconblk[k]);
#else
                        rs_object[i].ob_spec = fix_tree4(&rs_iconblk[k]);
#endif
                        lu = fix_tree2(rs_iconblk[k].ib_pmask);
                        rs_iconblk[k].ib_pmask = rs_imdope[lu].image;
                        lu = fix_tree2(rs_iconblk[k].ib_pdata);
                        rs_iconblk[k].ib_pdata = rs_imdope[lu].image;
                        lu = fix_tree2(rs_iconblk[k].ib_ptext);
                        rs_iconblk[k].ib_ptext = rs_strings[lu];
                }
                break;
/*      case G_USERDEF:
*/              /* user must provide */
/*              break;
*/
        case G_IMAGE:
                if (tst!=-1L) {
/*                      rs_object[i].ob_spec =
                                &rs_bitblk[k];
                        rs_bitblk[k].bi_pdata=
                                rs_imdope[rs_bitblk[k].bi_pdata].image;
*/
#ifdef GEMDOS
                        rs_object[i].ob_spec = fix_tree3(&rs_bitblk[k]);
#else
                        rs_object[i].ob_spec = fix_tree4(&rs_bitblk[k]);
#endif
                        lu = fix_tree2(rs_bitblk[k].bi_pdata);
                        rs_bitblk[k].bi_pdata = rs_imdope[lu].image;
                }
                break;
        case G_BOX:
        case G_IBOX:
        case G_BOXCHAR:
                break;
        }
        rsrc_obfix(rs_trindex[tr_x],i-to);      /* fix pixel values for rez */
}

/****************************************************************/
/*      This routines will fix up the type checking problems    */
/****************************************************************/
fix_tree1(g,r)
long *g, r;
{
        *g = r;
}
#ifdef GEMDOS           /* MWC */
int fix_tree2(r)
int r;
{
        return(r);
}
#else                   /* MMC, use char pointer instead. JC Jan 23, 88 */
char *fix_tree2(r)
char *r;
{
        return(r);
}
#endif
long fix_tree3(a)
long a;
{
        return(a);
}

char *fix_tree4(a)
char *a;
{
        return(a);
}
