CURSES(3X)                                                          CURSES(3X)


NAME

    curses - screen functions with "optimal" cursor motion


DESCRIPTION

   The functions in the curses-package give you an implementation of the
UN*X-curses package for the Atari ST series computer. It allows you to do
terminal-oriented graphics of a crude nature. An image is kept of what the
current screen looks like, while the user creates a new image. Refresh()
must be called to make the current screen look like the one the user has
prepared. Initscr() must be called to initialize the package and endwin()
to clean up before exiting.

SEE ALSO

   Screen Updating and Cursor Movement Optimization : A Library Package,
       Ken Arnold.
   The CURSES screen updating and cursor movement package : A collection
       of C-functions for the Atari ST-series computers, R. van 't Veen.

AUTHORS

   UN*X-curses  : Ken Arnold.
   Atari-curses : Rene van 't Veen.

FUNCTIONS

   addch(c)                                  add a character to stdscr
   addstr(s)                                 add a string to stdscr
   box(win,v,h)                              draw a box around a window
   crmode()                                  set cbreak mode
   clear()                                   clear stdscr
   clearok(scr,f)                            set clear flag for scr
   cltobot()                                 clear to bottom on stdscr
   clrtoeol()                                clear to end of line on stdscr
   delch()                                   delete a character
   deleteln()                                delete a line
   delwin(w)                                 delete window w
   echo()                                    set echo mode
   endwin()                                  end window mode
   erase()                                   erase stdscr
   getch()                                   get a char through stdscr
   getstr()                                  get a string through stdscr
   getyx(w,y,x)                              get current coordinates
   inch()                                    get char at current coordinates
   initscr()                                 initialize curses
   insch()                                   insert a character
   insertln()                                insert a line
   leaveok(w,f)                              set leave flag for window w
   longname(termbuf, name)                   get a long terminal name
   move(y,x)                                 move to (y,x) on stdscr
   mvcur(ly,lx,ny,nx)                        actually move the cursor
   newwin(lines,cols,begin_y,begin_x)        create a window
   nl()                                      set newline mapping on
   nocrmode()                                unset cbreak mode
   noecho()                                  unset echo mode
   nonl()                                    set newline mapping off
   noraw()                                   unset raw mode
   overlay(win1,win2)                        overlay win1 on win2
   overwrite(win1,win2)                      overwrite win1 on win2
   raw()                                     set raw mode
   refresh()                                 make terminal look like stdscr
   scroll(win)                               scroll win one line up
   scrollok(w,f)                             set scroll flag for window win
   standend()                                leave standout mode
   standout()                                enter standout mode
   subwin(win,lines,cols,begin_y,begin_x)    create a sub window
   touchwin(win)                             change everything on win
   waddch(win,c)                             add char to win
   waddstr(win,s)                            add string to win
   wclear(w)                                 clear w
   wclrtobot(w)                              clear w to bottom of w
   wclrtoeol(w)                              clear w to end of line
   wdelch(w)                                 delete character from w
   wdeleteln(w)                              delete line from w
   werase(w)                                 erase w
   wgetch(w)                                 get a character through w
   wgetstr(w,s)                              get a string through w
   winch(w)                                  get char at current (y,x) of w
   winsch(w,c)                               insert a char on w
   winsertln(w)                              insert a line on w
   wmove(w,y,x)                              set current coordinates of w
   wrefresh(w)                               make terminal look like w
   wstandend(w)                              leave standout mode for w
   wstandout(w)                              enter standout mode for w

BUGS

   Hopefully none, but you never know ...
   If you find any, please let me know, 
   I ( Rene ) am at ..!mcvax!nikhefh!u13 .
