;*** achstart.s
;
;    871121


;*** Stack & Heap Sizes
; 
;    The stack sits below the heap and has STACK long words 
;    allocated. The heap size (memory kept after a shrink)
;    is set by EXTRA. _brk monitors heap space r=  ests.

STACK     =         $200
EXTRA     =         $2500


;*** Basepage Structure

LOTPA     =         $00       ; Low TPA address
HITPA     =         $04       ; High TPA address
CODEBASE  =         $08       ; Code segment start
CODELEN   =         $0c       ; Code segment length
DATABASE  =         $10       ; Data segment start
DATALEN   =         $14       ; Data segment length
BSSBASE   =         $18       ; Bss  segment start
BSSLEN    =         $1c       ; Bss  segment length
DTA       =         $20       ; Disk Transfer Address
PARENT    =         $24       ; parent's basepage
RESERVE1  =         $28       ; resevered
ENVIRON   =         $2c       ; environment string
FCB2      =         $38       ; 2nd parsed fcb
FCB1      =         $5c       ; 1st parsed fcb
COMMAND   =         $80       ; Command tail



          .globl    _FUBAR

;*** Start here

          .text
          .globl    __main
          .globl    __exit
          .globl    __sovf
          .even
_FUBAR:
          move.l    4(sp),a5
          move.l    a5,__base
          move.l    #U_STACK,sp 

          move.l    CODELEN(a5),d0
          add.l     DATALEN(a5),d0
          add.l     BSSLEN(a5),d0
          add.l     #EXTRA,d0

          move.l    d0,-(sp)
          move.l    a5,-(sp)
          clr.w     -(sp)
          move      #$4a,-(sp)          ; do Mshrink
          trap      #1
          add.l     #12,sp

          move.l    __base,a0           ; Load C external
          move.l    BSSBASE(a0),a1      ; a1 -> .bss region
          adda.l    BSSLEN(a0),a1       ; a1 -> 1st heap loc
          move.l    a1,__break          ; Put in "break" loc

          lea.l     COMMAND(a0),a2      ; a2 -> command line
          move.b    (a2)+,d0            ; d0 = byte count
          andi.l    #$ff,d0             ; clear junk
          move.w    d0,-(a7)            ; push length
          move.l    a2,-(a7)            ; Push commnd
          clr.l     a6                  ; Clear frame pointer
          jsr       __main
          jmp       __exit



          .globl    _brk

;*** brk

          .text
_brk:           
          move.l   4(sp),a0             ; new break r=  est
          move.l    #-1,d0
          move.l   __base,a1            ; basepage address
          move.l   HITPA(a1),a1         ; get MAX break
          cmpa.l    a0,a1               ; return -1 if 
          ble.s     BRKX                ;  r=  est >= TOP
          move.l    a0,__break
          clr.l     d0
BRKX:
          rts         


__sovf:
          move.w    #9,d0               ; String print
          lea       ovf,a0              ; a0-> message
          move.l    a0,d1               ; load proper reg
          trap      #2                  ; Issue message
__exit:
          move.w    #0,d0               ; Exit
          trap      #2



          .globl    _blkfill

;*** Block Fill function:
;
;    blkfill (dest, char, count);
;
; e  BYTE    *dest 
;    BYTE    char to fill
;    WORD    count
;
          .text
_blkfill:
          move.l    4(a7),a0       ; -> Output area
          move.w    8(a7),d1       ; =  output char
          move.w    10(a7),d0      ; =  output count
          ext.l     d0             ; make it long
          subq.l    #1,d0          ; decrement
          ble.s     filldone       ; Done if le
fillit:   move.b    d1,(a0)+       ; move a byte
          dbra      d0,fillit      ; Continue
filldone: clr.l     d0             ; always return 0
          rts 



          .globl    _index
          .globl    _strchr

;*** Index function to find out if a particular
;    character is in a string.
;
; e  long pointer to string
;    short character to find
;
; x  D0.L = pointer to character else NULL if failed

          .text
_index:
_strchr:
          move.l    4(a7),a0       ; a0 -> String
          move.w    8(a7),d0       ; D0 = desired character
xindex: 
          tst.b     (a0)           ; EOS?
          bne.s     notend         ; No, continue to look
          clr.l     d0             ; Not found
          rts 
notend: 
          cmp.b     (a0)+,d0       ; check for character
          bne.s     xindex
          move.l    a0,d0          ; Found it
          subq.l    #1,d0          ; set return pointer
          rts



          .globl    ___pname 
          .globl    ___tname
          .globl    ___lname
          .globl    ___xeof 

;*** Runtime Data

          .data
          .even
ovf:      .dc.b     'Stack Overflow$'   ; Error message
___pname: .dc.b     'C runtime',0       ; Program name
___tname: .dc.b     'CON:',0            ; Console name
___lname: .dc.b     'LST:',0            ; List device name
___xeof:  .dc.b     $1a                 ; Control-Z



          .globl    __base
          .globl    __break
          .globl    ___cpmrv

;*** BSS Data

          .bss
          .even
__base:   .ds.l     1              ; Base Page
__break:  .ds.l     1              ; Break function
___cpmrv: .ds.w     1              ; Last CP/M return val

          .ds.l     STACK
U_STACK:  .ds.l     1



          .globl    _crystal
          
;*** AES Call
;
; e  long pointer to AES parameter block

          .text
_crystal:
          move.l    4(sp),d1
          move.w    #200,d0
          trap      #2
          rts



          .globl    _control

;*** AES Arrays
;
;    short control [] =
;         {
;              op code,
;              size in words of _int_in,
;              size in words of _int_out,
;              size in longs of _addr_in,
;              size in longs of _addr_out,
;         }

          .bss
          .even
_control: .ds.w     4



          .globl    _ctrl_cnts

;*** Control Array Settings
;
;
;    This .data is used to set entrys 1, 2 and 3 in the control
;    array.

        .data
        .even
_ctrl_cnts:

;    Application Manager
        .dc.b   0, 1, 0                 ; func 010              
        .dc.b   2, 1, 1                 ; func 011              
        .dc.b   2, 1, 1                 ; func 012              
        .dc.b   0, 1, 1                 ; func 013              
        .dc.b   2, 1, 1                 ; func 014              
        .dc.b   1, 1, 1                 ; func 015              
        .dc.b   0, 0, 0                 ; func 016              
        .dc.b   0, 0, 0                 ; func 017              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 1, 0                 ; func 019              
;    Event Manager
        .dc.b   0, 1, 0                 ; func 020              
        .dc.b   3, 5, 0                 ; func 021              
        .dc.b   5, 5, 0                 ; func 022              
        .dc.b   0, 1, 1                 ; func 023              
        .dc.b   2, 1, 0                 ; func 024              
        .dc.b   16, 7, 1                ; func 025              
        .dc.b   2, 1, 0                 ; func 026              
        .dc.b   0, 0, 0                 ; func 027              
        .dc.b   0, 0, 0                 ; func 028              
        .dc.b   0, 0, 0                 ; func 009              
;    Menu Manager
        .dc.b   1, 1, 1                 ; func 030              
        .dc.b   2, 1, 1                 ; func 031              
        .dc.b   2, 1, 1                 ; func 032              
        .dc.b   2, 1, 1                 ; func 033              
        .dc.b   1, 1, 2                 ; func 034              
        .dc.b   1, 1, 1                 ; func 005              
        .dc.b   0, 0, 0                 ; func 006              
        .dc.b   0, 0, 0                 ; func 007              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 0, 0                 ; func 009              
;    Object Manager
        .dc.b   2, 1, 1                 ; func 040              
        .dc.b   1, 1, 1                 ; func 041              
        .dc.b   6, 1, 1                 ; func 042              
        .dc.b   4, 1, 1                 ; func 043              
        .dc.b   1, 3, 1                 ; func 044              
        .dc.b   2, 1, 1                 ; func 045              
        .dc.b   4, 2, 1                 ; func 046              
        .dc.b   8, 1, 1                 ; func 047              
        .dc.b   0, 0, 0                 ; func 048              
        .dc.b   0, 0, 0                 ; func 049              
;    Form Manager
        .dc.b   1, 1, 1                 ; func 050              
        .dc.b   9, 1, 1                 ; func 051              
        .dc.b   1, 1, 1                 ; func 002              
        .dc.b   1, 1, 0                 ; func 003              
        .dc.b   0, 5, 1                 ; func 004              
        .dc.b   0, 0, 0                 ; func 005              
        .dc.b   0, 0, 0                 ; func 006              
        .dc.b   0, 0, 0                 ; func 007              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 0, 0                 ; func 009              
;    Dialog Manager
        .dc.b   0, 0, 0                 ; func 060              
        .dc.b   0, 0, 0                 ; func 061              
        .dc.b   0, 0, 0                 ; func 062              
        .dc.b   0, 0, 0                 ; func 003              
        .dc.b   0, 0, 0                 ; func 004              
        .dc.b   0, 0, 0                 ; func 005              
        .dc.b   0, 0, 0                 ; func 006              
        .dc.b   0, 0, 0                 ; func 007              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 0, 0                 ; func 009              
;    Graphics Manager
        .dc.b   4, 3, 0                 ; func 070              
        .dc.b   8, 3, 0                 ; func 071              
        .dc.b   6, 1, 0                 ; func 072              
        .dc.b   8, 1, 0                 ; func 073              
        .dc.b   8, 1, 0                 ; func 074              
        .dc.b   4, 1, 1                 ; func 075              
        .dc.b   3, 1, 1                 ; func 076              
        .dc.b   0, 5, 0                 ; func 077              
        .dc.b   1, 1, 1                 ; func 078              
        .dc.b   0, 5, 0                 ; func 009              
;    Scrap Manager
        .dc.b   0, 1, 1                 ; func 080              
        .dc.b   0, 1, 1                 ; func 081              
        .dc.b   0, 0, 0                 ; func 082              
        .dc.b   0, 0, 0                 ; func 083              
        .dc.b   0, 0, 0                 ; func 084              
        .dc.b   0, 0, 0                 ; func 005              
        .dc.b   0, 0, 0                 ; func 006              
        .dc.b   0, 0, 0                 ; func 007              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 0, 0                 ; func 009              
;    fseler Manager
        .dc.b   0, 2, 2                 ; func 090              
        .dc.b   0, 0, 0                 ; func 091              
        .dc.b   0, 0, 0                 ; func 092              
        .dc.b   0, 0, 0                 ; func 003              
        .dc.b   0, 0, 0                 ; func 004              
        .dc.b   0, 0, 0                 ; func 005              
        .dc.b   0, 0, 0                 ; func 006              
        .dc.b   0, 0, 0                 ; func 007              
        .dc.b   0, 0, 0                 ; func 008              
        .dc.b   0, 0, 0                 ; func 009              
;    Window Manager
        .dc.b   5, 1, 0                 ; func 100              
        .dc.b   5, 1, 0                 ; func 101              
        .dc.b   1, 1, 0                 ; func 102              
        .dc.b   1, 1, 0                 ; func 103              
        .dc.b   2, 5, 0                 ; func 104              
        .dc.b   6, 1, 0                 ; func 105              
        .dc.b   2, 1, 0                 ; func 106              
        .dc.b   1, 1, 0                 ; func 107              
        .dc.b   6, 5, 0                 ; func 108              
        .dc.b   0, 0, 0                 ; func 009              
;    Resource Manger
        .dc.b   0, 1, 1                 ; func 110              
        .dc.b   0, 1, 0                 ; func 111              
        .dc.b   2, 1, 0                 ; func 112              
        .dc.b   2, 1, 1                 ; func 113              
        .dc.b   1, 1, 1                 ; func 114              
        .dc.b   0, 0, 0                 ; func 115              
        .dc.b   0, 0, 0                 ; func 006
        .dc.b   0, 0, 0                 ; func 007
        .dc.b   0, 0, 0                 ; func 008
        .dc.b   0, 0, 0                 ; func 009
;    Shell Manager
        .dc.b   0, 1, 2                 ; func 120
        .dc.b   3, 1, 2                 ; func 121
        .dc.b   1, 1, 1                 ; func 122
        .dc.b   1, 1, 1                 ; func 123
        .dc.b   0, 1, 1                 ; func 124
        .dc.b   0, 1, 2                 ; func 125



