/*
     achslib.h

     871203    A C Howe       Implementation
     880109                   Deque stuff
*/

#define achslib_header

typedef short  void;
typedef char   *pointer;

#include  <ctype.h>
#include  <gembind.h>
#include  <gemdefs.h>
#include  <osbind.h>
#include  <stdio.h>
#include  <tosdefs.h>
#include  <vdibind.h>

/* AES Exports */
extern short   gl_apid;
extern short   global [];
extern short   control [];

/* System Variables */
extern char    DEFRES;
extern char    MONITOR;  
extern char    CONTERM;

/* Anthony's Stuff */
extern char    TERM [][8];
extern short   XMAX;
extern short   YMAX;
extern short   TABLEN;
extern void    GOTOXY ();     /* short, short */
extern void    MOVEMEM ();    /* pointer, pointer, long */
extern long    STRLEN ();     /* char * */
extern void    STRNPUT ();    /* char *, short */
extern char *  STRTOK ();     /* char *, char * */
extern char *  NEXTTOK;
extern void    PUTDEC ();     /* short */
extern void    PUTLONG ();    /* long */
extern void    ULTOA ();      /* long, char * */
extern long    ULD ();        /* long , long */
extern long    DOS ();        /* short, long */
extern long    FINDI ();      /* char *, short */
extern long    LFINDI ();     /* char *, short */
extern long    gemdos ();
extern long    xbios ();


/*   Atari System Variables (supervisor only) */
#define   SHOW_SHIFT     (CONTERM |= 0x08)
#define   HIDE_SHIFT     (CONTERM &= 0xf7)


/*   Basic Terminal Functions */
#define   BEEP           (Cconws (&TERM[0]))
#define   SET_TERMINAL   (Cconws (&TERM[1]))
#define   RST_TERMINAL   (Cconws (&TERM[2]))
#define   HOME_CURSOR    (Cconws (&TERM[3]))
#define   SCREEN_CLEAR   (Cconws (&TERM[4]))
#define   EOL_CLEAR      (Cconws (&TERM[5]))
#define   EOP_CLEAR      (Cconws (&TERM[6]))
#define   ON_CURSOR      (Cconws (&TERM[7]))
#define   OFF_CURSOR     (Cconws (&TERM[8]))
#define   HI_LITE        (Cconws (&TERM[9]))
#define   LO_LITE        (Cconws (&TERM[10]))
#define   INS_LINE       (Cconws (&TERM[11]))
#define   DEL_LINE       (Cconws (&TERM[12]))
#define   UP_CURSOR      (Cconws (&TERM[13]))
#define   DOWN_CURSOR    (Cconws (&TERM[14]))
#define   RIGHT_CURSOR   (Cconws (&TERM[15]))
#define   LEFT_CURSOR    (Cconws (&TERM[16]))

#define NULL        0
#define LNULL       0L
#define BLOCK       128            /* must be powers of 2 */
#define DBLOCK      256            /* double block */
#define CTRLZ       0x1a
#define RUB         0x7f

#define FILES       0x00
#define READONLY    0x01
#define HIDDEN      0x02
#define SYSTEM      0x04
#define VOLUME      0x08
#define DIRECTORY   0x10
#define ARCHIVE     0x20


typedef union cbuffer
{
     struct template
     {
          char max_line;
          char length;
          char line [BLOCK - 2 * sizeof (char)];
     } c;
     char buf [BLOCK];
} 
     CBUFFER;


typedef struct command_entry
{
     char *name;
     void (*function) ();
}
     COMMAND;


typedef struct dta_buf
{
     char dummy[21];      /* first 21 bytes not used */
     char attr;           /* file attribute */
     short ftime;         /* file time stamp */
     short fdate;         /* file date stamp */
     long fsize;          /* file size in bytes */
     char fname[14];      /* file name and extension */
}
     DTA;


typedef struct deque
{
     long *base;
     long *left;
     long *right;
     long *end;
}
     DEQUE;

#define   LEFT      0
#define   RIGHT     1

extern DEQUE * MKDEQ ();      /* long */
extern void    DEQADD ();     /* DEQUE *, short, long */
extern long    DEQDEL ();     /* DEQUE *, short */
extern void    RMDEQ ();      /* DEQUE * */


