#!/usr/bin/perl -w
#     //   
# (c) Konstantin Kubatkin, 2:468/0@FidoNet, cat@3logic.net
# 23.02.2000

use English;
use File::Basename;

#   
if( $#ARGV == -1 ) { print "Usage: nethis.pl [zone:network]\nExample: nethis.pl 2:468\n\n"; exit 1; }
( $zone,$net ) = $ARGV[0] =~ /^(\S+)\:(\S+)/;
unless( $zone || $net ) { print "Address must be 2D!!!\n"; exit 1; }
#      
$diffprog = "/usr/local/bin/nldiff -n";
#     
$diffpath = "/usr/home/cat/fido-history/";
#   ,     
$ndlpath  = "/usr/home/cat/fido-history/nodelist";
#  
$hist     = "/usr/home/cat/fido-history/net${net}history";
#  
%lnode = ();
@history = ();
$j = 0;

#    
mkdir( "$ndlpath", 0775 ) unless( -d "$ndlpath" );
system "rm $ndlpath/* &>/dev/null";
$ndlname = <$diffpath*/NODELIST.*>;
system "cp $ndlname $ndlpath &>/dev/null";

#     
$ndlname = <$ndlpath/NODELIST.*>;
get_node();

#   
while( $nextdir = <$diffpath*> ) {
    #       
    next unless( basename( $nextdir, "*" ) =~ /\d{4}/ );
    #  
    while( $nextdiff = <$nextdir/NODEDIFF.*> ) {
	#   
	while( <$ndlpath/NODELIST.*> ) { $nodelist = $_; }
        system "$diffprog $nodelist $nextdiff";
	#    
	while( <$ndlpath/NODELIST.*> ) { $ndlname = $_; }
	#    
	get_node();
    }
}

#   
process_ndl();

#    
system "rm $ndlpath/* &>/dev/null";
rmdir( $ndlpath );
exit 0;

#    
sub get_node {
    #  
    my ( $i ) = 0;
    my ( $status, $num, $host, $zonenum ) = undef;
    my ( @file, @nodelist ) = ();
    #  
    open( NDL, "$ndlname" ) || die "Sorry, I couldn't open $ndlname: $!\n";
    @nodelist = <NDL>;
    close( NDL ) || die "Sorry, I couldn't close $ndlname: $!\n";
    #   
    $header = $nodelist[0]; chomp( $header ); $header =~ s/\r//; $header = substr( $header, 3, length( $header ) - 10 );
    #       
    foreach ( @nodelist ) {
	next if( /^;.*/ || ! /.*,.*,.*/ ); chomp; s/\r//;
        ( $status, $num ) = split( /,/ );
	#  Zone  Host  
        if( $status =~ /zone/i ) {
	    if( $num == $zone ) { $zonenum = $num; } else { $zonenum = undef; }
	}    
        if( $status =~ /host/i ) {
	    if( $num == $net ) { $host = $num; } else { $host = undef; }
	}    
	#     
        if( $host && $zonenum ) {
	    #   
	    if( $header ) { $file[$i] = ";$header\n"; $i++; $header = undef; }
	    $file[$i] = "$_\n"; $i++;
	}
    }
    if( $#file >= 0 ) {
	#   
	print "\n"; print @file;
	#    
	$history[$j] = [ @file ]; $j++;
    }	
}

sub process_ndl {
    #  
    my ( $i ) = 0;
    my ( @current, @pred ) = ();
    #      
    print "\n\n";
    open( HIST, ">$hist" ) || die "Sorry, I couldn't create $hist: $!\n";
    binmode HIST;
    print HIST "+ - Add node\n- - Delete node\n~ - Change node\n";
    #   
    @current = @{$history[$i]};
    $header = substr( $current[0], 1, length( $current[0] ) ); chomp( $header ); $tmp = "=" x ( length( $header ) - 1 );
    foreach ( @current ) {
        next if( /^;.*/ ); chomp;
	( $status, $node ) = ( split( /,/ ) )[0,1];
        $lnode{"$status*$node"} = "+ $_";
    }
    write_lnode();
    #  
    for( $i = 1; $i <= $#history; $i++ ) {
	@pred = @current;
	@current = @{$history[$i]};
        $header = substr( $current[0], 1, length( $current[0] ) ); chomp( $header ); $tmp = "=" x ( length( $header ) );
        foreach ( @pred ) {
	    next if( /^;.*/ ); chomp;
	    ( $status, $node ) = ( split( /,/ ) )[0,1];
	    $outstr = "- $_";
	    foreach $str ( @current ) {
	        next if( $str =~ /^;.*/ ); chomp( $str );
		( $node1 ) = ( split( /,/, $str ) )[1];
		if( $node == $node1 ) {
		    if( $_ eq $str ) { $outstr = undef; }
		    if( $_ ne $str ) { $outstr = "~ $str"; }
		}
	    }
	    next unless( $outstr );
	    $lnode{"$status*$node"} = "$outstr";
        }
        foreach ( @current ) {
	    next if( /^;.*/ ); chomp;
	    ( $status, $node ) = ( split( /,/ ) )[0,1];
	    $outstr = "+ $_";
	    foreach $str ( @pred ) {
	        next if( $str =~ /^;.*/ ); chomp( $str );
		( $node1 ) = ( split( /,/, $str ) )[1];
		if( $node == $node1 ) { $outstr = undef; }
	    }
	    next unless( $outstr );
	    $lnode{"$status*$node"} = "$outstr";
        }
    write_lnode();
    }
    #   
    close( HIST ) || die "Sorry, I couldn't close $hist: $!\n";
}

sub by_node {
    ( $tmp ) = ( split( /,/, $lnode{$a} ) )[0]; $tmp =~ s/.*\s//; if( $tmp =~ /host/i ) { return -1; }
    ( $tmp ) = ( split( /,/, $lnode{$b} ) )[0]; $tmp =~ s/.*\s//; if( $tmp =~ /host/i ) { return 1; }
    ( $a1 ) = $a =~ /^.*\*(\S+)$/; ( $b1 ) = $b =~ /^.*\*(\S+)$/;
    if( $a1 < $b1 ) { return -1; }
    if( $a1 == $b1 ) { return 0; }
    return 1;
}

sub write_lnode {
    if( keys ( %lnode ) ) {
	print "\n$header\n$tmp\n"; print HIST "\n$header\n$tmp\n"; 
        foreach $key ( sort by_node ( keys ( %lnode ) ) ) {
	    print "$lnode{$key}\n"; print HIST "$lnode{$key}\n"; delete $lnode{$key};
        }	
    }	
}
