
// WWIVSERV Structure Definitions
//
// Copyright (C) 1992, Allen Wittenauer
// All Rights Reserved.
//
// May be used in code, so long as I am given notice

#ifndef __WWIVSERV_H__
#define __WWIVSERV_H__

#include <dos.h>  // for date structure returned by getdate();

#define BETA "4"

// <networkdir>\WWIVSERV\WWIVSERV.DAT
typedef struct {
    unsigned short      moderatornum,   // User num of moderator
                        max_sys,        // max # of systems
                        dead1;          // numeric subtype
    unsigned long       settings;       // settings of the sub
    unsigned char       datafile[9],    // base of name
                        subtypes[6],    // char subtype of the sub
                        subname[56];    // name of the sub
    unsigned short      dayslong,       // days for subscr.lst
                        dayspassed;       // till posted again
    unsigned char       reserve[96];
} wssubrec;

// WWIVSERV\filename.PLT
typedef struct {
    unsigned short      moderatornum,   // User num of moderator
                        max_sys;        // max # of systems
    unsigned long       settings;       // settings of the sub
    unsigned char       reserve[100];   // reserved
} templaterec;


// <network>\WWIVSERV\WWIVSERV.NET
typedef struct {
   unsigned short       subuser, subsys; // Subslist Coordinator
   unsigned long        status;          // network status
   unsigned char       chaincmd[13];     // next in line
   unsigned char        reserve[83];
} wsnetcfgrec;

// <network>\WWIVSERV\SUBSCAN.DAT
typedef struct {
  unsigned short    total,    // how many in this packet
                     type,    //  ---------------------
                              //  Sub      -->  Subtype
                   nettype;   // see way down near the end
  struct date     scandate;   // see DOS.H
} subscanrec;

// <network>\WWIVSERV\SUBSCAN2.DAT
typedef struct {
  unsigned short       total,   // how many in this packet
                     nettype;   // see way down near the end
  struct date       scandate;   // see DOS.H
  unsigned char alphatype[8];   // alpha subtype
  unsigned char reserved[30];   // duh
} alphasubscanrec;

// WWIVSERV\WWIVSERV.CFG
typedef struct {
    unsigned char       registration[31]; // Registration code
    unsigned long       status;           // WWIVSERV Global status's
    unsigned char       logname[13],      // Where to log stuff
                        sysprofile[13];   // The PROFILE file
    unsigned int        version;          // Current version
    unsigned char       reserved[148];    // reserved
} wsconfigrec;

// WWIVSERV\WSMAINT.DAT
typedef struct {
    struct ftime        lastrun;      // last run. duh.
    unsigned long       status;           // bitmapped
    unsigned char       reserved[200];    // reserved
} wsmaintrec;

// Externals with WSMAINT_MINOR have this format
// Command can be:
//     1  == Add
//     2  == Remove
//     3  == Review
//     4  == Info
//     5  == Add to be forwarded
//     6  == Remove to be forwarded
//     7  == Review to be forwarded
//     8  == Info to be forwarded
typedef struct {
    unsigned long       origsys,       // where it came from
                        origuser,
                        forwsys,       // who it is going to
                        subtype,       // what subtype is involved
                                       // if this is 0, then GLOBAL on remove
                        command;       // what command is wanted here
} wsforwardrec;

typedef struct {
    unsigned long       origsys,       // where it came from
                        origuser,
                        forwsys,       // who it is going to
                        command;       // what command is wanted here
   unsigned char        subtype[8],    // subtype
                        reserved[20];  // extrastuff
} wsforwardrec2;

#define ws_clearall     0x00000000L    // Wipe out field
#define ws_reqhumanadd  0x00000001L    // requires sysop to add
#define ws_subclosed    0x00000002L    // the sub is closed to WS
#define ws_postsubrlist 0x00000004L    // post subsc. listing
#define ws_sendmodrmail 0x00000008L    // send the mod'r mail
#define ws_postrules    0x00000010L    // autopost rules
#define ws_sortnfile    0x00000020L    // sort this 'N' file
#define ws_refusereview 0x00000040L    // refuse the REVIEW comm.
#define ws_onlynumone   0x00000080L    // only #1's can access
#define ws_nosubslist   0x00000100L    // Don't put on SUBS.LST
#define ws_catchreq     0x00000200L    // Catch net29+ req's?
#define ws_notags       0x00000400L    // Sub allow taglines?
#define ws_norts        0x00000800L    // sub disallows random titles
#define ws_isreqqable   0x00001000L    // req'able anyway?
#define ws_masterlist   0x00002000L    // honor SLC requests for sub?

#define cfg_forwardsubs 0x00000001L    // Can I forward sub req's
#define cfg_usesysmsg   0x00000002L    // Use GFILES\\SYSTEM.MSG
#define cfg_localscan   0x00000004L    // Perform LINKSCAN stuff?
#define cfg_extnetren   0x00000008L    // Auto-rename external net
#define cfg_userlog     0x00000010L    // Use the user log file
#define cfg_netdat0     0x00000020L    // Use the NETDAT0.LOG
#define cfg_custom      0x00000040L    // User specified
#define cfg_wslogging   0x00000080L    // WWIVSERV-Style
#define cfg_nologging   0x00000100L    // None!
#define cfg_grabreqs    0x00000200L    // process net29 req's
#define cfg_betavers    0x00000400L    // Is this a BETA version?
#define cfg_plzbmod     0x00000800L    // We ignore NETWORKS.DAT
#define cfg_net31stuff  0x00001000L    // net31+ running
#define cfg_nounknown   0x00002000L    // don't show unknown's

#define netcfg_subscan  0x00000001L    // keep subtype scanning data
#define netcfg_subinfo  0x00000002L    // honor SLC requests for net?

#define mtcfg_runtoday  0x00000001L    // has maint run today?

#define OPT_NO_TAG 0x0001 // Sub doesn't allow taglines  T
#define OPT_AUTO   0x0002 // sub has net29+ REQ support  R
#define OPT_WS     0x0004 // sub has WWIVSERV support    !
#define OPT_NO_RT  0x0008 // sub disallows random titles *

#define RULESEXT ".RLZ"    // Rules file
#define SUBSEXT  ".LST"    // subscriber's file
#define INFOEXT  ".INF"    // Information

#define WSMAINT_MINOR   26850     // 7/xxx number
#define WSMAINT_MINOR_S "26850"  //   "     "

#define TOTCHECKS  28  // total number represented here
// general desc. of type               types      for my ref.
//-----------------------------------------------------------
// Deleted Packet(s)                    0/0       values[0]
// Unknown Type(s)                      ?/?       values[1]
// Coordinator Mail(s)                1/0,14,19   values[2]
// ^ not a very good description.  Perhaps Multimail would be better...
// WWIVNEWS.NET(s)                      1/4       values[3]

// E-Mail by Number(s)                  2/0       values[4]
// Post(s)                              3/x       values[5]
// File(s)                              4/x       values[6]
// Pre-Post(s)                          5/x       values[7]

// External(s)                          6/x       values[8]
// WWIVSERV External(s)               6/16850     values[9]
// E-Mail by Name(s)                    7/0       values[10]
// WWIVSERV Mail(s)                     7/*       values[11]

// NETEDIT Thing(s)                     8         values[12]
// SUBS.* Update(s)                    9,1/3      values[13]
// Network Check                       10/?       values[14]
// BBSLIST.* Update(s)                1,11/1      values[15]

// CONNECT.* Update(s)                121/2       values[16]
// VOTESOFT Packet(s)                  17,18      values[17]
// Network Report(s)                  special     values[18]
// Short Message(s)                     15        values[19]

// NetQuote External(s)               6/19964     values[20]
// REQ Add Packet(s)                    16        values[21]
// REQ Drop Packet(s)                   17        values[22]
// REQ Add (Reply) Packet(s)            18        values[23]

// REQ Drop (Reply) Packet(s)           19        values[24]
// SUBS.* Info                          20        values[25]
// Alpha Subtypes                       21        values[26]
// PackScan Packets                 10/1000       values[27]
// ^ This one has been talked about on various WWIVnet subs.  Not sure
//   if it has been implemented yet or not.  Should ask Wayne I guess.

// Internal structure.  Just ignore....
typedef struct {
    unsigned int  subtype,
                  numposts;
} scanrec;

// Internal structure.  Just ignore....
typedef struct {
    unsigned char subtype[8];
    unsigned int  numposts;
} scanrec2;

#endif

