;=======================================================================;
;  Author:          Paul G. Anderson                Date: Dec 6, 1996   ;
;                   <aka> Bubba@2498.WWIVnet                            ;
;                                                                       ;
;  Codename:        UNIXTIME.ASM                                        ;
;  Filename:        UNIXTIME.COM                                        ;
;  Filesize:        1056 bytes                                          ;
;  Memory required: 1056 bytes + 136 bytes for stack                    ;
;  CPU required:    Intel 8086 and up (any IBM compatable)              ;
;  OS:              DOS 3.1 or above                                    ;
;                                                                       ;
;  This writes a batch file called -                                    ;
;                                                                       ;
;  UNIXT001.BAT                                                         ;
;                                                                       ;
;  for WWIV networking that contains the following command line -       ;
;                                                                       ;
;  UNIXT002.BAT 123456789 %1 %2 %3 %4 %5 %6 %7 %8 %9                    ;
;                                                                       ;
;  Where 123456789 is the time in UNIX format                           ;
;                  (number of seconds since 1/1/70)                     ;
;                                                                       ;
;=======================================================================;

;=======================================================================;
;  This assembly code is intended for use with Wolfware Assembly        ;
;  Language Compiler, Ver 2.02, (C) Copyright 1987 by Eric Tauck.       ;
;                                                                       ;
;  Wolfware Assembly Compiler minimum system requirements:              ;
;  an IBM PC or compatible 8086 computer,  MS/PC DOS 2.00 or up,        ;
;  and about 100 kilobytes of free memory.                              ;
;                                                                       ;
;  Wolfware Assembly Compiler (WASM202.ZIP) is available at:            ;
;                                                                       ;
;  1.  The Unicorn Forest BBS (Of course!) (405) 536-5863               ;
;        Logon as GUEST, password GUEST, or whatever you please         ;
;                                                                       ;
;  2.  http://oak.oakland.edu/pub/simtelnet/msdos/asmutl/wasm202.zip    ;
;        and just about any other SimTel mirror site                    ;
;                                                                       ;
;=======================================================================;
 jmp end_of_toot

toot_my_horn db 0Dh, 0Ah,
             db 0Dh, 0Ah,
             db               'UNIXTIME.COM',
             db 0Dh, 0Ah,
             db               'By Paul G. Anderson',
             db 0Dh, 0Ah,
             db               'Dec 6, 1996',
             db 0Dh, 0Ah,
             db               'This Software is Free',
             db 0Dh, 0Ah,
             db 0Dh, 0Ah,

end_of_toot

;-- housekeeping, save the registers

 push BX                    ;push register values onto stack
 push CX
 push DX
 push DI
 push SI
 push DS
 push ES

;--- Returns the current SYSTEM date and day of the week.
;
; registers on entry:
;         AH        2Ah
;
; registers on return:
;         AL            day-of-the-week (number of days since Sunday)
;         CX            year (1980-2099)
;         DH            month (1-12)
;         DL            day (1-31)

;-- render date variables

 mov AH, 2Ah
 int 21h
 mov word system_year, CX         ;store
 cmp CX, 1980
 ja year_is_not_zero
 cmp DH, 1
 ja year_is_not_zero
 jmp days_added
year_is_not_zero
 sub DH, 1                        ;month (0-11)
 mov AL, DH
 cbw
 mov word system_month, AX        ;store
 sub DL, 1                        ;day (0-30)
 mov AL, DL
 cbw
 mov word day_count, AX          ;store

;-- discover the number of years since 1980

 mov AX, CX             ;get ready for devide
 mov CL, 64h            ;devide by 100 decimal (64h)
 div CL                 ;result [example] - AH=96, AL=19
 mov BX, AX             ;result [example] - BH=96, BL=19
 mov AH, 0              ;render the 19
 mov CX, 19
 div CL                 ;if 19 AH=0, if 20 AH=1 (remainder)
 mov CH, 0
 mov CL, AH
  jCXz year_19xx        ;jump if CX is zero

year_20xx
 add BH, 20                  ;add 20 to 2004 = 24 years from 1980
 mov byte year_count, BH     ;store
  jmp year_done

year_19xx
 sub BH, 80                  ;subtract 1980 from 1996 = 16
 mov byte year_count, BH     ;store
  jmp year_done

year_done

;--- convert years to months

 mov AX, 12                  ;12 months in a year
 mul byte year_count         ;AX <-- 12 * 16 (year count) = 192
 add AX, word system_month   ;AX <-- 192 + 11 (November)
 mov word month_count, AX    ;store

add_months

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz february
  jmp days_added

february

 mov AL, byte leap_year_count        ;check for leap year
 add AL, 4
 cbw
 mov CL, 4
 div CL                         ;AX <-- AX / CL  AH=R  AL=Q
 mov CH, 0
 mov CL, AH

  jCXz leap_feb                 ;skip next line if leap year

 mov SI, offset intdouble_28             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz march
  jmp days_added

leap_feb

 mov SI, offset intdouble_29             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz march
  jmp days_added

march

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz april
  jmp days_added

april

 mov SI, offset intdouble_30             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz may
  jmp days_added

may

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz june
  jmp days_added

june

 mov SI, offset intdouble_30             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz july
  jmp days_added

july

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz august
  jmp days_added

august

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz september
  jmp days_added

september

 mov SI, offset intdouble_30             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz october
  jmp days_added

october

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz november
  jmp days_added

november

 mov SI, offset intdouble_30             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz december
  jmp days_added

december

 mov SI, offset intdouble_31             ;string pointer 1st term
 mov DI, offset intdouble_sum            ;string pointer 2nd term
 call intdouble_add                      ;1st term + 2nd term = sum

 dec word month_count

  jnz last_month
  jmp days_added

last_month

 inc byte leap_year_count
  jmp add_months

days_added


;--- add adjustment

    mov SI, offset intdouble_adjust         ;string pointer 1st term
    mov DI, offset intdouble_sum            ;string pointer 2nd term
    call intdouble_add                      ;1st term + 2nd term = sum

 ;end add adjustment

 call add_days
 call set_system_hour
 call add_hours
 call add_minutes
 call add_seconds

 call intdouble_print_to_filestring

 call write_the_file

;-- print unixtime to screen
;-- the function was used in testing and is now commented out

;-- do not uncomment the following two lines without also uncommenting
;-- the function intdouble_print, lines 421 through 456

; mov DI, offset intdouble_sum           ;string pointer
; call intdouble_print                   ;prints elements of string to screen


;-- housekeeping, restore registers before exiting the program

 pop ES                    ;return register values from stack
 pop DS
 pop SI
 pop DI
 pop DX
 pop CX
 pop BX

;-- exit the program

exit_the_program

 mov AH, 4Ch                ;exit program function
 int 21h                    ;execute

;-- end program

;-- function declarations

;function1
write_the_file PROC near

;-- create and open a file

 mov DX, offset file_name   ;identify filename pointer
 sub CX, CX                 ;normal file attribute
 mov AH, 3Ch                ;create a file function
 int 21h                    ;execute
 mov word Handle, AX        ;store new file handle

;-- write to the file

 mov DX, offset local_net_string     ;identify data pointer
 mov CX, 56                          ;identify length of data string
 mov BX, word Handle                 ;identify file handle
 mov AH, 40h                         ;write file function
 int 21h                             ;execute

;-- close the file

 mov BX, word Handle        ;identify file handle
 mov AH, 3eh                ;close file function
 int 21h                    ;execute

 ret
 ENDP                       ;end write_the_file procedure

;function 2
intdouble_add PROC near                 ;procedure label

   mov CX, 16                           ;loop counter
   mov BX, offset intdouble_sum         ;string pointer sum
   add BX, 15
   add SI, 15
   add DI, 15

start_intdouble_add_loop                ;loop begin

   mov DL, byte [SI]                    ;move 1st term to register
   add DL, byte [DI]                    ;add 2nd term to register
   add DL, byte intdouble_carry         ;add carry value if any
   mov byte intdouble_carry, 00h        ;zeroize the used carry value
   mov byte [BX], DL                    ;move register to sum
   push SI
   push DI
   push BX
     cmp DL, 10
     jl less_than_ten

     mov BL, 10                         ;for devide
     mov AL, DL                         ;for devide
     mov AH, 0
     div BL                             ;AL <-- AX/BL, rem = AH
     pop BX
     mov byte [BX], AH                   ;move register to sum
     push BX
     mov byte intdouble_carry, AL        ;put carry value

less_than_ten
   pop BX
   pop DI
   pop SI
   dec BX
   dec SI
   dec DI
   dec CX                               ;decriment loop counter
   jCXz exit_intdouble_add_loop         ;goto loop end if counter is zero
   jmp start_intdouble_add_loop         ;goto loop begin

exit_intdouble_add_loop                 ;loop end

 ret                                    ;return
 ENDP                                   ;end intdouble_add procedure

;----------------- uncomment function call line 316 and 317 and ---------
;----------------- the following function line 421 through 456 ----------
;----------------- for screen display -----------------------------------
;
;
;intdouble_print PROC near             ;procedure label
;
; mov AH, 02h                          ;request 21h DOS service (output character)
; mov CX, 16                           ;counter
;
;start_dont_print_leading_zeros        ;loop begin
;
;   mov DL, [DI]                       ;point to element
;   cmp DL, 0                          ;check if 0
;   ja dont_index                      ;skip if greater greater than zero
;   inc DI                             ;index pointer past a leading zero
;   dec CX                             ;decriment loop counter
;   jCXz exit_intdouble_print_loop     ;goto to loop end if complete
;   jmp start_dont_print_leading_zeros ;goto loop begin
;
;dont_index                            ;loop begin
;
;   mov DL, [DI]                       ;point to element
;   add DL, 30h                        ;convert to ascii
;   int 21h                            ;execute requested DOS service
;
;   inc DI                             ;increment pointer
;   dec CX                             ;decriment loop counter
;   jCXz exit_intdouble_print_loop     ;goto to loop end if complete
;   jmp dont_index                     ;goto loop begin
;
;exit_intdouble_print_loop             ;loop end
;
;   mov AH, 02h                        ;request 21h DOS service (output character)
;   mov DL, 0Dh                        ;<CR>
;   int 21h                            ;execute requested DOS service
;   mov DL, 0Ah                        ;<LF>
;   int 21h                            ;execute requested DOS service
;
; ret                                  ;return
; ENDP                                 ;end intdouble_print procedure

;function4
add_days PROC near

  mov CX, word day_count
  jCXz end_days_added

  mov SI, offset intdouble_1              ;string pointer 1st term
  mov DI, offset intdouble_sum            ;string pointer 2nd term
  call intdouble_add                      ;1st term + 2nd term = sum

  dec word day_count

 call add_days

end_days_added

 ret                                    ;return
 ENDP                                   ;end add_days procedure

;function5
set_system_hour PROC near

      ;--- Returns the current SYSTEM time
      ;
      ; registers on entry:
      ;         AH        2Ch
      ;
      ; registers on return:
      ;         CH            hour (0-23)
      ;         CL            minute (0-59)
      ;         DH            second (0-59)
      ;         DL            hundredths of seconds (0-99)

    mov  AH, 2Ch
    int 21h

    mov byte hour_count, CH
    mov byte minute_count, CL
    mov byte second_count, DH

 ret                                    ;return
 ENDP                                   ;end set_system_hour procedure

;function6
add_hours PROC near

 mov CX, word hour_count
 jCXz end_hours_added

  mov SI, offset intdouble_hour           ;string pointer 1st term
  mov DI, offset intdouble_sum            ;string pointer 2nd term
  call intdouble_add                      ;1st term + 2nd term = sum

  dec word hour_count

 call add_hours

end_hours_added

 ret                                    ;return
 ENDP                                   ;end add_hours procedure

;function7
add_minutes PROC near

 mov CX, word minute_count
 jCXz end_minutes_added

  mov SI, offset intdouble_minute           ;string pointer 1st term
  mov DI, offset intdouble_sum            ;string pointer 2nd term
  call intdouble_add                      ;1st term + 2nd term = sum

  dec word minute_count

 call add_minutes

end_minutes_added

 ret                                    ;return
 ENDP                                   ;end add_minutes procedure

;function8
add_seconds PROC near

 mov CX, word second_count
 jCXz end_seconds_added

  mov SI, offset intdouble_second          ;string pointer 1st term
  mov DI, offset intdouble_sum            ;string pointer 2nd term
  call intdouble_add                      ;1st term + 2nd term = sum

  dec word second_count

 call add_seconds

end_seconds_added

 ret                                    ;return
 ENDP                                   ;end add_seconds procedure

;function9
intdouble_print_to_filestring PROC near             ;procedure label

   mov CX, 16                              ;counter
   mov SI, offset intdouble_sum            ;time string pointer
   mov DI, offset local_net_string         ;file string pointer
   add DI, 13

start_dont_print_leading_zeros_to_string        ;loop begin

   mov DL, byte [SI]                            ;point to time element
   cmp DL, 0                                    ;check if 0
   ja dont_index_print_to_string_counter        ;skip if greater greater than zero
   inc SI                                       ;index pointer past a leading zero
   dec CX                                       ;decriment loop counter
   jCXz exit_intdouble_print_to_string_loop     ;goto to loop end if complete
   jmp start_dont_print_leading_zeros_to_string ;goto loop begin

dont_index_print_to_string_counter              ;loop begin


   mov DL, [SI]                       ;point to element
   add DL, 30h                        ;convert to ascii
   mov byte [DI], DL

   inc SI                             ;increment pointer
   inc DI
   dec CX                             ;decriment loop counter

   jCXz exit_intdouble_print_to_string_loop     ;goto to loop end if complete
   jmp dont_index_print_to_string_counter     ;goto loop begin

exit_intdouble_print_to_string_loop             ;loop end

   mov CX, 27                              ;counter
   mov SI, offset add_var_string           ;variable string pointer

dont_forget_the_variables              ;loop begin


   mov DL, [SI]                       ;point to element
   ;add DL, 30h                        ;convert to ascii
   mov byte [DI], DL

   inc SI                             ;increment pointer
   inc DI
   dec CX                             ;decriment loop counter

   jCXz variables_are_done            ;goto to loop end if complete
   jmp dont_forget_the_variables      ;goto loop begin

variables_are_done                    ;loop end


 ret                                  ;return
 ENDP                                 ;end intdouble_print_to_filestring procedure

;-- end all function declarations

;-- all data

;-- data for write_the_file

local_net_string    db  'UNIXT002.BAT                                            '
;                        12345678901234567890123456789012345678901234567890123456
add_var_string      db  ' %1 %2 %3 %4 %5 %6 %7 %8 %9'
;                        123456789012345678901234567

file_name           db 'UNIXT001.BAT'
Handle              db  00h, 00h

;-- end data for write_the_file


;-- data for unix time

system_year         db  00h, 00h    ;year (1980-2099)
system_month        db  00h, 00h    ;month (0-11)
day_count           db  00h, 00h    ;day loop counter (0-30)
year_count          db  00h         ;number of years since 1980
month_count         db  00h, 00h    ;month loop counter
hour_count          db  00h, 00h    ;(0-23)
minute_count        db  00h, 00h    ;(0-59)
second_count        db  00h, 00h    ;(0-59)

leap_year_count     db  04h         ;duh!

intdouble_carry               db  00h            ;carry while adding
intdouble_term1               ds  16, 00h        ;sixteen zeros
intdouble_term2               ds  16, 00h        ;sixteen zeros

;   1 solar year  = 365 days, 5 hours, 48 minutes, 46 seconds (or)
;   1 solar year  =  31,556,926 seconds
;   4 solar years = 126,227,704 seconds

;   4 calendar years = ( one leap year         ) + ( three non-leap years  )
;   4 calendar years = (366 * 1 * 86,400sec/day) + (365 * 3 * 86,400sec/day)
;   4 calendar years = 126,230,400 seconds

;   four year error is
;   4 calendar years = 126,230,400 seconds
;   4 solar years    = 126,227,704 seconds
;                (-)  ---------------------
;                            2,696 seconds in four years (or)
;                              674 seconds per year (11 min 14 sec)
;
;   Programmers note:  This software is designed to add calendar seconds
;                      using the DOS services "Get System Date" and
;                      "Get System Time".  It can only be as accurate as
;                      your computer.
;
;                      This program is adjusted to match the UNIX time
;                      generated by BBS.EXE v4.24a with the variable
;                      intdouble_adjust, in the last line of code.
;
;                      If you need to callibrate it to another software
;                      (or callibrate it for any other reason) the
;                      data below can be easily tweeked.
;
;                                            Paul G. Anderson




;----- the running total - already loaded with the number of
;      calendar seconds between 1/1/1970 and 1/1/1980

intdouble_sum                 db  0,0,0,0,0,0,0,3,1,5,5,3,2,8,0,0

;----- the number of calendar seconds in a
;      31 day month, 30 day month, 29 day month, and a 28 day month

intdouble_31                  db  0,0,0,0,0,0,0,0,0,2,6,7,8,4,0,0
intdouble_30                  db  0,0,0,0,0,0,0,0,0,2,5,9,2,0,0,0
intdouble_29                  db  0,0,0,0,0,0,0,0,0,2,5,0,5,6,0,0
intdouble_28                  db  0,0,0,0,0,0,0,0,0,2,4,1,9,2,0,0

;----- the number of calendar seconds in
;      1 day, 1 hour, 1 minute, 1 second

intdouble_1                   db  0,0,0,0,0,0,0,0,0,0,0,8,6,4,0,0
intdouble_hour                db  0,0,0,0,0,0,0,0,0,0,0,0,3,6,0,0
intdouble_minute              db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0
intdouble_second              db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1

;----- callibration adjustment to match BBS.EXE
;      (about 1/4 day since 1/1/1970)

intdouble_adjust              db  0,0,0,0,0,0,0,0,0,0,0,2,1,6,0,0

;-- end data for unix time
;-- end all data
;-- end of code
