#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include "tron.h"

#define TITLE "Tron v3.0"
#define LOGFILE "tron.log"
#define DEBUG 1
#ifdef DEBUG
#include "msgtypes.h"
#endif



/* global variables */
net_networks_rec thisnet;       /* net struct for current network */
net_system_list_rec thisboard;  /* sys info struc for this board */
net_system_list_rec thatboard;  /* sys info struc for that board */
char netpath[85];               /* path to network files */
char netname[12];
char buf[CHUNK + 1];            /* generic scratch buffer */
FILE *log;                      /* the tron.log file handle  */
FILE *mail;                     /* file for outgoing mail */
FILE *incomming;                /* incomming file handle */
time_t  now;
int  local;


void main(int argc, char *argv[])
{
	struct tm      *time_now;
	int             netnum;
    int             i;
	char            s[101];

    now = time(NULL);               /* time at start of processing */
    log = fopen(LOGFILE, "at");     /* open the log file */
    if (!log)                       /* serious problem... */
		return;
	time_now = localtime(&now);
    strftime(s, 100,
       "********** Start entry at %X on %x **********\n", time_now);
	fprintf(log, s);

    if (argc < 2)               /* network should pass the net num... */
	{
		local = 1;
		fprintf(log, "Ran TRON locally\n\n");
		clrscr();
        i=0;
        printf("\t\tAvailable Networks:\n\n");
        while(get_net_info(i,&thisnet))
           printf("\t\t   %d)  %s\n",i++,thisnet.name);

        printf("\n\n  Run locally on what net (<CR> or 0 being the first one) : ");
		gets(s);
		netnum = atoi(s);
		if (!get_net_info(netnum, &thisnet)) {
			printf("\nUnable to open network data file !\n");
			fprintf(log, "********** Done **********\n\n");
			fclose(log);
			return;
		}
        strcpy(netname,thisnet.name);
		makepath(netpath, thisnet.dir);
        get_board_info(&thisboard, thisnet.sysnum);
		tron_menu();
		fprintf(log, "********** Done ********** \n\n");
		fclose(log);
		return;
	}
	/* get info for current network from networks.dat, store in "thisnet" */
	netnum = atoi(&argv[1][1]);
	/* skip the decimal point */
	if (!get_net_info(netnum, &thisnet)) {
		fprintf(log, "\nUnable to open network data file !\n");
		printf("\nUnable to open network data file !\n");
		fprintf(log, "********** Done ********** \n\n");
		fclose(log);
		return;
	}
	makepath(netpath, thisnet.dir);
    get_board_info(&thisboard, thisnet.sysnum);
	local = 0;
	checklocal();
	/* process the incomming "local.net" */
	fprintf(log, "********** Done ********** \n\n");
	fclose(log);
}

/* process incomming "local.net" file */
void checklocal(void)
{
	char            tmppath[80];
	/* scratch path buffer */
	FILE           *in;
	/* handle for incomming local.net */
	net_header_rec  temp;
	/* current net packet header */
	strcpy(tmppath, netpath);
	strcat(tmppath, "local.net");
	in = fopen(tmppath, "rb+wb");
	if (!in)
		return;
	/* no local.net - nothing to do  ! */
	fprintf(log, "\n** Processing %s at %s", tmppath, ctime(&now));
	printf("\n** Processing %s at %s", tmppath, ctime(&now));

#ifdef DEBUG
	fprintf(log, "   TO\t  FROM\t\t  DATE\t\t\tTYPE\t\tSIZE\n");
#endif

	/* read a net header rec, store in temp */
	while (fread(&temp, sizeof(net_header_rec), 1, in) != NULL) {
		fseek(in, temp.list_len * 2, SEEK_CUR);
		/* seek past list */

#ifdef DEBUG
		fprintf(log, "%3d@%-4d", temp.touser, temp.tosys);
		fprintf(log, " %3d@%-4d", temp.fromuser, temp.fromsys);
		fprintf(log, "\t%s", daten_to_date(temp.daten));
		if (temp.main_type < 0x01c)
			fprintf(log, "\t%x/%u %s", temp.main_type, temp.minor_type,
				types[temp.main_type]);
		else
			fprintf(log, "\t%x/%d UNKNOWN !", temp.main_type,
				temp.minor_type);
		fprintf(log, "\t%ld (%d)\n", temp.length, temp.method);
#endif

		switch (temp.main_type) {
		case 0x0a:	/**** old extern ****/
            get_board_info(&thatboard, temp.fromsys);
			if (temp.minor_type == 1000) {
				printf("processing packscan 2.3 file...\n");
				process_pak(in, &temp);	/* packscan 2.30 */
			} else {
				printf("processing linker...\n");
				process_lnk(in, &temp);	/* probably Linker */
			}
			break;
		case 0x1b:	/**** new extern ****/
			printf("processing packscan 2.31 file...\n");
            get_board_info(&thatboard, temp.fromsys);
			process_pak(in, &temp);	/* Packscan 2.31 */
			break;
		default:
			fseek(in, temp.length, SEEK_CUR);	/* dunno - skip it */
			break;
		}
	}
	fclose(in);
	fprintf(log, "** End of %s \n", tmppath);
	printf("** End of %s \n", tmppath);
	return;
}


/*** following function ripped off from uedit.c ***/
unsigned char  *daten_to_date(long dt)
{
	struct date     d;
	struct time     t;
	static unsigned char s[9];

	unixtodos(dt, &d, &t);
	sprintf(s, "%02d/%02d/%02d", d.da_mon, d.da_day, (d.da_year - 1900));
	return (s);
}




/*
 * find where a packet should be routed...
 */
int get_board_info(net_system_list_rec * node,unsigned short sys)
{
	FILE           *net;
	char            fn[80], s[81], *tmp;
    int             x,y;

    strcpy(fn, netpath);
    strcat(fn, "bbsdata.ind");
    y=0;
    net = fopen(fn, "rb");
    while (fread(&x,sizeof(int),1,net))
      {
      if(x==sys)
        break;
      y++;
      }
    fclose(net);
    if(x!=sys)
      return 0;
    strcpy(fn, netpath);
    strcat(fn, "bbsdata.net");
    net = fopen(fn, "rb");
    x = fseek(net, (long) (y * sizeof(net_system_list_rec)),
			  SEEK_SET);
    fread(node, sizeof(net_system_list_rec), 1, net);
    fclose(net);
    if (node->sysnum != sys)    /* Double check to make sure
						 * we have the right one */
        return 0;
/*    strcpy(sys_name, "Rick's Cafe'");  */
	return 1;
}


void ssm(unsigned sys, char *msg)
{
	net_header_rec  h;
	FILE           *locmail;
	char            locpath[90];

	h.touser = 1;
	if (sys)
		/* if sys == 0, it 's a local ssm */
		h.tosys = sys;
	else
		h.tosys = thisboard.sysnum;
	h.fromsys = thisboard.sysnum;
	h.fromuser = 1;
	h.length = (unsigned long) strlen(msg) + 1;
	h.main_type = 15;
	h.daten = now;
	h.method = 0;
	h.list_len = 0;
	if (sys) {
		if (mail) {
			fwrite(&h, sizeof(net_header_rec), 1, mail);
			fwrite(msg, strlen(msg) + 1, 1, mail);
		}
	} else {
		strcpy(locpath, netpath);
		strcat(locpath, "local.net");
		locmail = fopen(locpath, "ab");
		fwrite(&h, sizeof(net_header_rec), 1, locmail);
		fwrite(msg, strlen(msg) + 1, 1, locmail);
		fclose(locmail);
	}
	return;
}


int get_net_info(int num, net_networks_rec * rec)
{
	FILE           *in;
	in = fopen("data/networks.dat", "rb");
	if (!in)
		return 0;
	fseek(in, (long) (num * sizeof(net_networks_rec)), SEEK_SET);
    if(!fread(rec, sizeof(net_networks_rec), 1, in))
       {
       fclose(in);
       return 0;
       }
    fclose(in);
	return 1;
}

int get_send_type(void)
{
	int             x;

	while (1) {
		clrscr();
		printf("What do I use?\n\n"
		       "1) Linker\n"
		       "2) Packscan 2.3\n"
		       "3) Packscan 2.31 (CR = this one)\n"
		       "Q) Abort\n\n"
		       "Select : ");
		x = getch();
		printf("\n");
		if (x == '\r')
			x = '3';
		switch (x) {
		case '1':
		case '2':
		case '3':
			return x;
		case 'Q':
		case 'q':
			return 0;
		}
	}
}


void tron_menu(void)
{
	int             x, done = 0, st;
	uploadsrec      up;
	net_header_rec  header;
	char            fpath[201], *tmp;
	char            s[101], s1[101];

	while (!done) {
		clrscr();
        printf("Working with '%s'\n\n",thisnet.name);
        printf("1) Send file\n"
		       "2) Request file\n"
               "3) Request file list \n");
        if(thisnet.sysnum == 1)
            printf("4) Update Network\n");
        printf("Q) Quit\n\n"
               "Make your choice : ");
		x = getch();
		printf("\n");
		switch (x) {
		case '1':
			/* Send a file */
			st = get_send_type();
			if (!st)
				break;
			switch (st) {
			case '1':
				/* linker */
				header.main_type = 0x0a;
				break;
			case '2':
				/* packscan 2.3 */
				header.main_type = 0x0a;
				/*
				 * packout uses this to know it is 2.3 
				 */
				break;
			case '3':
				/* packscan 2.31 */
				header.main_type = 0x1b;
				/* packout uses to know to use 2.31 */
				break;
			}
			printf("\nFile name to send : ");
			gets(s);
			tmp = findfile(&up, s);
			if (tmp) {
				strcpy(fpath, tmp);
				printf("\nTo which system? ");
				gets(s);
                open_mail();
                if (!get_board_info(&thatboard, atoi(s))) {
					printf("Couldn't open board - press key \n");
					getch();
					break;
				}
				if (st == '2' || st == '3')
					packout(fpath, up.description, &header);
				else
					linkout(fpath, up.description);
				fclose(mail);
			}
			printf("Press a key to continue");
			getch();
			break;
		case '2':
			/* Request a file */
			st = get_send_type();
			if (!st)
				break;
			switch (st) {
			case '1':
				/* linker */
				break;
			case '2':
				/* packscan 2.3 */
				header.main_type = 0x0a;
				/*
				 * packout uses this to know it is 2.3 
				 */
				break;
			case '3':
				/* packscan 2.31 */
				header.main_type = 0x1b;
				/* packout uses to know to use 2.31 */
				break;
			}
			printf("\nFile name to request : ");
			gets(s);
			if (!s[0])
				break;
			printf("\nFrom what system number : ");
			gets(s1);
            open_mail();
            if (!get_board_info(&thatboard, atoi(s1))) {
				printf("Couldn't open board - press key \n");
				getch();
				break;
			}
			if (st == '3' || st == '2')
				packreq(s, &header);
			else
				linkreq(s, &header);
			fclose(mail);
			printf("Press a key to continue");
			getch();
			break;
		case '3':
			/* Request a filelist */
			st = get_send_type();
			if (!st)
				break;
			switch (st) {
			case '1':
				/* linker */
				break;
			case '2':
				/* packscan 2.3 */
				header.main_type = 0x0a;
				/*
				 * packout uses this to know it is 2.3 
				 */
				break;
			case '3':
				/* packscan 2.31 */
				header.main_type = 0x1b;
				/* packout uses to know to use 2.31 */
				break;
			}
			printf("\nFrom what system number : ");
			gets(s1);
            open_mail();
            if (!get_board_info(&thatboard, atoi(s1))) {
				printf("Couldn't open board - press key \n");
				getch();
				break;
			}
			if (st == '3' || st == '2') {
					packreq("FILELIST.ALL", &header);
                    fclose(mail);
			} else
				linkreq("", &header);
			printf("Press a key to continue");
			getch();
			break;
        case '4' : netup();break;
        case 'Q':
		case 'q':
			done = 1;
		}
	}			/* while ! done */
}

