#include "tron.h"
#include <stdio.h>
#include <time.h>
#include <dir.h>

struct link
{
	char netname[16];
	char fn[13];
	char des[59];
	int pktnum;
	int oneof;
	unsigned ft;
	unsigned fd;
	char fa;											// ?
};

extern net_networks_rec thisnet;
extern net_system_list_rec thisboard;
extern net_system_list_rec thatboard;

extern char netpath[];
extern FILE *incomming;
extern FILE *mail;
extern FILE *log;
extern time_t now;
extern char buf[];
char *fpath;
static unsigned long sz;

extern int local;


void linkin(FILE * from, net_header_rec * n);
void linkout(char *name, char *des);
void linkreq(char *name, net_header_rec * rh);


void process_lnk(FILE * src, net_header_rec * header)
{
struct link ln;
char mess[101];
uploadsrec up;
open_mail();
printf("Minor type %d\n", header->minor_type);
switch (header->minor_type)
	{
	case 515:
		linkin(src, header);
		break;
	case 513:
		fread(&ln, sizeof(struct link), 1, src);
		fprintf(log, "Linker requested %s\n", ln.fn[0] ? ln.fn : "File List");
		printf("Linker requested %s\n", ln.fn[0] ? ln.fn : "File List");
		if (ln.fn[0])
			{
			fpath = findfile(&up, ln.fn);
			if (fpath)
			linkout(fpath, up.description);
			}
		else
			{
			sprintf(mess, "Files available on %s", thisboard.name);
            linkout(filelist(), mess);
			}
		break;
	default:
		fprintf(log, "unknown linker subtype %d\n", header->minor_type);
		printf("unknown linker subtype %d\n", header->minor_type);
		fseek(src, header->length, SEEK_CUR);
		sprintf(mess, "Tron didn't recognize msg typ %d:%d",
			header->main_type, header->minor_type);
		ssm(header->fromsys, mess);	// Let 'em know ! <g>
		break;
	}
fclose(mail);
return;
}


void linkin(FILE * from, net_header_rec * n)
{
unsigned howlong;
directoryrec dirrec;
FILE *dirs;
char ulpath[94];
struct link l;
char t[14];
struct ffblk ffb;

fread(&l, sizeof(struct link), 1, from);
howlong = (unsigned) n->length - sizeof(struct link);
printf("rec. file %s, %s\n", l.fn, l.des);
printf("howling = %d, pktnum=%d, oneof=%d\n", howlong, l.pktnum, l.oneof);
if (l.pktnum == 1)
	{
	sz = 0;
	dirs = fopen("data/dirs.dat", "rb");
	if (!dirs)
		{
		 fprintf(log, "\nUnable to open directory data file !\n");
		printf("\nUnable to open directory data file !\n");
		}
	else
		{
		fread(&dirrec, sizeof(directoryrec), 1, dirs);
		strcpy(ulpath, dirrec.path);
		strcat(ulpath, l.fn);
		fprintf(log, " **** Processing Linker incomming file %s\n", ulpath);
		printf(" **** Processing Linker incomming file %s\n", ulpath);
		if (l.des[0])
		  {
		  fprintf(log, "Description = %s\n", l.des);
		  printf("Description = %s\n", l.des);
		  }
		if (!findfirst(ulpath, &ffb, 0))
			{
			tmpnam(t);
			fprintf(log, "FILE COLLISION - Incomming %s renamed to %s\n",l.fn, t);
			printf("FILE COLLISION - Incomming %s renamed to %s\n",l.fn, t);
			strcpy(ulpath, dirrec.path);
			strcat(ulpath, t);
			}
		incomming = fopen(ulpath, "wb");
		}
	}
sz += howlong;


if (incomming)
	{
	while (howlong > CHUNK)
		{
		fread(buf, CHUNK, 1, from);
		fwrite(buf, CHUNK, 1, incomming);
		howlong -= CHUNK;
		}
	fread(buf, howlong, 1, from);
	fwrite(buf, howlong, 1, incomming);
	if (l.pktnum == l.oneof)		/* last packet */
		{
		fclose(incomming);
		uploadit(l.fn, l.des, sz, 3);
		}
	}
}



void linkout(char *name, char *des)
{
FILE *foo;
unsigned test;
net_header_rec h;
unsigned numchar, blksize;
unsigned long flength;
struct ffblk tmp;
struct link lnk;
char nt[95], mess[201];
int j;

strcpy(nt, name);
if (findfirst(nt, &tmp, 0))
	{
	 printf("******* File %s not found !\n", nt);
	 if(!local)
		{
		fprintf(log, "******* File %s not found !\n", nt);
		sprintf(mess, "Tron says %s not available on %s", name, thisboard.name);
		ssm(thatboard.sysnum, mess);
		}
	 return;
	}
flength = tmp.ff_fsize;

memset(&lnk, 0, sizeof(struct link));	// first initialize packet
memset(&h, 0, sizeof(net_header_rec));

  /****** setup the network packet header **********/
h.touser = 1;
h.tosys = thatboard.sysnum;
h.fromsys = thisnet.sysnum;
h.fromuser = 1;
h.main_type = 0x0a;
h.minor_type = 515;
h.daten = now;								// rh->daten;
h.method = 0;
h.list_len = 0;

	/******** set up the linker header ************/
strcpy(lnk.fn, tmp.ff_name);	// filename
strcpy(lnk.des, des);
lnk.ft = tmp.ff_ftime;
lnk.fd = tmp.ff_fdate;
lnk.fa = tmp.ff_attrib;

//for(j=0;j<strlen(thisnet.name);j++)
//	lnk.netname[j]=toupper(thisnet.name[j]);
//lnk.netname[j]='\0';
strcpy(lnk.netname,strupr(thisnet.name));

blksize = (unsigned) 32767 - (sizeof(net_header_rec) + sizeof(struct link));
test = (flength / blksize) + 1;	// how many packets ?
lnk.oneof = (long) test;
foo = fopen(nt, "rb");

if (!foo)
	{
	 printf("Unable to open %s\n", nt);
	 if(!local)
		{
		fprintf(log, "Unable to open %s\n", nt);
		sprintf(mess, "Tron says %s is not available on %s", name, thisboard.name);
		ssm(thatboard.sysnum, mess);
		}
	 return;
	}

printf("Sending file %s (%ld bytes)...\n", name, flength);

while (flength > 0)
	{
	numchar = (flength > blksize) ? blksize : flength;
	flength -= numchar;
	h.length = sizeof(struct link) + numchar;
	fwrite(&h, sizeof(net_header_rec), 1, mail);
	lnk.pktnum++;
	fwrite(&lnk, sizeof(struct link), 1, mail);
	while (numchar > 512)
		{
		fread(buf, 512, 1, foo);
		fwrite(buf, 512, 1, mail);// write 512 bytes to output file
		numchar -= 512;
		}
	fread(buf, numchar, 1, foo);
	fwrite(buf, numchar, 1, mail);	// write the rest
	}
fclose(foo);

sprintf(mess, "Sent %s to %s via %d", name, thatboard.name, thatboard.forsys);
fprintf(log, "%s\n", mess);
printf("%s\n", mess);
if(!local)
	 ssm(0, mess);

return;
}


void linkreq(char *name, net_header_rec * rh)
{
net_header_rec h;
struct link lnk;
char nt[95];

strcpy(nt, name);
strupr(nt);
strip_string(nt);
memset(&lnk, 0, sizeof(struct link));	// first initialize packet
memset(&h, 0, sizeof(net_header_rec));
	/****** setup the network packet header **********/
h.touser = 1;
h.tosys = rh->fromsys;
h.fromsys = thisnet.sysnum;
h.fromuser = 1;
h.main_type = 0x0a;
h.minor_type = 513;           // request file (or filelist if name is null)
h.daten = now;								// rh->daten;
h.method = 0;
h.list_len = 0;
	/******** set up the linker header ************/
strcpy(lnk.fn, nt);  // filename
h.length   = sizeof(struct link);
h.fromsys  = thisboard.sysnum;
h.fromuser = 1;
h.tosys    = thatboard.sysnum;
h.touser   = 1;
fwrite(&h, sizeof(net_header_rec), 1, mail);
lnk.pktnum++;
fwrite(&lnk, sizeof(struct link), 1, mail);
fprintf(log, "Requested %s from %s\n", nt[0] ? nt : "Filelist", thatboard.name);
printf("Requested %s from %s\n", nt[0] ? nt : "Filelist", thatboard.name);
return;
}

