/********     utils.c  *****************/

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>
#include <time.h>
#include "tron.h"


extern FILE    *log;
extern FILE    *mail;
extern net_networks_rec thisnet;
extern net_system_list_rec thisboard;
extern net_system_list_rec thatboard;
extern char     mess[];
extern time_t   now;
extern char     netpath[];



extern int      local;

/** generate a file listing **/

char *filelist(void)
{
	FILE           *dirs;
	FILE           *files;
	FILE           *out;
	directoryrec    dirrec;
	uploadsrec      uprec;
	int             i, numf;
	static char     fn[128];
	char            ulpath[128];


	dirs = fopen("data/dirs.dat", "rb");
	if (!dirs) {
		fprintf(log, "\nUnable to open directory data file !\n");
		printf("\nUnable to open directory data file !\n");
		return NULL;
	}
	sprintf(fn, "%sl%d.txt", netpath, thisnet.sysnum);
	out = fopen(fn, "wt");

    fprintf(out, "Files available on %s :\n",thisboard.name);
	printf("Building filelist...\n");

	while (fread(&dirrec, sizeof(directoryrec), 1, dirs)) {
        if(dirrec.dsl < 46)
           {
           strcpy(ulpath, "data/");
           strcat(ulpath, dirrec.filename);
           strcat(ulpath, ".dir");
           fprintf(out, "\n********* %s ***********\n\n", dirrec.name);
           files = fopen(ulpath, "rb");
           fread(&uprec, sizeof(uploadsrec), 1, files);
           numf = uprec.numbytes;  /* numbytes in first record is number
					 * of files */
           i = 1;
           while (fread(&uprec, sizeof(uploadsrec), 1, files)) {
               fprintf(out, "%s %s %6ld %-49.49s\n", uprec.filename,
                 daten_to_date(uprec.daten), uprec.numbytes, uprec.description);
               if (i++ >= numf)
                  break;
           }
     }
  fclose(files);
  }
	printf("\n");
	fclose(dirs);
	fclose(out);
	return fn;
}

char           *
findfile(uploadsrec * u, char *name)
{
	FILE           *dirs;
	FILE           *files;
	directoryrec    dirrec;
	char           *pname;
	char            ulpath[99];
	int             i;
	dirs = fopen("data/dirs.dat", "rb");
	if (!dirs) {
		fprintf(log, "\nUnable to open directory data file !\n");
		printf("\nUnable to open directory data file !\n");
		return NULL;
	}
	strupr(name);
	pname = padname(name);

	fprintf(log, "Searching for %s - ", pname);
	printf("Searching for %s - ", pname);

	while (fread(&dirrec, sizeof(directoryrec), 1, dirs)) {

		strcpy(ulpath, "data/");
		strcat(ulpath, dirrec.filename);
		strcat(ulpath, ".dir");
		files = fopen(ulpath, "rb");
		fseek(files, (long) 0x090, SEEK_SET);
		while (fread(u, sizeof(uploadsrec), 1, files)) {
			if (compare(u->filename, pname) == 1) {
				strcpy(ulpath, dirrec.path);
				for (i = 0; i < strlen(ulpath); i++)
					if (ulpath[i] == 0x5c)
						ulpath[i] = 0x2f;
				strcat(ulpath, unalign(u->filename));
				fclose(files);
				fclose(dirs);

				fprintf(log, "Found!\n");
				printf("Found!\n");

				return ulpath;
			}
		}
		fclose(files);
	}
	printf("\n");
	fprintf(log, "Unable to locate %s\n", name);
	printf("Unable to locate %s\n", name);

	if (!local) {
		sprintf(mess, "Tron says %s not available on %s", name, thisboard.name);
		ssm(thatboard.sysnum, mess);
	}
	fclose(dirs);
	return NULL;
}

int 
uploadit(char *name, char *des, unsigned long size, int by)
{
	FILE           *dirs;
	FILE           *files;
	long            l;
	unsigned long   foo = 0;
	directoryrec    dirrec;
	uploadsrec      uprec, fhead;
	char            ulpath[99];

	/* create the uploadsrec */

	memset(&uprec, 0, sizeof(uploadsrec));
	strcpy(uprec.filename, padname(name));
	strncpy(uprec.description, des, 58);
	uprec.description[58] = 0;
	strcpy(uprec.date, daten_to_date(now));
	switch (by) {
	case 1:
		strcpy(uprec.upby, "Tron/PS 2.30");
		break;
	case 2:
		strcpy(uprec.upby, "Tron/PS 2.31");
		break;
	case 3:
		strcpy(uprec.upby, "Tron/Linker");
		break;
	default:
		strcpy(uprec.upby, "Tron/Unknown !");
		break;
	}
	uprec.filetype = 0;	/* why not ? */
	uprec.numdloads = 0;
	uprec.ownersys = 1;
	uprec.ownerusr = 1;
	uprec.mask = 0;
	uprec.numbytes = size;
	time(&l);
	uprec.daten = l;

	/* get the sysop dirrec filename */

	dirs = fopen("data/dirs.dat", "rb");
	if (!dirs) {
		fprintf(log, "\nUnable to open directory data file !\n");
		printf("\nUnable to open directory data file !\n");
		return 0;
	}
	fread(&dirrec, sizeof(directoryrec), 1, dirs);
	fclose(dirs);

	/* open the sysop dirrec file */

	strcpy(ulpath, "data/");
	strcat(ulpath, dirrec.filename);
	strcat(ulpath, ".dir");
	files = fopen(ulpath, "rb+wb");
	if (!files) {
		fprintf(log, "\nUnable to open %s !\n", ulpath);
		printf("\nUnable to open %s !\n", ulpath);
		return 0;
	}
	/* position file pointer to first unused record */

	fread(&fhead, sizeof(uploadsrec), 1, files);
	foo = fhead.numbytes;
	fseek(files, (long) foo * sizeof(uploadsrec), SEEK_CUR);

	/* and do it ! */

	fwrite(&uprec, sizeof(uploadsrec), 1, files);

	/* update the header */
	time(&l);
	fhead.daten = l;
	++fhead.numbytes;
	rewind(files);
	fwrite(&fhead, sizeof(uploadsrec), 1, files);
	fclose(files);
	return 1;
}


char *padname(char *name)
{
	int             i, j;
	static char     pname[13];
	memset(pname, 0, 12);


    pad_string(name, 12);

	for (i = 0, j = 0; i < 8; i++) {
		if (name[j] != '.') {
			pname[i] = name[j];
			j++;
		} else {
			pname[i] = ' ';
			pname[i + 1] = 0;
		}
	}
	strcat(pname, &name[j]);
	pname[12] = 0;
	return (pname);
}

/*
 * Crc - 32 BIT ANSI X3.66 CRC checksum files Copyright (C) 1986 Gary S.
 * Brown.  You may use this program, or code or tables extracted from it, as
 * desired without restriction. 
 */

#define OK 0
#define ERROR (-1)
#define LINT_ARGS


/* Need an unsigned type capable of holding 32 bits; */
typedef unsigned long int UNS_32_BITS;


static UNS_32_BITS crc_32_tab[] = {	/* CRC polynomial 0xedb88320 */
				   0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L, 0x706af48fL, 0xe963a535L, 0x9e6495a3L,
				   0x0edb8832L, 0x79dcb8a4L, 0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L, 0x90bf1d91L,
				   0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL, 0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L,
				   0x136c9856L, 0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L, 0xfa0f3d63L, 0x8d080df5L,
				   0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L, 0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
				   0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L, 0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L,
				   0x26d930acL, 0x51de003aL, 0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L, 0xb8bda50fL,
				   0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L, 0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL,
				   0x76dc4190L, 0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL, 0x9fbfe4a5L, 0xe8b8d433L,
				   0x7807c9a2L, 0x0f00f934L, 0x9609a88eL, 0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
				   0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL, 0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L,
				   0x65b0d9c6L, 0x12b7e950L, 0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L, 0xfbd44c65L,
				   0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L, 0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL,
				   0x4369e96aL, 0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L, 0xaa0a4c5fL, 0xdd0d7cc9L,
				   0x5005713cL, 0x270241aaL, 0xbe0b1010L, 0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
				   0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L, 0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL,
				   0xedb88320L, 0x9abfb3b6L, 0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L, 0x73dc1683L,
				   0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L, 0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L,
				   0xf00f9344L, 0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL, 0x196c3671L, 0x6e6b06e7L,
				   0xfed41b76L, 0x89d32be0L, 0x10da7a5aL, 0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
				   0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L, 0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL,
				   0xd80d2bdaL, 0xaf0a1b4cL, 0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL, 0x4669be79L,
				   0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L, 0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL,
				   0xc5ba3bbeL, 0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L, 0x2cd99e8bL, 0x5bdeae1dL,
				   0x9b64c2b0L, 0xec63f226L, 0x756aa39cL, 0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
				   0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL, 0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L,
				   0x86d3d2d4L, 0xf1d4e242L, 0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L, 0x18b74777L,
				   0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL, 0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L,
				   0xa00ae278L, 0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L, 0x4969474dL, 0x3e6e77dbL,
				   0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L, 0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
				   0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L, 0xcdd70693L, 0x54de5729L, 0x23d967bfL,
				   0xb3667a2eL, 0xc4614ab8L, 0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL, 0x2d02ef8dL
};

#define UPDC32(octet, crc) (crc_32_tab[((crc) ^ (octet)) & 0xff] ^ ((crc) >> 8))

int             Block = 0;	/* Pad file with 032's to multiple of Block */

unsigned long 
crc32file(char *name)
{
	FILE           *fin;
	register unsigned long oldcrc32;
	/* register unsigned long crc32; */
	register unsigned long oldcrc;
	register        c;
	register long   charcnt;
	register long   l;

	oldcrc32 = 0xFFFFFFFFL;
	charcnt = 0;
	if ((fin = fopen(name, "rb")) == NULL) {
		perror(name);
		return ERROR;
	}
	while ((c = getc(fin)) != EOF) {
		++charcnt;
		oldcrc32 = UPDC32(c, oldcrc32);
	}

	if (ferror(fin)) {
		perror(name);
		fclose(fin);
		return ERROR;
	} else {
		if (Block) {
			for (l = charcnt; l % Block; ++l)
				oldcrc32 = UPDC32(032, oldcrc32);
		}
		/* crc32 = oldcrc32; */
		oldcrc = oldcrc32 = ~oldcrc32;

	}

	fclose(fin);
	return oldcrc;
}

int 
open_mail(void)
{
	char            mailname[128];
	sprintf(mailname, "%sP9.NET", netpath);
	mail = fopen(mailname, "ab");
	if (mail)
		return 1;
	return 0;
}


long 
file_daten(char *filename)
{
	int             fn;

	struct ftime    file;
	struct time     dtime;
	struct date     ddate;


	fn = open(filename, O_RDONLY);
	if (fn != -1) {
		getftime(fn, &file);
		fn = close(fn);

		dtime.ti_hund = 0;
		dtime.ti_min = file.ft_min;
		dtime.ti_hour = file.ft_hour;
		dtime.ti_sec = file.ft_tsec * 2;
		ddate.da_year = file.ft_year + 1980;
		ddate.da_day = file.ft_day;
		ddate.da_mon = file.ft_month;

		return (dostounix(&ddate, &dtime));
	}
	return 0;
}

int 
compare(char *s1, char *s2)
{
	int             ok, i;

	ok = 1;
	for (i = 0; i < 12; i++)
		if ((s1[i] != s2[i]) && (s1[i] != '?') && (s2[i] != '?'))
			ok = 0;
	return (ok);
}

char *unalign(char *filename)
{
	char           *temp, *exttemp;

	temp = strstr(filename, " ");
	if (temp) {
		temp[0] = 0;
		++temp;

		exttemp = strstr(temp, ".");
		if (exttemp)
			strcat(filename, exttemp);
	}
	return (filename);
}

/*Search list for string in 'search', amount_in_list defines the size of list
int search_list(char **list, char *search, int amount_in_list)
{
	int             x = 0;

	while (x < amount_in_list) {
		if (!strcmpi(list[x], search))
			return (x);
		++x;
	}
	return (-1);
}
*/

long 
filesize(FILE * stream)
{
	long            curpos, length;

	curpos = ftell(stream);

	fseek(stream, 0L, SEEK_END);
	length = ftell(stream);

	fseek(stream, curpos, SEEK_SET);

	return length;
}

/* This will 'strip' all white spaces from the front and end of a string
Will turn '     This is me   ' -= >'This is me'
4.23 has a trimstr which will 'trim' the left part of the string */

char *strip_string(char *string)
{
	int             x = 0, y;
	while (isspace(string[x]) && string[x])
		++x;

	y = strlen(string);
	memmove(string, string + x, y - x + 1);
	string[y - x + 1] = 0;

	y = strlen(string);
	--y;

	while (isspace(string[y]) && y >= 0)
		--y;

	string[y + 1] = 0;


	return (string);
}


void 
makepath(char *dest, char *src)
{
	int             i;
	strcpy(dest, src);
	for (i = 0; i < strlen(dest); i++)	/* change "\" to "/" */
		if (dest[i] == 0x5c)
			dest[i] = 0x2f;
	dest[i] = '/';
	dest[++i] = '\0';
}

char *justify_string(char *string, int length, int bg, int type)
{
  int x;

  if(type==JUSTIFY_LEFT) // Left Justify
  {

    // Turncate string if needed
    string[length]=0;
    x=strlen(string);

	 while(x<length)
    {
      string[x]=bg;
      ++x;
    }

    string[x]=0;
    return(string);
  }
  else if(type==JUSTIFY_RIGHT) // Right Justify
  {
    int pos=0;

    string[length]=0;
    x=strlen(string);

    if(x>=length)
      return(string);

    memmove(string+length-x, string, x);

    while(pos<length-x)
    {
      string[pos]=bg;
      ++pos;
	 }

    string[length]=0;
    return(string);
  }
  else if(type==JUSTIFY_CENTER) // Center Justify
  {
    int pos=0;

    string[length]=0;
    x=strlen(string);

    if(x>=length)
      return(string);

    memmove(string+((length-x)/2), string, x);

    while(pos<((length-x)/2))
    {
      string[pos]=bg;
      ++pos;
    }

    pos=x+((length-x)/2);
    while(pos<length)
    {
      string[pos]=bg;
      ++pos;
    }

    string[length]=0;
    return(string);
  }
  else
    return(string);
}

